/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.PacketWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.Module;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.Logic;
import tigase.server.Packet;
import tigase.stats.StatisticHolderImpl;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

public abstract class AbstractPubSubModule
extends StatisticHolderImpl
implements Module {
    protected static final Logger log = Logger.getLogger(AbstractPubSubModule.class.getName());
    @Inject
    protected PubSubConfig config;
    @Inject
    protected Logic logic;
    @Inject
    protected PacketWriter packetWriter;
    @Inject(nullAllowed=false)
    private IPubSubRepository repository;

    public static Element createResultIQ(Element iq) {
        Element e = new Element("iq");
        e.setXMLNS("jabber:client");
        String id = iq.getAttributeStaticStr("id");
        String from = iq.getAttributeStaticStr("from");
        String to = iq.getAttributeStaticStr("to");
        e.addAttribute("type", "result");
        if (to != null) {
            e.addAttribute("from", to);
        }
        if (from != null) {
            e.addAttribute("to", from);
        }
        if (id != null) {
            e.addAttribute("id", id);
        }
        return e;
    }

    public static List<Element> createResultIQArray(Element iq) {
        return AbstractPubSubModule.makeArray(AbstractPubSubModule.createResultIQ(iq));
    }

    @Deprecated
    protected static String findBestJid(String[] allSubscribers, String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        String best = null;
        for (String j : allSubscribers) {
            if (j.equals(jid)) {
                return j;
            }
            if (!bareJid.equals(j)) continue;
            best = j;
        }
        return best;
    }

    public static Collection<BareJID> getActiveSubscribers(AbstractNodeConfig nodeConfig, BareJID[] jids, IAffiliations affiliations, ISubscriptions subscriptions) {
        HashSet<BareJID> result = new HashSet<BareJID>();
        boolean presenceExpired = nodeConfig.isPresenceExpired();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getActiveSubscribers[2,1] subscriptions: {0}, jids: {1}, presenceExpired: {2}", new Object[]{subscriptions, Arrays.asList(jids), presenceExpired});
        }
        if (jids != null) {
            for (BareJID jid : jids) {
                if (presenceExpired) {
                    // empty if block
                }
                UsersAffiliation affiliation = affiliations.getSubscriberAffiliation(jid);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "getActiveSubscribers[2,2] jid: {0}, affiliation: {1}", new Object[]{jid, affiliation});
                }
                if (affiliation.getAffiliation() == Affiliation.outcast) continue;
                Subscription subscription = subscriptions.getSubscription(jid);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "getActiveSubscribers[2,2] jid: {0}, subscription: {1}}", new Object[]{jid, subscription});
                }
                if (subscription != Subscription.subscribed) continue;
                result.add(jid);
            }
        }
        return result;
    }

    public static Collection<BareJID> getActiveSubscribers(AbstractNodeConfig nodeConfig, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        UsersSubscription[] subscribers = subscriptions.getSubscriptionsForPublish();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getActiveSubscribers[1] subscriptions: {0}, subscribers: {1}", new Object[]{subscriptions, Arrays.asList(subscribers)});
        }
        if (subscribers == null) {
            return Collections.emptyList();
        }
        BareJID[] jids = new BareJID[subscribers.length];
        for (int i = 0; i < subscribers.length; ++i) {
            jids[i] = subscribers[i].getJid();
        }
        return AbstractPubSubModule.getActiveSubscribers(nodeConfig, jids, affiliations, subscriptions);
    }

    public static List<Element> makeArray(Element ... elements) {
        LinkedList<Element> result = new LinkedList<Element>();
        for (Element element : elements) {
            result.add(element);
        }
        return result;
    }

    public static List<Packet> makeArray(Packet ... packets) {
        LinkedList<Packet> result = new LinkedList<Packet>();
        for (Packet packet : packets) {
            result.add(packet);
        }
        return result;
    }

    public AbstractPubSubModule() {
        this.setStatisticsPrefix(((Object)((Object)this)).getClass().getSimpleName());
    }

    protected IPubSubRepository getRepository() {
        return this.repository;
    }
}

