/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;

public class Helper {
    public static boolean collectionExists(MongoDatabase db, String collection) {
        for (String name : db.listCollectionNames()) {
            if (!collection.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String createIndexName(Document index) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : index.entrySet()) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append((String)e.getKey());
            sb.append("_");
            sb.append(e.getValue());
        }
        return sb.toString();
    }

    public static void indexCreateOrReplace(MongoCollection<Document> collection, Document index, IndexOptions options) {
        String indexName = Helper.createIndexName(index);
        boolean drop = false;
        for (Document idx : collection.listIndexes()) {
            if (!indexName.equals(idx.getString((Object)"name")) || idx.getBoolean((Object)"unique", false) == options.isUnique()) continue;
            drop = true;
        }
        if (drop) {
            collection.dropIndex(indexName);
        }
        collection.createIndex((Bson)index, options);
    }
}

