/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.xep0136.modules;

import java.util.List;
import tigase.archive.MessageArchiveComponent;
import tigase.archive.QueryCriteria;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.modules.AbstractModule;
import tigase.archive.xep0136.Xep0136QueryParser;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;

@Bean(name="retrieveItems", parent=MessageArchiveComponent.class, active=true)
public class RetrieveItemsModule
extends AbstractModule {
    private static final String RETRIEVE_ELEM = "retrieve";
    @Inject
    private Xep0136ItemHandler itemHandler;
    @Inject
    private Xep0136QueryParser queryParser;
    private TimestampHelper timestampHelper = new TimestampHelper();

    public String[] getFeatures() {
        return new String[0];
    }

    public Criteria getModuleCriteria() {
        return null;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        Element retrieve = packet.getElement().getChild(RETRIEVE_ELEM, "urn:xmpp:archive");
        this.getMessages(packet, retrieve);
    }

    public boolean canHandle(Packet packet) {
        return packet.getElement().getChild(RETRIEVE_ELEM, "urn:xmpp:archive") != null;
    }

    private void getMessages(Packet packet, Element retrieve) throws ComponentException, TigaseStringprepException {
        try {
            QueryCriteria query = (QueryCriteria)this.msg_repo.newQuery();
            query.setUseMessageIdInRsm(false);
            this.queryParser.parseQuery(query, packet);
            this.msg_repo.queryItems(query, this.itemHandler);
            List<Element> items = query.getItems();
            Element retList = new Element("chat");
            if (query.getWith() != null) {
                retList.setAttribute("with", query.getWith().toString());
            }
            if (query.getStart() != null) {
                retList.setAttribute("start", this.timestampHelper.format(query.getStart()));
            }
            retList.setXMLNS("urn:xmpp:archive");
            if (!items.isEmpty()) {
                retList.addChildren(items);
            }
            query.prepareResult(retList);
            this.packetWriter.write(packet.okResult(retList, 0));
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Error retrieving items", e);
        }
    }

    @Bean(name="xep0136ItemHandler", parent=MessageArchiveComponent.class, active=true)
    public static class Xep0136ItemHandler<Q extends QueryCriteria, I extends MessageArchiveRepository.Item>
    implements MAMRepository.ItemHandler<Q, MAMRepository.Item> {
        public void itemFound(Q query, MAMRepository.Item item) {
            if (!(item instanceof MessageArchiveRepository.Item)) {
                throw new RuntimeException("Invalid class of repository item, got = " + item.getClass().getCanonicalName());
            }
            this.itemFound(query, (I)((MessageArchiveRepository.Item)item));
        }

        public void itemFound(Q query, I item) {
            JID from;
            Element itemEl = new Element(item.getDirection().toElementName());
            Element msg = item.getMessage();
            itemEl.addChildren(msg.getChildren());
            if (query.getStart() == null) {
                query.setStart(item.getTimestamp());
                itemEl.setAttribute("secs", "0");
            } else {
                itemEl.setAttribute("secs", String.valueOf((item.getTimestamp().getTime() - query.getStart().getTime()) / 1000L));
            }
            if (item.getWith() != null) {
                itemEl.setAttribute("with", item.getWith());
            }
            if ("groupchat".equals(msg.getAttributeStaticStr("type")) && (from = JID.jidInstanceNS((String)msg.getAttributeStaticStr("from"))) != null && from.getResource() != null) {
                itemEl.setAttribute("name", from.getResource());
            }
            ((QueryCriteria)query).addItem(itemEl);
            if (query.getRsm().getFirst() == null) {
                query.getRsm().setFirst(item.getId());
            }
            query.getRsm().setLast(item.getId());
        }
    }
}

