/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.server;

import java.io.File;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.ServletInfo;
import tigase.http.modules.AbstractModule;
import tigase.http.util.StaticFileServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;

@Bean(name="server", parent=HttpMessageReceiver.class, active=false)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class ServerInfoModule
extends AbstractModule {
    private DeploymentInfo httpDeployment = null;

    @Override
    public String getDescription() {
        return "Server information module";
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        super.start();
        this.httpDeployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setDeploymentName("Server").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        ServletInfo servletInfo = this.httpServer.servlet("StaticServlet", StaticFileServlet.class);
        servletInfo.addInitParam("directory", new File("logs").getAbsolutePath()).addInitParam("index", "/server-info.html").addInitParam("allowed-pattern", "/server-info\\.html").addMapping("/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        super.stop();
    }
}

