/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.JID;

@Bean(name="disco", parent=SessionManager.class, active=true)
public class ServiceDiscovery
extends XMPPProcessorAbstract {
    protected static final String ID = "disco";
    private static final Logger log = Logger.getLogger(ServiceDiscovery.class.getName());
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH, Iq.IQ_QUERY_PATH, Iq.IQ_QUERY_PATH};
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/commands"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/disco#info"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/disco#items"})};

    @Override
    public Authorization canHandle(Packet packet, XMPPResourceConnection conn) {
        if (packet.isServiceDisco()) {
            try {
                if (packet.getStanzaTo() != null && packet.getStanzaTo().getLocalpart() != null && packet.getStanzaTo().getResource() == null && (conn == null || conn.isUserId(packet.getStanzaTo().getBareJID()))) {
                    return null;
                }
            }
            catch (NotAuthorizedException notAuthorizedException) {
                // empty catch block
            }
        }
        return super.canHandle(packet, conn);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getStanzaTo() != null) {
            log.log(Level.FINEST, "forwarding packet to MR" + packet.toString());
            results.offer(packet.copyElementOnly());
        }
    }

    @Override
    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        results.offer(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "The target is unavailable at this time.", true));
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

