/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.EnumSet;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.sys.TigaseRuntime;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.LastActivityAbstract;
import tigase.xmpp.impl.LastActivityMarker;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.HandleStanzaTypes;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Id(value="jabber:iq:last")
@DiscoFeatures(value={"jabber:iq:last"})
@HandleStanzaTypes(value={StanzaType.get})
@Handles(value={@Handle(path={"iq", "query"}, xmlns="jabber:iq:last")})
@Bean(name="jabber:iq:last", parent=LastActivityMarker.class, active=false)
public class LastActivity
extends XMPPProcessorAbstract {
    protected static final String ID = "jabber:iq:last";
    private static final Logger log = Logger.getLogger(LastActivity.class.getName());
    private static final String PROTECTION_LEVEL_KEY = "protection-level";
    private static final EnumSet<RosterAbstract.SubscriptionType> inTypes = EnumSet.of(RosterAbstract.SubscriptionType.both, RosterAbstract.SubscriptionType.from);
    private static final EnumSet<RosterAbstract.SubscriptionType> outTypes = EnumSet.of(RosterAbstract.SubscriptionType.both, RosterAbstract.SubscriptionType.to);
    @ConfigField(desc="Protection level", alias="protection-level")
    private ProtectionLevel protectionLevel = ProtectionLevel.ALL;

    protected static RosterAbstract getRosterUtil() {
        return RosterFactory.getRosterImplementation(true);
    }

    private static Packet preventFromINFLoop(Packet packet) {
        packet.setPacketTo(null);
        return packet;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet);
        }
        super.process(packet, session, repo, results, settings);
    }

    @Override
    public void processFromUserPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Process From user packet: {0}", packet);
        }
        switch (packet.getType()) {
            case get: {
                switch (this.protectionLevel) {
                    case BUDDIES: {
                        if (LastActivity.getRosterUtil() == null) {
                            log.warning("Roster factory returned null");
                            results.offer(LastActivity.preventFromINFLoop(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, false)));
                            break;
                        }
                        try {
                            RosterElement element = LastActivity.getRosterUtil().getRosterElement(session, packet.getStanzaTo());
                            if (element == null || !outTypes.contains((Object)element.getSubscription())) {
                                results.offer(LastActivity.preventFromINFLoop(Authorization.FORBIDDEN.getResponseMessage(packet, null, false)));
                                break;
                            }
                            super.processFromUserPacket(connectionId, packet, session, repo, results, settings);
                        }
                        catch (TigaseDBException | NotAuthorizedException e) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, e.getMessage(), e);
                            }
                            results.offer(LastActivity.preventFromINFLoop(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, false)));
                        }
                        break;
                    }
                    case ALL: {
                        super.processFromUserPacket(connectionId, packet, session, repo, results, settings);
                    }
                }
                break;
            }
            case error: 
            case result: {
                super.processFromUserPacket(connectionId, packet, session, repo, results, settings);
                break;
            }
            default: {
                results.offer(LastActivity.preventFromINFLoop(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", false)));
            }
        }
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing from user to server packet: {0}", packet);
        }
        packet.processedBy(ID);
        if (packet.getPermissions() == Permissions.ADMIN) {
            this.handleLastActivityRequest(packet, TigaseRuntime.getTigaseRuntime().getUptime(), null, results);
        } else {
            results.offer(LastActivity.preventFromINFLoop(Authorization.FORBIDDEN.getResponseMessage(packet, null, false)));
        }
    }

    @Override
    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing null session packet: {0}", packet);
        }
        packet.processedBy(ID);
        switch (packet.getType()) {
            case get: {
                BareJID requestedJid = packet.getStanzaTo().getBareJID();
                try {
                    long last = LastActivityAbstract.getLastActivity(repo, requestedJid);
                    String status = LastActivityAbstract.getStatus(repo, requestedJid);
                    this.handleLastActivityRequest(packet, last, status, results);
                }
                catch (UserNotFoundException e) {
                    results.offer(LastActivity.preventFromINFLoop(Authorization.FORBIDDEN.getResponseMessage(packet, null, false)));
                }
            }
            case error: 
            case result: {
                super.processNullSessionPacket(packet, repo, results, settings);
                break;
            }
            default: {
                results.offer(LastActivity.preventFromINFLoop(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", false)));
            }
        }
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing server session packet: {0}", packet);
        }
        packet.processedBy(ID);
        this.handleLastActivityRequest(packet, TigaseRuntime.getTigaseRuntime().getUptime(), null, results);
    }

    @Override
    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing to user packet: {0}", packet);
        }
        packet.processedBy(ID);
        switch (packet.getType()) {
            case get: {
                long last = LastActivityAbstract.getLastActivity(session, packet);
                String status = LastActivityAbstract.getStatus(session);
                switch (this.protectionLevel) {
                    case BUDDIES: {
                        if (LastActivity.getRosterUtil() == null) {
                            log.warning("Roster factory returned null");
                            results.offer(LastActivity.preventFromINFLoop(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, false)));
                            break;
                        }
                        try {
                            RosterElement element = LastActivity.getRosterUtil().getRosterElement(session, packet.getStanzaFrom());
                            if (element == null || !inTypes.contains((Object)element.getSubscription())) {
                                results.offer(LastActivity.preventFromINFLoop(Authorization.FORBIDDEN.getResponseMessage(packet, null, false)));
                                break;
                            }
                            this.handleLastActivityRequest(packet, last, status, results);
                        }
                        catch (TigaseDBException | NotAuthorizedException e) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, e.getMessage(), e);
                            }
                            results.offer(LastActivity.preventFromINFLoop(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, false)));
                        }
                        break;
                    }
                    case ALL: {
                        this.handleLastActivityRequest(packet, last, status, results);
                    }
                }
                break;
            }
            case error: 
            case result: {
                super.processToUserPacket(packet, session, repo, results, settings);
                break;
            }
            default: {
                results.offer(LastActivity.preventFromINFLoop(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", false)));
            }
        }
    }

    private void handleLastActivityRequest(Packet packet, long last, String status, Queue<Packet> results) throws PacketErrorTypeException {
        if (last >= 0L) {
            long result = (System.currentTimeMillis() - last) / 1000L;
            Packet resp = packet.okResult((Element)null, 0);
            Element q = status == null ? new Element("query", new String[]{"xmlns", "seconds"}, new String[]{ID, "" + result}) : new Element("query", status, new String[]{"xmlns", "seconds"}, new String[]{ID, "" + result});
            resp.getElement().addChild((XMLNodeIfc)q);
            results.offer(resp);
        } else {
            results.offer(LastActivity.preventFromINFLoop(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Unknown last activity time", false)));
        }
    }

    static enum ProtectionLevel {
        ALL,
        BUDDIES;

    }
}

