/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.updater;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.ScheduledTask;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.MessageRouter;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.util.Version;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="update-checker", parent=MessageRouter.class, active=true)
public class UpdatesChecker
extends ScheduledTask {
    public static final String VERSION_REQUEST_KEY = "tigase-server-version";
    public static final String PRODUCTS_REQUEST_KEY = "products";
    private static final Logger log = Logger.getLogger(UpdatesChecker.class.getName());
    private static final String VERSION_URL = "http://update.tigase.net/check/";
    private final Version serverVersion;
    @Inject
    private EventBus eventBus;
    private Version latestCheckedVersion = null;
    @ConfigField(desc="Enables sending XMPP notifications about new version")
    private Boolean notificationsEnabled = true;
    @Inject(nullAllowed=true)
    private ArrayList<ProductInfoIfc> productInfos = new ArrayList();
    @ConfigField(desc="List of receivers JIDs", alias="admins")
    private ConcurrentSkipListSet<BareJID> receivers = new ConcurrentSkipListSet();

    private static Version getVersion(String version) {
        try {
            return Version.of((String)version);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.FINE, "Error parsing version from server");
            return null;
        }
    }

    public static Optional<Version> retrieveCurrentVersionFromServer(Version currentVersion, List<ProductInfoIfc> products, String url, int timeoutInSeconds) {
        Objects.nonNull(currentVersion);
        Objects.nonNull(url);
        try {
            URL u = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)u.openConnection();
            connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(timeoutInSeconds));
            connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(timeoutInSeconds));
            connection.setRequestProperty(VERSION_REQUEST_KEY, currentVersion.toString());
            if (products != null && !products.isEmpty()) {
                String requestProducts = products.stream().filter(productInfoIfc -> productInfoIfc.getProductVersion().isPresent()).map(pi -> String.join((CharSequence)":", pi.getProductId(), pi.getProductVersion().get())).collect(Collectors.joining(";"));
                connection.setRequestProperty(PRODUCTS_REQUEST_KEY, requestProducts);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            return br.lines().map(UpdatesChecker::getVersion).filter(Objects::nonNull).peek(System.out::println).filter(e -> e.compareTo(currentVersion) > 0).findFirst();
        }
        catch (IOException e2) {
            log.log(Level.WARNING, "Can not check updates for URL: " + url, e2);
            return Optional.empty();
        }
    }

    public UpdatesChecker() {
        super(Duration.ofDays(7L), Duration.ofDays(7L));
        Version version;
        try {
            version = Version.of((String)XMPPServer.getImplementationVersion());
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Problem obtaining current version information");
            version = Version.ZERO;
        }
        this.serverVersion = version;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.eventBus != null) {
            this.eventBus.registerAll(this);
        }
    }

    @Override
    public void run() {
        Optional<Version> version = UpdatesChecker.retrieveCurrentVersionFromServer(this.serverVersion, this.productInfos, VERSION_URL, 60);
        version.ifPresent(this::sendNewVersionNotification);
    }

    public void setProductInfos(ArrayList<ProductInfoIfc> productInfos) {
        this.productInfos = productInfos == null ? new ArrayList() : productInfos;
    }

    @HandleEvent
    protected void onUpdatedVersionDiscovered(UpdatedVersionDiscovered event) {
        if (event.getVersion() != null && this.isNewerVersion(event.getVersion())) {
            log.log(Level.CONFIG, "New version updated from cluster");
        }
    }

    private void sendNewVersionNotification(Version v) {
        log.log(Level.CONFIG, "Update available: " + v + " (current version: " + this.serverVersion + ")");
        if (this.notificationsEnabled.booleanValue() && this.isNewerVersion(v)) {
            this.receivers.stream().filter(addr -> !addr.toString().contains("{clusternode}")).filter(addr -> !this.component.getNodesConnectedWithLocal().contains(JID.jidInstanceNS((String)addr.getDomain()))).map(admin -> this.prepareMessage(v, (BareJID)admin)).forEach(p -> this.component.addPacket((Packet)p));
        }
        this.fire(new UpdatedVersionDiscovered(v));
    }

    private void fire(Object event) {
        if (this.eventBus != null) {
            this.eventBus.fire(event);
        }
    }

    private boolean isNewerVersion(Version ver) {
        if (this.latestCheckedVersion == null || ver.compareTo(this.latestCheckedVersion) > 0) {
            this.latestCheckedVersion = ver;
            return true;
        }
        return false;
    }

    private Packet prepareMessage(Version v, BareJID jid) {
        String link = "http://tigase.net/downloads";
        JID sender = JID.jidInstanceNS((String)("updates.checker@" + jid.getDomain()));
        Element message = new Element("message");
        Element subject = new Element("subject", "Updates checker - new version of the Tigase server");
        message.addChild((XMLNodeIfc)subject);
        message.setXMLNS("jabber:client");
        message.setAttribute("type", "normal");
        Element body = new Element("body", "You are currently using: '" + this.serverVersion + "' version of Tigase server. A new version of the server has been released: '" + v + "' and it is available for download at address: " + link + "\n\nThis is automated message generated by updates checking module (you can adjust it's configuration).\n\nYou can adjust frequency of the check by setting 'delay' and 'period' ");
        message.addChild((XMLNodeIfc)body);
        return Packet.packetInstance(message, sender, JID.jidInstance((BareJID)jid));
    }

    public static class UpdatedVersionDiscovered {
        private final Version version;

        UpdatedVersionDiscovered(Version version) {
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }
    }

    public static interface ProductInfoIfc {
        public String getProductId();

        public String getProductName();

        default public Optional<String> getProductVersion() {
            return Optional.ofNullable(this.getClass().getPackage().getImplementationVersion());
        }
    }
}

