/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.collections.CircularFifoQueue;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.stats.StatisticsArchivizerIfc;
import tigase.stats.StatisticsProvider;

public class CounterDataFileLogger
implements StatisticsArchivizerIfc,
ConfigurationChangedAware,
Initializable {
    private static final Logger log = Logger.getLogger(CounterDataFileLogger.class.getName());
    private static final ExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean collectionReady = new AtomicBoolean(false);
    private Charset charset = StandardCharsets.UTF_8;
    @ConfigField(desc="Format of a date time", alias="stats-datetime-format")
    private String dateTimeFormat = "yyyy-MM-dd_HH:mm:ss";
    private DateTimeFormatter dateTimeFormatter;
    @ConfigField(desc="Directory path", alias="stats-directory")
    private String directory = "logs/stats";
    @ConfigField(desc="Name of a file", alias="stats-filename")
    private String filename = "stats";
    @ConfigField(desc="Remaining space in MB resulting in shrinking the collection", alias="automatically-prune-resize-mb")
    private int freeSpaceMB = 100;
    @ConfigField(desc="Remaining space in % resulting in shrinking the collection", alias="automatically-prune-resize-percent")
    private int freeSpacePerCent = 5;
    @ConfigField(desc="Frequency")
    private long frequency = -1L;
    @ConfigField(desc="Should include date time", alias="stats-datetime")
    private boolean includeDateTime = true;
    @ConfigField(desc="Should include unix time", alias="stats-unixtime")
    private boolean includeUnixTime = true;
    @ConfigField(desc="Whether old entries should be pruned automatically", alias="automatically-prune-limit")
    private int limit = 86400;
    private CircularFifoQueue<Path> pathsQueue = null;
    @ConfigField(desc="Whether old entries should be pruned automatically", alias="automatically-prune-old")
    private boolean pruneOldEntries = true;
    @ConfigField(desc="Factor by which collection will be shrunk", alias="automatically-prune-resize-factor")
    private double shrinkFactor = 0.75;
    @ConfigField(desc="Statistics detail level", alias="stats-level")
    private Level statsLevel = Level.ALL;

    private static void deleteFile(Path file) {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                Files.delete(file);
            }
        }
        catch (IOException e) {
            log.log(Level.FINEST, "Error deleting file " + file, e);
        }
    }

    @Override
    public void execute(StatisticsProvider sp) {
        if (this.pruneOldEntries && !this.collectionReady.get()) {
            return;
        }
        ZonedDateTime time = ZonedDateTime.now();
        Path path = Paths.get(this.getPath(time), new String[0]);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Dumping server statistics to: {0}", path);
        }
        Map<String, String> stats = sp.getAllStats(this.statsLevel.intValue());
        stats.put("Statistics time", this.dateTimeFormatter.format(time));
        stats.put("Statistics time (linux)", Long.toString(time.toInstant().toEpochMilli()));
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            String result = stats.entrySet().stream().map(e -> (String)e.getKey() + "\t" + (String)e.getValue()).collect(Collectors.joining("\n"));
            writer.write(result);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "Error dumping server statistics to file", ex);
        }
        if (this.pruneOldEntries) {
            this.pathsQueue.offer((Object)path);
            File file = path.toFile();
            if (this.pathsQueue.limit() > 0 && (file.getUsableSpace() / 1024L / 1024L < (long)this.freeSpaceMB || file.getUsableSpace() * 100L / file.getTotalSpace() < (long)this.freeSpacePerCent)) {
                int newLimit = (int)((double)this.pathsQueue.limit() * this.shrinkFactor);
                log.log(Level.FINEST, "Shrinking stats file history from {0} to {1} (usable space: {2}, total space: {3}", new Object[]{this.limit, newLimit, file.getUsableSpace(), file.getTotalSpace()});
                this.limit = newLimit;
                this.pathsQueue.setLimit(this.limit);
            }
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        Paths.get(this.directory, new String[0]).toFile().mkdirs();
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateTimeFormat);
        if (this.pruneOldEntries) {
            if (this.pathsQueue == null) {
                this.pathsQueue = new CircularFifoQueue(this.limit, CounterDataFileLogger::deleteFile);
                Thread thread = new Thread(() -> {
                    long start = System.currentTimeMillis();
                    log.log(Level.FINE, "Started collecting existing statistics files");
                    try {
                        File[] files = Paths.get(this.directory, new String[0]).toFile().listFiles();
                        if (files != null && files.length > 0) {
                            List existingFilesPaths = Arrays.stream(files).sorted(Comparator.comparing(File::lastModified)).map(File::toPath).collect(Collectors.toList());
                            this.pathsQueue.addAll(existingFilesPaths);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Reading statistics files list", e);
                    }
                    log.log(Level.CONFIG, "Statistics files collection finished in: {0}s ", new Object[]{(System.currentTimeMillis() - start) / 1000L});
                    this.collectionReady.set(true);
                });
                thread.setName("stats-files-reader");
                thread.start();
            } else {
                this.pathsQueue.setLimit(this.limit);
            }
        }
    }

    @Override
    public long getFrequency() {
        return this.frequency;
    }

    @Override
    public void initialize() {
        this.beanConfigurationChanged(Collections.emptyList());
    }

    private String getPath(ZonedDateTime time) {
        return this.directory + "/" + this.filename + (this.includeUnixTime ? "_" + time.toInstant().toEpochMilli() : "") + (this.includeDateTime ? "_" + this.dateTimeFormatter.format(time) : "") + ".txt";
    }
}

