/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.server.bosh.BoshTask;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;

public class BoshIOService
extends XMPPIOService<Object> {
    public static final String EOL = "\r\n";
    private static final String CONNECTION = "Connection: ";
    private static final String CONTENT_TYPE_HEADER = "Content-Type: ";
    private static final String CONTENT_TYPE_LENGTH = "Content-Length: ";
    private static final Logger log = Logger.getLogger(BoshIOService.class.getName());
    private static final String HTTP_OK_RESPONSE = "HTTP/1.1 200 OK\r\n";
    private static final String SERVER = "Server: Tigase Bosh/" + XMPPServer.getImplementationVersion();
    private static final char[] HTTP_CLIENT_ACCESS_POLICY_REQUEST_HEADER = "GET /clientaccesspolicy.xml".toCharArray();
    private final ConfigProvider configProvider;
    private String content_type = "text/xml; charset=utf-8";
    private boolean firstPassCORS = true;
    private boolean firstPassClientAccessPolicy = true;
    private long rid = -1L;
    private UUID sid = null;
    private BoshTask waitTimer = null;

    public BoshIOService(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    public long getRid() {
        return this.rid;
    }

    public void setRid(long rid) {
        this.rid = rid;
    }

    public UUID getSid() {
        return this.sid;
    }

    public void setSid(UUID sid) {
        this.sid = sid;
    }

    public BoshTask getWaitTimer() {
        return this.waitTimer;
    }

    public void setWaitTimer(BoshTask timer) {
        this.waitTimer = timer;
    }

    public void sendErrorAndStop(Authorization errorCode, StreamError streamError, Packet packet, String errorMsg) throws IOException {
        for (XMPPIOProcessor proc : this.processors) {
            proc.streamError(this, streamError);
        }
        String code = "<body type='terminate' condition='" + (streamError != null ? streamError.getCondition() : errorCode.getCondition()) + "' xmlns='http://jabber.org/protocol/httpbind'/>";
        try {
            Packet error = errorCode.getResponseMessage(packet, errorMsg, false);
            code = error.getElement().toString();
        }
        catch (PacketErrorTypeException error) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("HTTP/1.1 ").append(errorCode.getErrorCode()).append(" ");
        sb.append(errorMsg).append(EOL);
        sb.append(CONTENT_TYPE_HEADER).append(this.content_type).append(EOL);
        sb.append(CONTENT_TYPE_LENGTH).append(code.getBytes().length).append(EOL);
        String extra_headers = this.configProvider.getExtraHeaders();
        if (extra_headers != null) {
            sb.append(extra_headers);
        }
        sb.append("Connection: close\r\n");
        sb.append(SERVER).append(EOL);
        sb.append(EOL);
        sb.append(code);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Writing to socket:\n{0}", sb.toString());
        }
        super.writeRawData(sb.toString());
        this.stop();
    }

    public void setContentType(String ct) {
        this.content_type = ct;
    }

    public StringBuilder prepareHeaders(String data) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(HTTP_OK_RESPONSE);
        sb.append(CONTENT_TYPE_HEADER).append(this.content_type).append(EOL);
        if (data != null) {
            sb.append(CONTENT_TYPE_LENGTH).append(data.getBytes().length).append(EOL);
        } else {
            sb.append(CONTENT_TYPE_LENGTH).append("0").append(EOL);
        }
        String extra_headers = this.configProvider.getExtraHeaders();
        if (extra_headers != null) {
            sb.append(extra_headers);
        }
        sb.append(SERVER).append(EOL);
        sb.append(EOL);
        return sb;
    }

    @Override
    public void writeRawData(String data) throws IOException {
        if (data != null && data.startsWith("<body")) {
            StringBuilder sb = this.prepareHeaders(data);
            sb.append(data);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Writing to socket:\n{0}", sb.toString());
            }
            super.writeRawData(sb.toString());
        } else {
            super.writeRawData(data);
        }
        if (this.configProvider.isCloseConnections()) {
            this.stop();
        }
    }

    @Override
    public boolean checkData(char[] data) throws IOException {
        if (data != null && data.length > 7 && data[0] == 'O' && data[1] == 'P' && data[2] == 'T' && data[3] == 'I' && data[4] == 'O' && data[5] == 'N' && data[6] == 'S') {
            this.writeRawData(this.prepareHeaders(null).toString());
            return false;
        }
        if (this.firstPassClientAccessPolicy && data != null && data.length >= HTTP_CLIENT_ACCESS_POLICY_REQUEST_HEADER.length) {
            if (data[0] == 'G' && data[1] == 'E' && data[2] == 'T') {
                boolean ok = true;
                for (int i = 3; ok && i < HTTP_CLIENT_ACCESS_POLICY_REQUEST_HEADER.length; ok &= data[i] == HTTP_CLIENT_ACCESS_POLICY_REQUEST_HEADER[i], ++i) {
                }
                if (ok) {
                    String client_access_policy = this.configProvider.getClientAccessPolicy();
                    this.writeRawData(this.prepareHeaders(client_access_policy).toString() + client_access_policy);
                    this.firstPassClientAccessPolicy = false;
                    return true;
                }
            }
            this.firstPassClientAccessPolicy = false;
        }
        return false;
    }

    public static interface ConfigProvider {
        public boolean isCloseConnections();

        public String getExtraHeaders();

        public String getClientAccessPolicy();
    }
}

