/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.monitor.tasks.AbstractConfigurableTask;

public class ScriptTask
extends AbstractConfigurableTask
implements Initializable {
    private static final Logger log = Logger.getLogger(ScriptTask.class.getName());
    @Inject
    protected Bindings bindings;
    @Inject
    protected ScriptEngineManager scriptEngineManager;
    private ScriptEngine engine;
    private String script;
    private String scriptExtension;

    public Bindings getBindings() {
        return this.bindings;
    }

    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
    }

    public String getScript() {
        return this.script;
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public String getScriptExtension() {
        return this.scriptExtension;
    }

    @Override
    public void initialize() {
    }

    public void setScript(String script, String scriptExtension) {
        this.engine = this.scriptEngineManager.getEngineByExtension(scriptExtension);
        this.script = script;
        this.scriptExtension = scriptExtension;
    }

    @Override
    protected void enable() {
        block2: {
            super.enable();
            try {
                this.engine.eval(this.script, this.bindings);
            }
            catch (ScriptException e) {
                log.log(Level.WARNING, "Execution failed for the monitoring script: {0}", new Object[]{this.getScript()});
                if (!log.isLoggable(Level.FINEST)) break block2;
                log.log(Level.FINEST, "Execution failed for the monitoring script: " + this.getScript(), e);
            }
        }
    }
}

