/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AuthRepository;
import tigase.db.DataRepository;
import tigase.db.DataSource;
import tigase.db.jdbc.DataRepositoryImpl;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaLoader;
import tigase.db.util.SchemaManager;
import tigase.util.Version;
import tigase.util.log.LogFormatter;
import tigase.util.ui.console.CommandlineParameter;
import tigase.util.ui.console.SystemConsole;
import tigase.xmpp.jid.BareJID;

public class DBSchemaLoader
extends SchemaLoader<Parameters> {
    private static final Logger log = Logger.getLogger(DBSchemaLoader.class.getCanonicalName());
    private boolean connection_ok = false;
    private boolean db_ok = false;
    private Parameters params;
    private Map<String, String> replacementMap = new HashMap<String, String>();
    private boolean schema_ok = false;
    private static final List<SchemaLoader.TypeInfo> suppertedTypes = Stream.of(new SchemaLoader.TypeInfo("derby", "Derby (built in database)", "org.apache.derby.jdbc.EmbeddedDriver"), new SchemaLoader.TypeInfo("mysql", "MySQL", "com.mysql.jdbc.Driver"), new SchemaLoader.TypeInfo("postgresql", "PostgreSQL", "org.postgresql.Driver"), new SchemaLoader.TypeInfo("sqlserver", "SQLServer", "net.sourceforge.jtds.jdbc.Driver", "You have selected MS SQL Server as your database. While we provide you, for easy install, with open-source jTDS JDBC driver allowing to connect to MS SQL Server, we recommend using JDBC driver from Microsoft.")).collect(Collectors.toList());

    public static void main(String[] args) {
        SchemaLoader.main(args);
    }

    @Override
    public void init(Parameters params, Optional<SchemaManager.RootCredentialsCache> rootCredentialsCache) {
        params.init(rootCredentialsCache);
        for (PARAMETERS_ENUM p : PARAMETERS_ENUM.values()) {
            String value = null;
            switch (p) {
                case DATABASE_TYPE: {
                    value = params.getDbType();
                    break;
                }
                case DATABASE_HOSTNAME: {
                    value = params.getDbHostname();
                    break;
                }
                case DATABASE_NAME: {
                    value = params.getDbName();
                    break;
                }
                case TIGASE_USERNAME: {
                    value = params.getDbUser();
                    break;
                }
                case TIGASE_PASSWORD: {
                    value = params.getDbPass();
                    break;
                }
                case ROOT_USERNAME: {
                    value = params.getDbRootUser();
                    break;
                }
                case ROOT_PASSWORD: {
                    value = params.getDbRootPass();
                    break;
                }
            }
            if (value == null) continue;
            this.replacementMap.put("${" + p.getName() + "}", value);
        }
        Level lvl = params.logLevel;
        log.setUseParentHandlers(false);
        log.setLevel(lvl);
        Arrays.stream(log.getHandlers()).filter(handler -> handler instanceof ConsoleHandler).findAny().orElseGet(() -> {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(lvl);
            handler.setFormatter(new LogFormatter());
            log.addHandler(handler);
            return handler;
        });
        log.log(Level.CONFIG, "Parameters: {0}", new Object[]{params});
        this.params = params;
    }

    @Override
    public List<SchemaLoader.TypeInfo> getSupportedTypes() {
        return suppertedTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Version, Path> getSchemaFileNames(String schemaId) {
        Path databaseDirectory = Paths.get(this.params.getSchemaDirectory(), new String[0]);
        String databaseType = this.params.getDbType();
        BiPredicate<Path, BasicFileAttributes> predicate = (path, attributes) -> {
            String regex = databaseType + "-" + schemaId + "(-\\d+\\.\\d+\\.\\d+)(-b\\d+)?\\.sql";
            return path.getFileName().toString().matches(regex);
        };
        try (Stream<Path> pathStream = Files.find(databaseDirectory, 1, predicate, FileVisitOption.FOLLOW_LINKS);){
            Map<Version, Path> map = pathStream.map(Path::getFileName).map(filename -> new AbstractMap.SimpleImmutableEntry<Version, Path>(DBSchemaLoader.getVersionFromSchemaFilename(filename, databaseType, schemaId), (Path)filename)).sorted(Comparator.comparing(AbstractMap.SimpleImmutableEntry::getKey, Version.VERSION_COMPARATOR)).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
            return map;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error while getting schema file list: {0}", e.getMessage());
            return Collections.emptyMap();
        }
    }

    static Map<Version, Path> getSchemaFileNamesInRange(Map<Version, Path> paths, Optional<Version> currentVersion, Version requiredVersion) {
        boolean isRequiredFinal = Version.TYPE.FINAL.equals((Object)requiredVersion.getVersionType());
        boolean isCurrentFinal = currentVersion.isPresent() && Version.TYPE.FINAL.equals((Object)currentVersion.get().getVersionType());
        boolean startInclusive = !isCurrentFinal;
        boolean endInclusive = true;
        return paths.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey, Version.VERSION_COMPARATOR)).filter(entry -> !currentVersion.isPresent() || (startInclusive ? ((Version)entry.getKey()).compareTo((Version)currentVersion.get()) >= 0 : ((Version)entry.getKey()).compareTo((Version)currentVersion.get()) > 0)).filter(entry -> endInclusive ? ((Version)entry.getKey()).compareTo(requiredVersion.getBaseVersion()) <= 0 : ((Version)entry.getKey()).compareTo(requiredVersion) < 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> null, TreeMap::new));
    }

    private static Version getVersionFromSchemaFilename(Path v, String dbType, String component) {
        String filename = v.getFileName().toString();
        int start = (dbType + "-" + component + "-").length();
        int end = filename.length() - 4;
        return Version.of((String)filename.substring(start, end));
    }

    @Override
    public Parameters createParameters() {
        return new Parameters();
    }

    @Override
    public void execute(SchemaLoader.Parameters params) {
        if (params instanceof Parameters) {
            Parameters p = (Parameters)params;
            TigaseDBTask[] tasks = p.getQuery() != null ? Tasks.getQueryTasks() : (p.getFile() != null ? Tasks.getSchemaTasks() : Tasks.getTasksInOrder());
            for (TigaseDBTask task : tasks) {
                task.execute(this, p);
            }
        } else {
            throw new RuntimeException("Invalid parameters type!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SchemaLoader.Result validateDBConnection() {
        this.connection_ok = false;
        String db_conn = this.getDBUri(false, true);
        log.log(Level.INFO, "Validating DBConnection, URI: " + db_conn);
        if (db_conn == null) {
            log.log(Level.WARNING, "Missing DB connection URL");
            return SchemaLoader.Result.ok;
        }
        try (Connection conn = DriverManager.getConnection(db_conn);){
            this.logAvailableDrivers();
            conn.close();
            this.connection_ok = true;
            log.log(Level.INFO, "Connection OK");
            SchemaLoader.Result result = SchemaLoader.Result.ok;
            return result;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.getMessage());
            return SchemaLoader.Result.error;
        }
    }

    @Override
    public SchemaLoader.Result shutdown() {
        return this.shutdownDerby();
    }

    public SchemaLoader.Result shutdownDerby() {
        String db_conn = this.getDBUri(false, true);
        if ("derby".equals(this.params.getDbType())) {
            log.log(Level.INFO, "Validating DBConnection, URI: " + db_conn);
            if (db_conn == null) {
                log.log(Level.WARNING, "Missing DB connection URL");
            } else {
                db_conn = db_conn + ";shutdown=true";
                return this.withConnection(db_conn, conn -> {
                    this.connection_ok = true;
                    log.log(Level.INFO, "Connection OK");
                    return SchemaLoader.Result.ok;
                });
            }
        }
        return SchemaLoader.Result.ok;
    }

    @Override
    public SchemaLoader.Result validateDBExists() {
        if (!this.connection_ok) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        this.db_ok = false;
        String db_conn1 = this.getDBUri(true, false);
        log.log(Level.INFO, "Validating whether DB Exists, URI: " + db_conn1);
        if (db_conn1 == null) {
            log.log(Level.WARNING, "Missing DB connection URL");
            return SchemaLoader.Result.error;
        }
        return this.withConnection(db_conn1, conn -> {
            this.db_ok = true;
            log.log(Level.INFO, "Exists OK");
            return SchemaLoader.Result.ok;
        }, e -> this.withConnection(this.getDBUri(false, true), conn -> {
            SchemaLoader.Result result = SchemaLoader.Result.ok;
            try {
                ArrayList<String> queries = this.loadSQLQueries("database/" + this.params.getDbType() + "-installer-create-db.sql");
                for (String query : queries) {
                    log.log(Level.FINE, "Executing query: " + query);
                    if (query.isEmpty()) continue;
                    try {
                        Statement stmt = conn.createStatement();
                        Throwable throwable = null;
                        try {
                            stmt.execute(query);
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (SQLException ex) {
                        result = SchemaLoader.Result.warning;
                        log.log(Level.WARNING, "Query failed: " + ex.getMessage());
                    }
                }
                log.log(Level.INFO, " OK");
                this.db_ok = true;
            }
            catch (IOException ex) {
                log.log(Level.WARNING, ex.getMessage());
                result = SchemaLoader.Result.error;
            }
            return result;
        }));
    }

    @Override
    public SchemaLoader.Result postInstallation() {
        if (!this.connection_ok) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.db_ok) {
            log.log(Level.WARNING, "Database not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.schema_ok) {
            log.log(Level.WARNING, "Database schema is invalid");
            return SchemaLoader.Result.error;
        }
        String db_conn = this.getDBUri(true, true);
        log.log(Level.INFO, "Post Installation, URI: " + db_conn);
        return this.withStatement(db_conn, stmt -> {
            log.log(Level.INFO, "Finalizing...");
            ArrayList<String> queries = this.loadSQLQueries("database/" + this.params.getDbType() + "-installer-post.sql");
            for (String query : queries) {
                if (query.isEmpty()) continue;
                log.log(Level.FINEST, "Executing query: " + query);
                try {
                    stmt.execute(query);
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, "Failed to execute query: " + query);
                    throw ex;
                }
            }
            log.log(Level.INFO, " completed OK");
            return SchemaLoader.Result.ok;
        });
    }

    @Override
    public SchemaLoader.Result printInfo() {
        if (!this.connection_ok) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.db_ok) {
            log.log(Level.WARNING, "Database not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.schema_ok) {
            log.log(Level.WARNING, "Database schema is invalid");
            return SchemaLoader.Result.error;
        }
        return super.printInfo();
    }

    @Override
    public SchemaLoader.Result addXmppAdminAccount(SchemaManager.SchemaInfo schemaInfo) {
        if (!this.connection_ok) {
            log.log(Level.WARNING, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.db_ok) {
            log.log(Level.WARNING, "Database not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.schema_ok) {
            log.log(Level.WARNING, "Database schema is invalid");
            return SchemaLoader.Result.error;
        }
        List<BareJID> jids = this.params.getAdmins();
        if (jids.size() < 1) {
            log.log(Level.WARNING, "Error: No admin users entered");
            return SchemaLoader.Result.warning;
        }
        String pwd = this.params.getAdminPassword();
        if (pwd == null) {
            log.log(Level.WARNING, "Error: No admin password entered");
            return SchemaLoader.Result.warning;
        }
        String dbUri = this.getDBUri(true, true);
        log.log(Level.INFO, "Adding XMPP Admin Account, URI: " + dbUri);
        try {
            DataRepositoryImpl dataSource = new DataRepositoryImpl();
            dataSource.initialize(dbUri);
            SchemaLoader.Result result = this.addUsersToRepository(schemaInfo, dataSource, DataRepository.class, jids, pwd, log);
            if (result == SchemaLoader.Result.ok) {
                log.log(Level.INFO, "All users added");
            }
            return result;
        }
        catch (RepositoryException e) {
            log.log(Level.WARNING, "Error initializing DB" + e);
            return SchemaLoader.Result.error;
        }
    }

    @Override
    public SchemaLoader.Result setComponentVersion(String component, String version) {
        if (!this.connection_ok) {
            log.log(Level.INFO, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (component == null) {
            log.log(Level.WARNING, "Invalid component");
            return SchemaLoader.Result.error;
        }
        if (version == null) {
            log.log(Level.WARNING, "Invalid version");
            return SchemaLoader.Result.error;
        }
        String db_conn = this.getDBUri(true, true);
        log.log(Level.INFO, "Setting version of the component: {0} to: {1} for connection: {2}", new Object[]{component, version, db_conn});
        if (db_conn == null) {
            log.log(Level.WARNING, "Missing DB connection URL");
            return SchemaLoader.Result.error;
        }
        return this.withConnection(db_conn, cmd -> {
            String procedure = "{ call TigSetComponentVersion(?,?) }";
            try (CallableStatement ps = cmd.prepareCall(procedure);){
                ps.setString(1, component);
                ps.setString(2, version);
                ps.executeUpdate();
                ps.close();
                SchemaLoader.Result result = SchemaLoader.Result.ok;
                return result;
            }
            catch (SQLException ex) {
                log.log(Level.WARNING, "Setting version failed: " + procedure + ", " + ex.getMessage());
                return SchemaLoader.Result.warning;
            }
        });
    }

    @Override
    public Optional<Version> getComponentVersionFromDb(String component) {
        if (component == null || component.trim().isEmpty()) {
            log.log(Level.WARNING, "Missing DB connection URL");
            throw new IllegalArgumentException("Wrong component name");
        }
        String db_conn = this.getDBUri(true, true);
        SQLCommand<Connection, Version> versionCommand = cmd -> {
            try (CallableStatement ps = cmd.prepareCall("{ call TigGetComponentVersion( ? ) }");){
                String versionString;
                ps.setString(1, component);
                ResultSet rs = ps.executeQuery();
                if (rs.next() && (versionString = rs.getString(1)) != null) {
                    Version version = Version.of((String)versionString);
                    return version;
                }
                ps.close();
                return null;
            }
            catch (SQLException ex) {
                log.log(Level.WARNING, "Getting version failed: { call TigGetComponentVersion( ? ) }, " + ex.getMessage());
            }
            return null;
        };
        return this.withConnectionGeneric(db_conn, versionCommand, null);
    }

    @Override
    public Optional<Version> getMinimalRequiredComponentVersionForUpgrade(SchemaManager.SchemaInfo schema) {
        if (this.params.isForceReloadSchema()) {
            return Optional.of(Version.ZERO);
        }
        Map<Version, Path> versions = this.getSchemaFileNames(schema.getId());
        if (versions.size() > 1) {
            return versions.keySet().stream().sorted().findFirst();
        }
        return Optional.ofNullable(Version.ZERO);
    }

    @Override
    public SchemaLoader.Result loadSchema(SchemaManager.SchemaInfo schema, String version) {
        log.log(Level.CONFIG, "SchemaInfo:: id: {0}, repositories: {1}; version: {2}", new Object[]{schema.getId(), schema.getRepositories().size(), version});
        if (!this.connection_ok) {
            log.log(Level.CONFIG, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        Optional<Version> currentVersion = this.getComponentVersionFromDb(schema.getId());
        Version requiredVersion = Version.of((String)version);
        SchemaLoader.Result result = schema.isExternal() ? this.loadSchemaFromSQLFiles(schema, currentVersion, requiredVersion) : this.loadSchemaFromClass(schema, currentVersion, requiredVersion);
        if (!currentVersion.isPresent() && SchemaLoader.Result.skipped.equals((Object)result) || SchemaLoader.Result.ok.equals((Object)result)) {
            Version build = new Version.Builder(requiredVersion).setCommit(null).build();
            this.setComponentVersion(schema.getId(), build.toString());
        }
        if (SchemaLoader.Result.skipped.equals((Object)result)) {
            log.log(Level.INFO, "Required schema is already loaded in correct version");
        }
        Optional<String> passwordEncoding = schema.getRepositories().stream().filter(info -> AuthRepository.class.isAssignableFrom(info.getImplementation())).map(this::getDataSourcePasswordEncoding).filter(Objects::nonNull).findFirst();
        passwordEncoding.ifPresent(encoding -> log.log(Level.WARNING, "You have 'password-encoding' property set to " + encoding + ".\nThis setting will no longer work out of the box with this version of Tigase XMPP Server.\nPlease check Tigase XMPP Server Administration Guide, section \"Changes to Schema in v8.0.0\" at http://docs.tigase.org/ for more details."));
        return passwordEncoding.isPresent() ? (result == SchemaLoader.Result.ok ? SchemaLoader.Result.warning : result) : result;
    }

    private SchemaLoader.Result loadSchemaFromClass(SchemaManager.SchemaInfo schema, Optional<Version> currentVersion, Version requiredVersion) {
        SchemaLoader.Result result;
        try {
            String dbUri = this.getDBUri(true, true);
            log.log(Level.CONFIG, "Loading schema {0}, version: {1} into repo: {2}", new Object[]{schema.getId(), requiredVersion, dbUri});
            DataRepositoryImpl dataSource = new DataRepositoryImpl();
            dataSource.initialize(dbUri);
            Set<SchemaLoader.Result> collect = this.getInitializedDataSourceAwareForSchemaInfo(schema, DataSource.class, dataSource, log).filter(clazz -> RepositoryVersionAware.class.isAssignableFrom(clazz.getClass())).map(RepositoryVersionAware.class::cast).map(this.updateSchemaFunction(currentVersion, requiredVersion)).collect(Collectors.toSet());
            result = this.parseResultsSet(collect);
        }
        catch (RepositoryException e) {
            log.log(Level.WARNING, e.getMessage());
            result = SchemaLoader.Result.warning;
        }
        return result;
    }

    private SchemaLoader.Result loadSchemaFromSQLFiles(SchemaManager.SchemaInfo schema, Optional<Version> currentVersion, Version requiredVersion) {
        SchemaLoader.Result result;
        Collection<Path> schemaFiles;
        log.log(Level.CONFIG, "Loading schema {0}, version: {1} from files, current: {2}", new Object[]{schema.getId(), requiredVersion, currentVersion.orElse(Version.ZERO)});
        Map<Version, Path> schemaFileNames = this.getSchemaFileNames(schema.getId());
        if (!this.params.isForceReloadSchema()) {
            schemaFileNames = DBSchemaLoader.getSchemaFileNamesInRange(schemaFileNames, currentVersion, requiredVersion);
        }
        if ((schemaFiles = schemaFileNames.values()).isEmpty()) {
            log.log(Level.FINEST, "Empty schema list");
            result = SchemaLoader.Result.skipped;
        } else {
            log.log(Level.INFO, "Schema files to load: {0}", new Object[]{schemaFiles});
            Set<SchemaLoader.Result> collect = schemaFiles.stream().map(file -> this.loadSchemaFile(file.toString())).collect(Collectors.toSet());
            result = this.parseResultsSet(collect);
        }
        return result;
    }

    private SchemaLoader.Result parseResultsSet(Set<SchemaLoader.Result> collect) {
        SchemaLoader.Result result = collect.size() == 1 ? collect.iterator().next() : (collect.contains((Object)SchemaLoader.Result.error) ? SchemaLoader.Result.error : (collect.contains((Object)SchemaLoader.Result.warning) ? SchemaLoader.Result.warning : SchemaLoader.Result.ok));
        return result;
    }

    private Function<RepositoryVersionAware, SchemaLoader.Result> updateSchemaFunction(Optional<Version> currentVersion, Version requiredVersion) {
        return versionAware -> {
            try {
                return versionAware.updateSchema(currentVersion, requiredVersion);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage());
                return SchemaLoader.Result.warning;
            }
        };
    }

    private String getDataSourcePasswordEncoding(SchemaManager.RepoInfo repoInfo) {
        AtomicReference passwordEncoding = new AtomicReference();
        this.withStatement(repoInfo.getDataSource().getResourceUri(), stmt -> {
            String query = null;
            DataRepository.dbTypes dbTypes2 = DataRepositoryImpl.parseDatabaseType(repoInfo.getDataSource().getResourceUri());
            switch (dbTypes2) {
                case derby: {
                    query = "values TigGetDBProperty('password-encoding')";
                    break;
                }
                case jtds: 
                case sqlserver: {
                    query = "select dbo.TigGetDBProperty('password-encoding')";
                    break;
                }
                default: {
                    query = "select TigGetDBProperty('password-encoding')";
                }
            }
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                passwordEncoding.set(rs.getString(1));
            }
            rs.close();
            return SchemaLoader.Result.ok;
        });
        return (String)passwordEncoding.get();
    }

    private SchemaLoader.Result loadSchema(String schemaId, String version) {
        return SchemaLoader.Result.error;
    }

    @Override
    public SchemaLoader.Result loadSchemaFile(String fileName) {
        if (!this.connection_ok) {
            log.log(Level.INFO, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (!this.db_ok) {
            log.log(Level.INFO, "Database not validated");
            return SchemaLoader.Result.error;
        }
        if (fileName == null) {
            log.log(Level.WARNING, "Error: empty query");
            return SchemaLoader.Result.error;
        }
        String db_conn = this.getDBUri(true, true);
        log.log(Level.INFO, String.format("Loading schema from file(s): %1$s, URI: %2$s", fileName, db_conn));
        return this.withStatement(db_conn, stmt -> {
            ArrayList<String> queries = new ArrayList<String>(this.loadSQLQueries("database/" + fileName));
            for (String query : queries) {
                if (query.isEmpty()) continue;
                log.log(Level.FINEST, "Executing query: " + query);
                try {
                    stmt.execute(query);
                }
                catch (SQLException ex) {
                    if ("derby".equals(this.params.getDbType())) {
                        String lowerQuery = query.toLowerCase().trim();
                        if (("X0Y32".equals(ex.getSQLState()) || "X0Y68".equals(ex.getSQLState())) && (lowerQuery.startsWith("create ") || lowerQuery.startsWith("alter "))) {
                            log.log(Level.FINEST, "Object already exists!");
                            continue;
                        }
                        if ("42Y55".equals(ex.getSQLState()) && lowerQuery.startsWith("drop ")) {
                            log.log(Level.FINEST, "Object already dropped!");
                            continue;
                        }
                    }
                    log.log(Level.SEVERE, "Failed to execute query: " + query);
                    throw ex;
                }
            }
            this.schema_ok = true;
            log.log(Level.INFO, " completed OK");
            return SchemaLoader.Result.ok;
        });
    }

    @Override
    public SchemaLoader.Result destroyDataSource() {
        if (!this.connection_ok) {
            log.log(Level.INFO, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if ("derby".equals(this.params.getDbType())) {
            this.shutdown();
            Path path = Paths.get(this.params.getDbName(), new String[0]);
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
                return SchemaLoader.Result.ok;
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, "Failed to remove path " + path.toString(), ex);
                return SchemaLoader.Result.error;
            }
        }
        String db_conn = this.getDBUri(false, true);
        log.log(Level.INFO, "Dropping database, URI: " + db_conn);
        return this.withStatement(db_conn, stmt -> {
            String query = "drop database " + this.params.getDbName();
            log.log(Level.FINEST, "Executing query: " + query);
            try {
                stmt.execute(query);
                stmt.close();
                return SchemaLoader.Result.ok;
            }
            catch (SQLException ex) {
                log.log(Level.WARNING, "Query failed: " + query + ", " + ex.getMessage());
                return SchemaLoader.Result.warning;
            }
        });
    }

    @Override
    public String getDBUri() {
        return this.getDBUri(true, false);
    }

    @Override
    public List<CommandlineParameter> getCommandlineParameters() {
        ArrayList<CommandlineParameter> options = new ArrayList<CommandlineParameter>();
        options.add(new CommandlineParameter.Builder("T", PARAMETERS_ENUM.DATABASE_TYPE.getName()).description("Database server type").defaultValue(PARAMETERS_ENUM.DATABASE_TYPE.getDefaultValue()).required(true).build());
        options.addAll(this.getSetupOptions());
        options.add(new CommandlineParameter.Builder("F", PARAMETERS_ENUM.FILE.getName()).description("Comma separated list of SQL files that will be processed").build());
        options.add(new CommandlineParameter.Builder("Q", PARAMETERS_ENUM.QUERY.getName()).description("Custom query to be executed").build());
        options.add(new CommandlineParameter.Builder("J", PARAMETERS_ENUM.ADMIN_JID.getName()).description("Comma separated list of administrator JID(s)").build());
        options.add(new CommandlineParameter.Builder("N", PARAMETERS_ENUM.ADMIN_JID_PASS.getName()).description("Password that will be used for the entered JID(s) - one for all configured administrators").secret().build());
        options.add(new CommandlineParameter.Builder(null, PARAMETERS_ENUM.GET_URI.getName()).description("Generate database URI").requireArguments(false).defaultValue(PARAMETERS_ENUM.GET_URI.getDefaultValue()).build());
        options.add(new CommandlineParameter.Builder(null, PARAMETERS_ENUM.IGNORE_MISSING_FILES.getName()).description("Force ignoring missing files errors").defaultValue(PARAMETERS_ENUM.IGNORE_MISSING_FILES.getDefaultValue()).build());
        return options;
    }

    @Override
    public List<CommandlineParameter> getSetupOptions() {
        ArrayList<CommandlineParameter> options = new ArrayList<CommandlineParameter>();
        options.add(new CommandlineParameter.Builder("D", PARAMETERS_ENUM.DATABASE_NAME.getName()).description("Name of the database that will be created and to which schema will be loaded").defaultValue(PARAMETERS_ENUM.DATABASE_NAME.getDefaultValue()).required(true).build());
        options.add(new CommandlineParameter.Builder("H", PARAMETERS_ENUM.DATABASE_HOSTNAME.getName()).description("Address of the database instance").defaultValue(PARAMETERS_ENUM.DATABASE_HOSTNAME.getDefaultValue()).required(true).build());
        options.add(new CommandlineParameter.Builder("U", PARAMETERS_ENUM.TIGASE_USERNAME.getName()).description("Name of the user that will be created specifically to access Tigase XMPP Server").defaultValue(PARAMETERS_ENUM.TIGASE_USERNAME.getDefaultValue()).required(true).build());
        options.add(new CommandlineParameter.Builder("P", PARAMETERS_ENUM.TIGASE_PASSWORD.getName()).description("Password of the user that will be created specifically to access Tigase XMPP Server").defaultValue(PARAMETERS_ENUM.TIGASE_PASSWORD.getDefaultValue()).required(true).secret().build());
        options.add(new CommandlineParameter.Builder("R", PARAMETERS_ENUM.ROOT_USERNAME.getName()).description("Database root account username used to create tigase user and database").defaultValue(PARAMETERS_ENUM.ROOT_USERNAME.getDefaultValue()).required(true).build());
        options.add(new CommandlineParameter.Builder("A", PARAMETERS_ENUM.ROOT_PASSWORD.getName()).description("Database root account password used to create tigase user and database").defaultValue(PARAMETERS_ENUM.ROOT_PASSWORD.getDefaultValue()).secret().required(true).build());
        options.add(new CommandlineParameter.Builder("S", PARAMETERS_ENUM.USE_SSL.getName()).description("Enable SSL support for database connection (if database supports it)").requireArguments(false).defaultValue(PARAMETERS_ENUM.USE_SSL.getDefaultValue()).type(Boolean.class).build());
        switch (this.getType()) {
            case "mysql": {
                options.add(new CommandlineParameter.Builder(null, PARAMETERS_ENUM.USE_LEGACY_DATETIME_CODE.getName()).description("Use legacy datetime code for JDBC connection").requireArguments(true).defaultValue(PARAMETERS_ENUM.USE_LEGACY_DATETIME_CODE.getDefaultValue()).type(Boolean.class).build());
                options.add(new CommandlineParameter.Builder(null, PARAMETERS_ENUM.SERVER_TIMEZONE.getName()).description("Time zone of database server").defaultValue(PARAMETERS_ENUM.SERVER_TIMEZONE.getDefaultValue()).requireArguments(true).build());
                break;
            }
        }
        return options;
    }

    protected SchemaLoader.Result executeSingleQuery(String query) {
        if (!this.connection_ok) {
            log.log(Level.INFO, "Connection not validated");
            return SchemaLoader.Result.error;
        }
        if (query == null) {
            log.log(Level.WARNING, "Error: empty query");
            return SchemaLoader.Result.error;
        }
        String db_conn = this.getDBUri(false, false);
        log.log(Level.INFO, "Executing Simple Query, URI: " + db_conn);
        if (db_conn == null) {
            log.log(Level.WARNING, "Missing DB connection URL");
            return SchemaLoader.Result.error;
        }
        return this.withStatement(db_conn, stmt -> {
            log.log(Level.FINEST, "Executing query: " + query);
            if (!query.isEmpty()) {
                try {
                    stmt.execute(query);
                    stmt.close();
                }
                catch (SQLException ex) {
                    log.log(Level.WARNING, "Query failed: " + query + ", " + ex.getMessage());
                }
            }
            return SchemaLoader.Result.ok;
        });
    }

    private ArrayList<String> loadSQLQueries(String resource) throws IOException {
        log.log(Level.FINER, "Loading queries, resource: {0}", new Object[]{resource});
        ArrayList<String> results = new ArrayList<String>();
        Path p = Paths.get(resource, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            Path srcPath = Paths.get("src/main/" + resource, new String[0]);
            if (!Files.exists(srcPath, new LinkOption[0])) {
                if (this.params.isIgnoreMissingFiles()) {
                    log.log(Level.WARNING, "Provided path: {0} doesn't exist, skipping!", new Object[]{p.toString()});
                    return results;
                }
                throw new IOException("Required file at " + p.toString() + " doesn't exist!");
            }
            p = srcPath;
        }
        String sql_query = "";
        SQL_LOAD_STATE state = SQL_LOAD_STATE.INIT;
        for (String line : Files.readAllLines(p)) {
            switch (state) {
                case INIT: {
                    Matcher matcher;
                    if (line.startsWith("-- QUERY START:")) {
                        sql_query = "";
                        state = SQL_LOAD_STATE.IN_SQL;
                    }
                    if (!line.startsWith("-- LOAD FILE:") || !line.trim().contains("sql") || !(matcher = Pattern.compile("-- LOAD FILE:\\s*(.*\\.sql)").matcher(line)).find()) break;
                    results.addAll(this.loadSQLQueries(matcher.group(1)));
                    break;
                }
                case IN_SQL: {
                    if (line.startsWith("-- QUERY END:")) {
                        state = SQL_LOAD_STATE.INIT;
                        if ((sql_query = sql_query.trim()).endsWith(";")) {
                            sql_query = sql_query.substring(0, sql_query.length() - 1);
                        }
                        if (sql_query.endsWith("//")) {
                            sql_query = sql_query.substring(0, sql_query.length() - 2);
                        }
                        for (Map.Entry<String, String> entry : this.replacementMap.entrySet()) {
                            sql_query = sql_query.replace(entry.getKey(), entry.getValue());
                        }
                        results.add(sql_query);
                    }
                    if (line.isEmpty() || line.trim().startsWith("--")) break;
                    sql_query = sql_query + " " + line.trim();
                    break;
                }
            }
        }
        return results;
    }

    private SchemaLoader.Result withConnection(String db_conn, SQLCommand<Connection, SchemaLoader.Result> cmd) {
        return this.withConnection(db_conn, cmd, null);
    }

    private <R> Optional<R> withConnectionGeneric(String db_conn, SQLCommand<Connection, R> cmd, ExceptionHandler<Exception, R> exceptionHandler) {
        Object result = null;
        try (Connection conn = DriverManager.getConnection(db_conn);){
            this.logAvailableDrivers();
            result = cmd.execute(conn);
            conn.close();
        }
        catch (IOException | SQLException e) {
            SQLException se;
            if (e instanceof SQLException && ((se = (SQLException)e).getErrorCode() == 50000 && "XJ015".equals(se.getSQLState()) || se.getErrorCode() == 45000 && "08006".equals(se.getSQLState()))) {
                System.out.println("Derby shut down normally");
                log.log(Level.INFO, "Derby shut down normally");
                return Optional.empty();
            }
            if (exceptionHandler != null) {
                return Optional.of(exceptionHandler.handleException(e));
            }
            log.log(Level.SEVERE, "\n\n\n=====\nFailure: " + e.getMessage() + "\n=====\n\n");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.SEVERE, "Failure: " + e.getMessage(), e);
            }
            return Optional.empty();
        }
        return Optional.ofNullable(result);
    }

    private void logAvailableDrivers() {
        String availableDrivers = Collections.list(DriverManager.getDrivers()).stream().map(driver -> driver.getClass().getName() + "[" + driver.getMajorVersion() + "." + driver.getMinorVersion() + "]").collect(Collectors.joining(" ,"));
        log.log(Level.FINE, "DriverManager (available drivers): {0}", availableDrivers);
    }

    private SchemaLoader.Result withConnection(String db_conn, SQLCommand<Connection, SchemaLoader.Result> cmd, ExceptionHandler<Exception, SchemaLoader.Result> exceptionHandler) {
        Optional<SchemaLoader.Result> result = this.withConnectionGeneric(db_conn, cmd, exceptionHandler);
        return result.orElse(SchemaLoader.Result.error);
    }

    private SchemaLoader.Result withStatement(String dbConn, SQLCommand<Statement, SchemaLoader.Result> cmd) {
        return this.withConnection(dbConn, conn -> {
            try (Statement stmt = conn.createStatement();){
                SchemaLoader.Result result = (SchemaLoader.Result)((Object)((Object)cmd.execute(stmt)));
                return result;
            }
        });
    }

    private String getDBUri(boolean includeDbName, boolean useRootCredentials) {
        String db_uri = "jdbc:";
        String database = this.params.getDbType();
        String USERNAME = useRootCredentials ? this.params.getDbRootUser() : this.params.getDbUser();
        String PASSWORD = useRootCredentials ? this.params.getDbRootPass() : this.params.getDbPass();
        switch (database) {
            case "sqlserver": {
                db_uri = db_uri + "jtds:sqlserver:";
                break;
            }
            default: {
                db_uri = db_uri + database + ":";
            }
        }
        switch (database) {
            case "derby": {
                db_uri = db_uri + this.params.getDbName() + ";create=true";
                break;
            }
            case "sqlserver": {
                db_uri = db_uri + "//" + this.params.getDbHostname();
                if (includeDbName) {
                    db_uri = db_uri + ";databaseName=" + this.params.getDbName();
                }
                db_uri = db_uri + ";user=" + USERNAME;
                if (PASSWORD != null && !PASSWORD.isEmpty()) {
                    db_uri = db_uri + ";password=" + PASSWORD;
                }
                db_uri = db_uri + ";schema=dbo";
                db_uri = db_uri + ";lastUpdateCount=false";
                db_uri = db_uri + ";cacheMetaData=false";
                if (!Boolean.TRUE.equals(this.params.isUseSSL())) break;
                db_uri = db_uri + ";encrypt=true";
                break;
            }
            case "postgresql": {
                db_uri = db_uri + "//" + this.params.getDbHostname() + "/";
                if (includeDbName) {
                    db_uri = db_uri + this.params.getDbName();
                } else if (useRootCredentials) {
                    db_uri = db_uri + "postgres";
                }
                db_uri = db_uri + "?user=" + USERNAME;
                if (PASSWORD != null && !PASSWORD.isEmpty()) {
                    db_uri = db_uri + "&password=" + PASSWORD;
                }
                if (Boolean.TRUE.equals(this.params.isUseSSL())) {
                    db_uri = db_uri + "&useSSL=true";
                    break;
                }
                if (!Boolean.FALSE.equals(this.params.isUseSSL())) break;
                db_uri = db_uri + "&useSSL=false";
                break;
            }
            case "mysql": {
                db_uri = db_uri + "//" + this.params.getDbHostname() + "/";
                if (includeDbName) {
                    db_uri = db_uri + this.params.getDbName();
                }
                db_uri = db_uri + "?user=" + USERNAME;
                if (PASSWORD != null && !PASSWORD.isEmpty()) {
                    db_uri = db_uri + "&password=" + PASSWORD;
                }
                if (Boolean.TRUE.equals(this.params.isUseSSL())) {
                    db_uri = db_uri + "&useSSL=true";
                } else if (Boolean.FALSE.equals(this.params.isUseSSL())) {
                    db_uri = db_uri + "&useSSL=false";
                }
                if (!this.params.isUseLegacyDatetimeCode().booleanValue()) {
                    db_uri = db_uri + "&useLegacyDatetimeCode=" + this.params.isUseLegacyDatetimeCode();
                }
                if (this.params.getServerTimezone() == null) break;
                db_uri = db_uri + "&serverTimezone=" + this.params.getServerTimezone();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown database type: " + database);
            }
        }
        return db_uri;
    }

    public static class Parameters
    implements SchemaLoader.Parameters {
        private String adminPassword;
        private List<BareJID> admins;
        private String dbHostname = null;
        private String dbName = null;
        private String dbPass = null;
        private String dbRootPass;
        private String dbRootUser;
        private String dbType;
        private String dbUser = null;
        private String file;
        private Boolean ingoreMissingFiles = false;
        private Level logLevel = Level.CONFIG;
        private String query;
        private String serverTimezone = null;
        private Boolean useLegacyDatetimeCode = false;
        private Boolean useSSL = null;
        private boolean forceReloadSchema = false;
        private String schemaDirectory = "database/";

        private static String getProperty(Properties props, PARAMETERS_ENUM param) {
            return props.getProperty(param.getName(), null);
        }

        private static String getPropertyWithDefault(Properties props, PARAMETERS_ENUM param) {
            return props.getProperty(param.getName(), param.getDefaultValue());
        }

        private static <T> T getProperty(Properties props, PARAMETERS_ENUM param, Function<String, T> converter) {
            String tmp = Parameters.getProperty(props, param);
            if (tmp == null) {
                return null;
            }
            return converter.apply(tmp);
        }

        private static <T> T getPropertyWithDefault(Properties props, PARAMETERS_ENUM param, Function<String, T> converter) {
            String tmp = Parameters.getPropertyWithDefault(props, param);
            if (tmp == null) {
                return null;
            }
            return converter.apply(tmp);
        }

        @Override
        public String getAdminPassword() {
            return this.adminPassword;
        }

        @Override
        public List<BareJID> getAdmins() {
            return this.admins == null ? Collections.emptyList() : this.admins;
        }

        public String getDbRootPass() {
            return this.dbRootPass;
        }

        public String getDbRootUser() {
            return this.dbRootUser;
        }

        public String getDbType() {
            return this.dbType;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getDbHostname() {
            return this.dbHostname;
        }

        public String getDbUser() {
            return this.dbUser;
        }

        public String getDbPass() {
            return this.dbPass;
        }

        @Override
        public boolean isForceReloadSchema() {
            return this.forceReloadSchema;
        }

        @Override
        public void setForceReloadSchema(boolean forceReloadSchema) {
            this.forceReloadSchema = forceReloadSchema;
        }

        public boolean isIgnoreMissingFiles() {
            return this.ingoreMissingFiles;
        }

        public Boolean isUseSSL() {
            return this.useSSL;
        }

        public Boolean isUseLegacyDatetimeCode() {
            return this.useLegacyDatetimeCode;
        }

        public String getServerTimezone() {
            return this.serverTimezone;
        }

        public String getSchemaDirectory() {
            return this.schemaDirectory;
        }

        @Override
        public void setSchemaDirectory(String schemaDirectory) {
            this.schemaDirectory = schemaDirectory;
        }

        @Override
        public void parseUri(String uri) {
            int idx = uri.indexOf(":", 5);
            this.dbType = uri.substring(5, idx);
            if ("jtds".equals(this.dbType)) {
                this.dbType = "sqlserver";
            }
            String rest = null;
            switch (this.dbType) {
                case "derby": {
                    this.dbName = uri.substring(idx + 1, uri.indexOf(";"));
                    break;
                }
                case "sqlserver": {
                    idx = uri.indexOf("//", idx) + 2;
                    rest = uri.substring(idx);
                    block34: for (String x : rest.split(";")) {
                        if (!x.contains("=")) {
                            this.dbHostname = x;
                            continue;
                        }
                        String[] p = x.split("=");
                        switch (p[0]) {
                            case "databaseName": {
                                this.dbName = p[1];
                                continue block34;
                            }
                            case "user": {
                                this.dbUser = p[1];
                                continue block34;
                            }
                            case "password": {
                                this.dbPass = p[1];
                                continue block34;
                            }
                            case "encrypt": {
                                this.useSSL = Boolean.valueOf(p[1]);
                            }
                        }
                    }
                    break;
                }
                default: {
                    idx = uri.indexOf("//", idx) + 2;
                    rest = uri.substring(idx);
                    idx = rest.indexOf("/");
                    this.dbHostname = rest.substring(0, idx);
                    rest = rest.substring(idx + 1);
                    idx = rest.indexOf("?");
                    this.dbName = rest.substring(0, idx);
                    rest = rest.substring(idx + 1);
                    this.useLegacyDatetimeCode = true;
                    block35: for (String x : rest.split("&")) {
                        String[] p = x.split("=");
                        if (p.length < 2) continue;
                        switch (p[0]) {
                            case "user": {
                                this.dbUser = p[1];
                                continue block35;
                            }
                            case "password": {
                                this.dbPass = p[1];
                                continue block35;
                            }
                            case "useSSL": {
                                this.useSSL = Boolean.valueOf(p[1]);
                                continue block35;
                            }
                            case "useLegacyDatetimeCode": {
                                this.useLegacyDatetimeCode = Boolean.valueOf(p[1]);
                                continue block35;
                            }
                            case "serverTimezone": {
                                this.serverTimezone = p[1];
                                continue block35;
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void setProperties(Properties props) {
            this.logLevel = Parameters.getPropertyWithDefault(props, PARAMETERS_ENUM.LOG_LEVEL, Level::parse);
            this.ingoreMissingFiles = Parameters.getProperty(props, PARAMETERS_ENUM.IGNORE_MISSING_FILES, Boolean::valueOf);
            this.admins = Parameters.getProperty(props, PARAMETERS_ENUM.ADMIN_JID, tmp -> Arrays.stream(tmp.split(",")).map(BareJID::bareJIDInstanceNS).collect(Collectors.toList()));
            this.adminPassword = Parameters.getProperty(props, PARAMETERS_ENUM.ADMIN_JID_PASS);
            this.dbType = Parameters.getProperty(props, PARAMETERS_ENUM.DATABASE_TYPE);
            this.dbName = Parameters.getProperty(props, PARAMETERS_ENUM.DATABASE_NAME);
            this.dbHostname = Parameters.getProperty(props, PARAMETERS_ENUM.DATABASE_HOSTNAME);
            this.dbUser = Parameters.getProperty(props, PARAMETERS_ENUM.TIGASE_USERNAME);
            this.dbPass = Parameters.getProperty(props, PARAMETERS_ENUM.TIGASE_PASSWORD);
            this.useSSL = Parameters.getProperty(props, PARAMETERS_ENUM.USE_SSL, Boolean::parseBoolean);
            this.useLegacyDatetimeCode = Parameters.getProperty(props, PARAMETERS_ENUM.USE_LEGACY_DATETIME_CODE, tmp -> Boolean.parseBoolean(tmp));
            this.serverTimezone = Parameters.getProperty(props, PARAMETERS_ENUM.SERVER_TIMEZONE);
            this.dbRootUser = Parameters.getProperty(props, PARAMETERS_ENUM.ROOT_USERNAME);
            this.dbRootPass = Parameters.getProperty(props, PARAMETERS_ENUM.ROOT_PASSWORD);
            this.file = Parameters.getProperty(props, PARAMETERS_ENUM.FILE);
            this.query = Parameters.getProperty(props, PARAMETERS_ENUM.QUERY);
            this.forceReloadSchema = Parameters.getPropertyWithDefault(props, PARAMETERS_ENUM.FORCE_RELOAD_ALL_SCHEMA_FILES, Boolean::valueOf);
        }

        @Override
        public void setAdmins(List<BareJID> admins, String password) {
            this.admins = admins;
            this.adminPassword = password;
        }

        @Override
        public void setDbRootCredentials(String username, String password) {
            this.dbRootUser = username;
            this.dbRootPass = password;
            if (this.dbRootUser == null && this.dbRootPass == null) {
                this.dbRootUser = this.dbUser;
                this.dbRootPass = this.dbPass;
            }
        }

        @Override
        public Level getLogLevel() {
            return this.logLevel;
        }

        @Override
        public void setLogLevel(Level level) {
            this.logLevel = level;
        }

        public Boolean getIngoreMissingFiles() {
            return this.ingoreMissingFiles;
        }

        public void setIngoreMissingFiles(Boolean ingoreMissingFiles) {
            this.ingoreMissingFiles = ingoreMissingFiles;
        }

        public String toString() {
            return "[" + Arrays.stream(this.getClass().getDeclaredFields()).map(field -> {
                Object value;
                String result = field.getName() + ": ";
                try {
                    field.setAccessible(true);
                    value = field.get(this);
                }
                catch (Exception ex) {
                    value = "Error!";
                }
                return result + value;
            }).collect(Collectors.joining(", ")) + "]";
        }

        protected void init(Optional<SchemaManager.RootCredentialsCache> rootCredentialsCache) {
            if (this.dbRootUser == null || this.dbRootPass == null) {
                SchemaManager.RootCredentials credentials;
                SchemaManager.RootCredentials rootCredentials = credentials = rootCredentialsCache.isPresent() ? rootCredentialsCache.get().get(this.dbHostname) : null;
                if (credentials != null) {
                    this.dbRootUser = credentials.user;
                    this.dbRootPass = credentials.password;
                } else if (!"derby".equals(this.dbType)) {
                    SystemConsole console = new SystemConsole();
                    console.writeLine((Object)"");
                    if (this.dbRootUser == null) {
                        this.dbRootUser = console.readLine("Database root account username used to create tigase user and database at " + this.dbHostname + " : ");
                    }
                    if (this.dbRootPass == null) {
                        this.dbRootPass = new String(console.readPassword("Database root account password used to create tigase user and database at " + this.dbHostname + " : "));
                    }
                    rootCredentialsCache.ifPresent(cache -> cache.set(this.dbHostname, new SchemaManager.RootCredentials(this.dbRootUser, this.dbRootPass)));
                }
            }
        }

        private String getFile() {
            return this.file;
        }

        private String getQuery() {
            return this.query;
        }
    }

    static interface TigaseDBTask {
        public String getDescription();

        public void execute(DBSchemaLoader var1, Parameters var2);
    }

    public static interface SQLCommand<C, R> {
        public R execute(C var1) throws SQLException, IOException;
    }

    public static interface ExceptionHandler<T extends Exception, R> {
        public R handleException(T var1);
    }

    static enum Tasks implements TigaseDBTask
    {
        VALIDATE_CONNECTION("Checking connection to the database"){

            @Override
            public void execute(DBSchemaLoader helper, Parameters params) {
                helper.validateDBConnection();
            }
        }
        ,
        VALIDATE_DB_EXISTS("Checking if the database exists"){

            @Override
            public void execute(DBSchemaLoader helper, Parameters params) {
                helper.validateDBExists();
            }
        }
        ,
        VALIDATE_DB_SCHEMA("Checking the database schema"){

            @Override
            public void execute(DBSchemaLoader helper, Parameters params) {
                SchemaManager.getDefaultDataSourceAndSchemas(helper.getDBUri()).values().stream().findAny().ifPresent(schemas -> schemas.forEach(schema -> helper.loadSchema((SchemaManager.SchemaInfo)schema, schema.getVersion().get().toString())));
            }
        }
        ,
        ADD_ADMIN_XMPP_ACCOUNT("Adding XMPP admin accounts"){

            @Override
            public void execute(DBSchemaLoader helper, Parameters params) {
                SchemaManager.getDefaultDataSourceAndSchemas(helper.getDBUri()).values().stream().findAny().ifPresent(schemas -> schemas.stream().filter(schema -> "server".equals(schema.getId())).findAny().ifPresent(helper::addXmppAdminAccount));
            }
        }
        ,
        EXECUTE_SIMPLE_QUERY("Executing simple single query"){

            @Override
            public void execute(DBSchemaLoader helper, Parameters params) {
                helper.executeSingleQuery(params.getQuery());
            }
        }
        ,
        LOAD_SCHEMA_FILE("Loading schema file from provided file"){

            @Override
            public void execute(DBSchemaLoader helper, Parameters params) {
                helper.loadSchemaFile(params.getFile());
            }
        }
        ,
        POST_INSTALLATION("Post installation actions"){

            @Override
            public void execute(DBSchemaLoader helper, Parameters params) {
                helper.postInstallation();
            }
        }
        ,
        SHUTDOWN_DATABASE("Shutting Down Database"){

            @Override
            public void execute(DBSchemaLoader helper, Parameters params) {
                helper.shutdownDerby();
            }
        }
        ,
        PRINT_INFO_TASK("Database Configuration Details"){

            @Override
            public void execute(DBSchemaLoader helper, Parameters params) {
                helper.printInfo();
            }
        };

        private final String description;

        public static TigaseDBTask[] getQueryTasks() {
            return new TigaseDBTask[]{VALIDATE_CONNECTION, EXECUTE_SIMPLE_QUERY, SHUTDOWN_DATABASE};
        }

        public static TigaseDBTask[] getSchemaTasks() {
            return new TigaseDBTask[]{VALIDATE_CONNECTION, VALIDATE_DB_EXISTS, LOAD_SCHEMA_FILE, POST_INSTALLATION, SHUTDOWN_DATABASE, PRINT_INFO_TASK};
        }

        public static TigaseDBTask[] getTasksInOrder() {
            return new TigaseDBTask[]{VALIDATE_CONNECTION, VALIDATE_DB_EXISTS, VALIDATE_DB_SCHEMA, ADD_ADMIN_XMPP_ACCOUNT, POST_INSTALLATION, SHUTDOWN_DATABASE, PRINT_INFO_TASK};
        }

        private Tasks(String description) {
            this.description = description;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static enum SQL_LOAD_STATE {
        INIT,
        IN_SQL;

    }

    public static enum PARAMETERS_ENUM {
        DATABASE_TYPE("dbType", "mysql"),
        SCHEMA_VERSION("schemaVersion", "8-0"),
        DATABASE_NAME("dbName", "tigasedb"),
        DATABASE_HOSTNAME("dbHostname", "localhost"),
        TIGASE_USERNAME("dbUser", "tigase_user"),
        TIGASE_PASSWORD("dbPass", "tigase_pass"),
        ROOT_USERNAME("rootUser", "root"),
        ROOT_PASSWORD("rootPass", "root"),
        LOG_LEVEL("logLevel", "CONFIG"),
        USE_SSL("useSSL", "false"),
        GET_URI("getURI", "false"),
        QUERY("query", null),
        FILE("file", null),
        ADMIN_JID("adminJID", null),
        ADMIN_JID_PASS("adminJIDpass", null),
        IGNORE_MISSING_FILES("ignoreMissingFiles", "false"),
        FORCE_RELOAD_ALL_SCHEMA_FILES("forceReloadAllSchemaFiles", "false"),
        DATABASE_OPTIONS("dbOptions", null),
        USE_LEGACY_DATETIME_CODE("useLegacyDatetimeCode", "false"),
        SERVER_TIMEZONE("serverTimezone", null);

        private String defaultValue = null;
        private String name = null;

        private PARAMETERS_ENUM(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

