/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.auth.credentials.Credentials;
import tigase.auth.credentials.entries.PlainCredentialsEntry;
import tigase.db.AuthorizationException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.xmpp.jid.BareJID;

public interface AuthRepository
extends Repository {
    public static final String DATA_KEY = "data";
    public static final String DIGEST_ID_KEY = "digest-id";
    public static final String DIGEST_KEY = "digest";
    public static final String MACHANISM_KEY = "mechanism";
    public static final String PASSWORD_KEY = "password";
    public static final String PROTOCOL_KEY = "protocol";
    public static final String PROTOCOL_VAL_NONSASL = "nonsasl";
    public static final String PROTOCOL_VAL_SASL = "sasl";
    public static final String REALM_KEY = "realm";
    public static final String RESULT_KEY = "result";
    public static final String SERVER_NAME_KEY = "server-name";
    public static final String USER_ID_KEY = "user-id";
    public static final String USERNAME_KEY = "username";

    public void addUser(BareJID var1, String var2) throws TigaseDBException;

    public AccountStatus getAccountStatus(BareJID var1) throws TigaseDBException;

    default public Credentials getCredentials(BareJID user, String username) throws TigaseDBException {
        String password = this.getPassword(user);
        if (password != null) {
            return new SingleCredential(user, this.getAccountStatus(user), new PlainCredentialsEntry(password));
        }
        return null;
    }

    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public String getPassword(BareJID var1) throws TigaseDBException;

    public String getResourceUri();

    default public Collection<String> getUsernames(BareJID user) throws TigaseDBException {
        return Collections.emptyList();
    }

    public long getUsersCount();

    public long getUsersCount(String var1);

    default public boolean isMechanismSupported(String domain, String mechanism) {
        return "PLAIN".equals(mechanism);
    }

    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    default public boolean isUserDisabled(BareJID user) throws TigaseDBException {
        AccountStatus s = this.getAccountStatus(user);
        return s == AccountStatus.disabled;
    }

    public void loggedIn(BareJID var1) throws TigaseDBException;

    public void logout(BareJID var1) throws TigaseDBException;

    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public boolean otherAuth(Map<String, Object> var1) throws TigaseDBException, AuthorizationException;

    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public void queryAuth(Map<String, Object> var1);

    default public void removeCredential(BareJID user, String username) throws TigaseDBException {
    }

    public void removeUser(BareJID var1) throws TigaseDBException;

    public void setAccountStatus(BareJID var1, AccountStatus var2) throws TigaseDBException;

    default public void setCredentialsCodecs(CredentialsEncoderBean encoder, CredentialsDecoderBean decoder) {
    }

    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    default public void setUserDisabled(BareJID user, Boolean value) throws TigaseDBException {
        AccountStatus status = this.getAccountStatus(user);
        if (status == AccountStatus.active || status == AccountStatus.disabled) {
            this.setAccountStatus(user, value != false ? AccountStatus.disabled : AccountStatus.active);
        }
    }

    default public void updateCredential(BareJID user, String username, String password) throws TigaseDBException {
        this.updatePassword(user, password);
    }

    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public void updatePassword(BareJID var1, String var2) throws TigaseDBException;

    public static class SingleCredential
    implements Credentials {
        private final AccountStatus accountStatus;
        private final Credentials.Entry entry;
        private final BareJID user;

        public SingleCredential(BareJID user, AccountStatus accountStatus, Credentials.Entry entry) {
            this.user = user;
            this.entry = entry;
            this.accountStatus = accountStatus;
        }

        @Override
        public Credentials.Entry getEntryForMechanism(String mechanism) {
            if (mechanism.equals(this.entry.getMechanism())) {
                return this.entry;
            }
            return null;
        }

        @Override
        public Credentials.Entry getFirst() {
            return this.entry;
        }

        @Override
        public BareJID getUser() {
            return this.user;
        }

        @Override
        public boolean isAccountDisabled() {
            return this.accountStatus == AccountStatus.disabled;
        }
    }

    public static class DefaultCredentials
    implements Credentials {
        private static final Logger log = Logger.getLogger(DefaultCredentials.class.getCanonicalName());
        private final AccountStatus accountStatus;
        private final CredentialsDecoderBean decoder;
        private final List<RawEntry> entries;
        private final BareJID user;

        public DefaultCredentials(BareJID user, AccountStatus accountStatus, List<RawEntry> entries, CredentialsDecoderBean decoderBean) {
            this.accountStatus = accountStatus;
            this.user = user;
            this.entries = entries;
            this.decoder = decoderBean;
        }

        @Override
        public Credentials.Entry getEntryForMechanism(String mechanism) {
            for (RawEntry entry : this.entries) {
                if (!entry.isForMechanism(mechanism)) continue;
                try {
                    return this.decoder.decode(this.user, mechanism, entry.getValue());
                }
                catch (NoSuchAlgorithmException ex) {
                    log.log(Level.WARNING, "Could not decode credentials for " + mechanism, ex);
                }
            }
            return null;
        }

        @Override
        public Credentials.Entry getFirst() {
            if (this.entries.isEmpty()) {
                return null;
            }
            RawEntry entry = this.entries.get(0);
            try {
                return this.decoder.decode(this.user, entry.getMechanism(), entry.getValue());
            }
            catch (NoSuchAlgorithmException ex) {
                log.log(Level.WARNING, "Could not decode credentials for " + entry.getMechanism(), ex);
                return null;
            }
        }

        @Override
        public BareJID getUser() {
            return this.user;
        }

        @Override
        public boolean isAccountDisabled() {
            return this.accountStatus == AccountStatus.disabled;
        }

        public static class RawEntry
        implements Credentials.RawEntry {
            private final String mechanism;
            private final String value;

            public RawEntry(String mechanism, String value) {
                this.mechanism = mechanism;
                this.value = value;
            }

            @Override
            public String getMechanism() {
                return this.mechanism;
            }

            @Override
            public String getValue() {
                return this.value;
            }
        }
    }

    public static enum AccountStatus {
        active(1),
        disabled(0),
        pending(-2),
        system(-1),
        vip(2),
        paid(3);

        private static final HashMap<Integer, AccountStatus> statuses;
        private final int value;

        public static AccountStatus byValue(int value) {
            return statuses.get(value);
        }

        private AccountStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            statuses = new HashMap();
            for (AccountStatus v : AccountStatus.values()) {
                statuses.put(v.getValue(), v);
            }
        }
    }
}

