/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.modules;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.Module;
import tigase.component.responses.ResponseManager;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;

@Bean(name="stanzaProcessor", active=true)
public class StanzaProcessor {
    private Logger log = Logger.getLogger(this.getClass().getName());
    @Inject(type=Module.class, nullAllowed=true)
    private List<Module> modules;
    @Inject
    private ResponseManager responseManager;
    @Inject
    private PacketWriter writer;

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules == null ? Collections.emptyList() : modules;
    }

    public ResponseManager getResponseManager() {
        return this.responseManager;
    }

    public void setResponseManager(ResponseManager responseManager) {
        this.responseManager = responseManager;
    }

    public PacketWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PacketWriter writer) {
        this.writer = writer;
    }

    public void processPacket(Packet packet) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Received: " + packet.getElement());
        }
        try {
            boolean handled;
            Runnable responseHandler = this.responseManager.getResponseHandler(packet);
            if (responseHandler != null) {
                handled = true;
                responseHandler.run();
            } else {
                handled = this.process(packet);
            }
            if (!handled) {
                StanzaType type;
                String t = packet.getElement().getAttributeStaticStr("type");
                StanzaType stanzaType = type = t == null ? null : StanzaType.valueof(t);
                if (type != StanzaType.error) {
                    throw new ComponentException(Authorization.FEATURE_NOT_IMPLEMENTED);
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(packet.getElemName() + " stanza with type='error' ignored");
                }
            }
        }
        catch (TigaseStringprepException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessage() + " when processing " + packet.toString());
            }
            this.sendException(packet, new ComponentException(Authorization.JID_MALFORMED));
        }
        catch (ComponentException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessageWithPosition() + " when processing " + packet.toString(), e);
            }
            this.sendException(packet, e);
        }
        catch (Exception e) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, e.getMessage() + " when processing " + packet.toString(), e);
            }
            this.sendException(packet, new ComponentException(Authorization.INTERNAL_SERVER_ERROR));
        }
    }

    public void sendException(Packet packet, ComponentException e) {
        block5: {
            try {
                String t = packet.getElement().getAttributeStaticStr("type");
                if (t != null && t == "error") {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer(packet.getElemName() + " stanza already with type='error' ignored");
                    }
                    return;
                }
                Packet result = e.makeElement(packet, true);
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Sending back: " + result.toString());
                }
                this.writer.write(result);
            }
            catch (Exception e1) {
                if (!this.log.isLoggable(Level.WARNING)) break block5;
                this.log.log(Level.WARNING, "Problem during generate error response", e1);
            }
        }
    }

    private boolean process(Packet packet) throws ComponentException, TigaseStringprepException {
        boolean handled = false;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finest("Processing packet: " + packet.toString());
        }
        for (Module module : this.modules) {
            if (!module.canHandle(packet)) continue;
            handled = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Handled by module " + module.getClass());
            }
            module.process(packet);
            if (!this.log.isLoggable(Level.FINEST)) continue;
            this.log.finest("Finished " + module.getClass());
        }
        return handled;
    }
}

