/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import tigase.http.AbstractHttpServer;
import tigase.http.DeploymentInfo;
import tigase.http.jetty.JettyHttpServerHelper;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.net.SocketType;

@Bean(name="httpServer", exportable=true, active=true)
public class JettyStandaloneHttpServer
extends AbstractHttpServer
implements Initializable,
UnregisterAware {
    private static final Logger log = Logger.getLogger(JettyStandaloneHttpServer.class.getCanonicalName());
    private final ContextHandlerCollection contexts = new ContextHandlerCollection();
    private List<DeploymentInfo> deploymentInfos = new CopyOnWriteArrayList<DeploymentInfo>();
    private Server server = new Server();

    public List<DeploymentInfo> listDeployed() {
        return Collections.unmodifiableList(this.deploymentInfos);
    }

    public void deploy(DeploymentInfo deployment) {
        ServletContextHandler context = JettyHttpServerHelper.createServletContextHandler(deployment);
        this.deploy(context);
        deployment.put("context-key", (Object)context);
        this.deploymentInfos.add(deployment);
    }

    public void undeploy(DeploymentInfo deployment) {
        ServletContextHandler context = (ServletContextHandler)deployment.get("context-key");
        if (context != null) {
            this.undeploy(context);
        }
        this.deploymentInfos.remove(deployment);
    }

    public void beforeUnregister() {
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception stopping internal HTTP server", ex);
        }
    }

    public void initialize() {
        this.server.setHandler((Handler)this.contexts);
        try {
            this.server.start();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception starting internal HTTP server", ex);
        }
    }

    protected void deploy(ServletContextHandler ctx) {
        this.contexts.addHandler((Handler)ctx);
        try {
            ctx.start();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception deploying http context " + ctx.getContextPath(), ex);
        }
    }

    protected void undeploy(ServletContextHandler ctx) {
        this.contexts.removeHandler((Handler)ctx);
        try {
            ctx.stop();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception undeploying http context " + ctx.getContextPath(), ex);
        }
    }

    protected void registerConnector(ServerConnector connector, boolean secure) {
        this.server.addConnector((Connector)connector);
        if (secure) {
            this.httpsPorts.add(connector.getPort());
        } else {
            this.httpPorts.add(connector.getPort());
        }
    }

    protected void unregisterConnector(ServerConnector connector, boolean secure) {
        this.server.removeConnector((Connector)connector);
        if (secure) {
            this.httpsPorts.remove(connector.getPort());
        } else {
            this.httpPorts.remove(connector.getPort());
        }
    }

    protected ServerConnector createConnector(PortConfigBean config) {
        ServerConnector connector;
        if (config.getSocket() == SocketType.plain) {
            connector = new ServerConnector(this.server);
        } else {
            String domain = config.getDomain();
            SSLContext context = this.sslContextContainer.getSSLContext("TLS", domain, false);
            SslContextFactory contextFactory = new SslContextFactory(){

                public void customize(SSLEngine sslEngine) {
                    super.customize(sslEngine);
                    SSLParameters sslParameters = sslEngine.getSSLParameters();
                    sslParameters.setSNIMatchers(Collections.singleton(new SNIMatcher(0){

                        @Override
                        public boolean matches(SNIServerName sniServerName) {
                            return true;
                        }
                    }));
                    sslEngine.setSSLParameters(sslParameters);
                }
            };
            contextFactory.setSslContext(context);
            connector = new ServerConnector(this.server, contextFactory);
        }
        connector.setPort(config.getPort());
        return connector;
    }

    public static class PortConfigBean
    extends AbstractHttpServer.PortConfigBean {
        private ServerConnector connector = null;
        @Inject
        private JettyStandaloneHttpServer serverManager;

        public void beforeUnregister() {
            if (this.connector == null) {
                return;
            }
            this.serverManager.unregisterConnector(this.connector, this.getSocket() != SocketType.plain);
            this.connector = null;
        }

        public void initialize() {
            if (this.serverManager != null) {
                this.connector = this.serverManager.createConnector(this);
                this.serverManager.registerConnector(this.connector, this.getSocket() != SocketType.plain);
            }
        }

        public void beanConfigurationChanged(Collection<String> changedFields) {
            this.beforeUnregister();
            this.initialize();
        }
    }

    @Bean(name="connections", parent=JettyStandaloneHttpServer.class, active=true, exportable=true)
    public static class PortsConfigBean
    extends AbstractHttpServer.PortsConfigBean {
        public Class<?> getDefaultBeanClass() {
            return PortConfigBean.class;
        }
    }
}

