/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.datetime;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tigase.annotations.TigaseDeprecated;

@Deprecated
@TigaseDeprecated(since="4.0.0", removeIn="4.1.0")
public class DateTimeFormatter {
    private static final String DATE = "(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)";
    private static final String TIME = "(\\d\\d):(\\d\\d):(\\d\\d)(.\\d+)?";
    private static final String TIME_ZONE = "(([+-]\\d\\d:\\d\\d)|Z)";
    private final SimpleDateFormat TIMESTAMP_FORMATTER_WITH_MS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
    private final DateFormat dateFormat;
    private final Pattern datePattern;
    private final DateFormat dateTimeFormatUTC;
    private final Pattern dateTimePattern;
    private final DateFormat timeFormatUTC;
    private final Pattern timePattern;
    private final TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");

    public DateTimeFormatter() {
        this.dateTimePattern = Pattern.compile("^(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(.\\d+)?(([+-]\\d\\d:\\d\\d)|Z)$");
        this.datePattern = Pattern.compile("^(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)$");
        this.timePattern = Pattern.compile("^(\\d\\d):(\\d\\d):(\\d\\d)(.\\d+)?(([+-]\\d\\d:\\d\\d)|Z)?$");
        this.dateTimeFormatUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.dateTimeFormatUTC.setTimeZone(this.timeZoneUTC);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormat.setTimeZone(this.timeZoneUTC);
        this.timeFormatUTC = new SimpleDateFormat("HH:mm:ss'Z'");
        this.timeFormatUTC.setTimeZone(this.timeZoneUTC);
        this.TIMESTAMP_FORMATTER_WITH_MS.setTimeZone(this.timeZoneUTC);
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String formatDateTime(Date date) {
        return this.dateTimeFormatUTC.format(date);
    }

    public String formatInLegacyDelayedDelivery(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTimeZone(TimeZone.getTimeZone("GMT"));
        now.setTime(date);
        return String.format("%1$tY%1$tm%1$tdT%1$tH:%1$tM:%1$tS", now);
    }

    public String formatTime(Date date) {
        return this.timeFormatUTC.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatWithMs(Date date) {
        SimpleDateFormat simpleDateFormat = this.TIMESTAMP_FORMATTER_WITH_MS;
        synchronized (simpleDateFormat) {
            return this.TIMESTAMP_FORMATTER_WITH_MS.format(date);
        }
    }

    public Calendar parseDateTime(String value) throws ParseException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        Matcher m = this.dateTimePattern.matcher(value);
        if (m.find()) {
            int yyyy = Integer.valueOf(m.group(1));
            int MM = Integer.valueOf(m.group(2));
            int dd = Integer.valueOf(m.group(3));
            int hh = Integer.valueOf(m.group(4));
            int mm = Integer.valueOf(m.group(5));
            int ss = Integer.valueOf(m.group(6));
            String ms = m.group(7);
            String tzValue = m.group(8);
            TimeZone tz = tzValue.equals("Z") ? this.timeZoneUTC : TimeZone.getTimeZone("GMT" + tzValue);
            Calendar calendar = Calendar.getInstance(tz);
            calendar.clear();
            calendar.set(yyyy, MM - 1, dd, hh, mm, ss);
            if (ms != null) {
                calendar.set(14, Integer.valueOf(ms.substring(1)));
            }
            return calendar;
        }
        m = this.datePattern.matcher(value);
        if (m.find()) {
            int yyyy = Integer.valueOf(m.group(1));
            int MM = Integer.valueOf(m.group(2));
            int dd = Integer.valueOf(m.group(3));
            Calendar calendar = Calendar.getInstance(this.timeZoneUTC);
            calendar.clear();
            calendar.set(yyyy, MM - 1, dd);
            return calendar;
        }
        m = this.timePattern.matcher(value);
        if (m.find()) {
            int hh = Integer.valueOf(m.group(1));
            int mm = Integer.valueOf(m.group(2));
            int ss = Integer.valueOf(m.group(3));
            String ms = m.group(4);
            String tzValue = m.group(5);
            TimeZone tz = tzValue == null || tzValue.equals("Z") ? this.timeZoneUTC : TimeZone.getTimeZone("GMT" + tzValue);
            Calendar calendar = Calendar.getInstance(tz);
            calendar.clear();
            calendar.set(13, ss);
            calendar.set(12, mm);
            calendar.set(11, hh);
            if (ms != null) {
                calendar.set(14, Integer.valueOf(ms.substring(1)));
            }
            return calendar;
        }
        throw new ParseException("Can't parse datetime, date or time: " + value, -1);
    }
}

