/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.mam;

import java.text.ParseException;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.QueryParser;

@Bean(name="mamQueryParser", active=true)
public class MAMQueryParser<Query extends Query>
implements QueryParser<Query> {
    protected static final String MAM_XMLNS = "urn:xmpp:mam:1";
    private final TimestampHelper timestampHelper = new TimestampHelper();

    @Override
    public Query parseQuery(Query query, Packet packet) throws ComponentException {
        Element queryEl = packet.getElement().getChildStaticStr("query", MAM_XMLNS);
        query.setQuestionerJID(packet.getStanzaFrom());
        query.setComponentJID(packet.getStanzaTo());
        query.setId(queryEl.getAttributeStaticStr("queryid"));
        if (queryEl.getChild("x", "jabber:x:data") == null) {
            return query;
        }
        if (!MAM_XMLNS.equals(DataForm.getFieldValue(queryEl, "FORM_TYPE"))) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid form type");
        }
        String start = DataForm.getFieldValue(queryEl, "start");
        try {
            query.setStart(this.timestampHelper.parseTimestamp(start));
        }
        catch (ParseException ex) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value in 'start' field", ex);
        }
        String end = DataForm.getFieldValue(queryEl, "end");
        try {
            query.setEnd(this.timestampHelper.parseTimestamp(end));
        }
        catch (ParseException ex) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value in 'end' field", ex);
        }
        String with = DataForm.getFieldValue(queryEl, "with");
        if (with != null && !with.isEmpty()) {
            try {
                query.setWith(JID.jidInstance((String)with));
            }
            catch (TigaseStringprepException ex) {
                throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value in 'with' field", ex);
            }
        }
        query.getRsm().fromElement(queryEl);
        return query;
    }

    @Override
    public Element prepareForm(Element elem) {
        Element x = DataForm.addDataForm(elem, Command.DataType.form);
        DataForm.addHiddenField(elem, "FORM_TYPE", MAM_XMLNS);
        this.addField(x, "with", "jid-single", "With");
        this.addField(x, "start", "jid-single", "Start");
        this.addField(x, "end", "jid-single", "End");
        return elem;
    }

    protected void addField(Element x, String var, String type, String label) {
        Element field = new Element("field", new String[]{"type", "var"}, new String[]{type, var});
        if (label != null) {
            field.setAttribute("label", label);
        }
        x.addChild((XMLNodeIfc)field);
    }
}

