/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.sys.TigaseRuntime;
import tigase.util.cache.LRUConcurrentCache;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.PresenceAbstract;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFlat;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Id(value="presence-offline")
@Handles(value={@Handle(path={"presence"}, xmlns="jabber:client"), @Handle(path={"iq", "query"}, xmlns="jabber:iq:roster")})
@Bean(name="presence-offline", parent=SessionManager.class, active=false)
public class PresenceOffline
extends PresenceAbstract
implements XMPPStopListenerIfc,
Initializable,
UnregisterAware {
    public static final String CACHE_SIZE_PROP_KEY = "cache-size";
    protected static final String ID = "presence-offline";
    private static final Logger log = Logger.getLogger(PresenceOffline.class.getCanonicalName());
    private static final EnumSet<StanzaType> PRESENCE_SUB_CHANGE_TYPES = EnumSet.of(StanzaType.subscribed, StanzaType.unsubscribe, StanzaType.unsubscribed);
    private static final String LAST_OFFLINE_PRESENCE_KEY = "last-offline-presence";
    private static final String DELAY_STAMP_KEY = "delay-stamp";
    private final EventBus eventBus = EventBusFactory.getInstance();
    private final SimpleDateFormat formatter;
    private final SimpleParser parser = SingletonFactory.getParserInstance();
    private final String presenceSessionEventName = "start-stop";
    @ConfigField(desc="Add delay stamp to offline presences", alias="delay-stamp")
    boolean delayStamp = true;
    @ConfigField(desc="Default cache size", alias="cache-size")
    private int cacheSize = 1000;
    private LRUConcurrentCache<BareJID, Element> presenceCache = new LRUConcurrentCache(10000);
    private LRUConcurrentCache<BareJID, Map<BareJID, RosterElement>> rosterCache = new LRUConcurrentCache(10000);
    @Inject
    private UserRepository userRepository = null;

    public PresenceOffline() {
        this.formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public void initialize() {
        this.eventBus.registerAll(this);
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    public void setCacheSize(int size) {
        this.cacheSize = size;
        this.presenceCache = new LRUConcurrentCache(this.cacheSize);
        this.rosterCache = new LRUConcurrentCache(this.cacheSize);
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    public void onEvent(StartStopEvent event) {
        BareJID[] jidElements = event.getJids();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Procesing userPresence event: {0} with following jids: {1}", new Object[]{event, jidElements});
        }
        if (jidElements != null) {
            block8: for (BareJID jid : jidElements) {
                String actionStr = event.getAction();
                if (actionStr == null) continue;
                switch (actionStr) {
                    case "presence": {
                        this.presenceCache.remove((Object)jid);
                        if (!log.isLoggable(Level.FINEST)) continue block8;
                        log.log(Level.FINEST, "Clearing presence cache: {0}, remaining items: {1}", new Object[]{jid, this.presenceCache.size()});
                        continue block8;
                    }
                    case "roster": {
                        this.rosterCache.remove((Object)jid);
                        if (!log.isLoggable(Level.FINEST)) continue block8;
                        log.log(Level.FINEST, "Clearing roster cache: {0}, remaining items: {1}", new Object[]{jid, this.rosterCache.size()});
                    }
                }
            }
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if ("presence".equals(packet.getElemName())) {
            if (session == null && packet.getType() == StanzaType.probe && packet.getStanzaFrom() != null && packet.getStanzaTo() != null && !packet.getStanzaFrom().equals((Object)packet.getStanzaTo())) {
                BareJID stanzaFrom;
                BareJID stanzaTo = packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null;
                BareJID bareJID = stanzaFrom = packet.getStanzaFrom() != null ? packet.getStanzaFrom().getBareJID() : null;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Processing presence probe {0} to offline user: {1}", new Object[]{packet, packet.getStanzaTo()});
                }
                if (stanzaTo != null && stanzaFrom != null && this.isSubscriptionValid(stanzaTo, stanzaFrom)) {
                    Element presence = (Element)this.presenceCache.get((Object)stanzaTo);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Retrieved presence from cache: {0}", presence);
                    }
                    if (presence == null) {
                        presence = this.loadPresenceFromRepo(stanzaTo);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Retrieved presence from respository: {0}", presence);
                        }
                    }
                    if (presence != null) {
                        try {
                            Packet p = Packet.packetInstance(presence.clone());
                            p.initVars(p.getStanzaFrom(), packet.getStanzaFrom());
                            results.offer(p);
                        }
                        catch (TigaseStringprepException ex) {
                            log.log(Level.WARNING, "Error creating packet instance from presence: " + presence, ex);
                        }
                    }
                }
            } else if (session != null && packet.getStanzaFrom() != null) {
                if (PRESENCE_SUB_CHANGE_TYPES.contains((Object)packet.getType())) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Presence sub change - sending event to cleare cache {0}", packet.getElement());
                    }
                    this.sendEvent("roster", packet.getStanzaFrom() != null ? packet.getStanzaFrom().getBareJID() : null, packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null);
                } else if (session.isUserId(packet.getStanzaFrom().getBareJID()) && (packet.getType() == null || packet.getType() == StanzaType.available)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Presence session: {0} started - sending event and removing data from repository, packet: ", new Object[]{session, packet});
                    }
                    this.sendEvent("presence", session.getJID().getBareJID());
                    try {
                        this.userRepository.removeData(packet.getStanzaFrom().getBareJID(), LAST_OFFLINE_PRESENCE_KEY);
                    }
                    catch (TigaseDBException ex) {
                        log.log(Level.WARNING, "Error removing data from repository while starting new presence session", ex);
                    }
                }
            }
        } else if (packet.getType() == StanzaType.set && packet.getElement().getXMLNSStaticStr(Iq.IQ_QUERY_PATH) == "jabber:iq:roster") {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Roster change - updated roster cache, packet: {0}", packet);
            }
            if (packet.getStanzaFrom() != null) {
                BareJID user = packet.getStanzaFrom().getBareJID();
                this.sendEvent("roster", user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null || !session.isAuthorized()) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            Element lastPresence;
            this.sendEvent("presence", session.getjid().getBareJID());
            Element element = lastPresence = session.getPresence() != null ? session.getPresence().clone() : null;
            if (lastPresence != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Session: {0} stopped, storing to repository last presence: {1}", new Object[]{session, lastPresence});
                }
                if (this.delayStamp) {
                    String stamp = null;
                    SimpleDateFormat simpleDateFormat = this.formatter;
                    synchronized (simpleDateFormat) {
                        stamp = this.formatter.format(new Date());
                    }
                    if (stamp != null) {
                        Element x = new Element("delay", new String[]{"stamp", "xmlns"}, new String[]{stamp, "urn:xmpp:delay"});
                        lastPresence.addChild((XMLNodeIfc)x);
                    }
                }
                if (!StanzaType.unavailable.toString().equals(lastPresence.getAttributeStaticStr("type"))) {
                    lastPresence.setAttribute("type", StanzaType.unavailable.toString());
                }
                try {
                    this.userRepository.setData(session.getjid().getBareJID(), LAST_OFFLINE_PRESENCE_KEY, lastPresence.toString());
                }
                catch (TigaseDBException ex) {
                    log.log(Level.WARNING, "Error storing last offline presence to repository: " + lastPresence, ex);
                }
            }
        }
    }

    protected boolean isNotOnlySession(XMPPResourceConnection session) {
        if (TigaseRuntime.getTigaseRuntime().hasCompleteJidsInfo() && session != null) {
            JID[] connectionIdsForJid;
            JID userJID = session.getjid();
            if (TigaseRuntime.getTigaseRuntime().isJidOnline(userJID) && (connectionIdsForJid = TigaseRuntime.getTigaseRuntime().getConnectionIdsForJid(userJID)) != null && connectionIdsForJid.length > 0 && (connectionIdsForJid.length != 1 || !connectionIdsForJid[0].equals((Object)userJID))) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "There are other user {0} sessions still active: {1}", new Object[]{session.getjid(), Arrays.asList(connectionIdsForJid)});
                }
                return true;
            }
        }
        return false;
    }

    protected boolean isSubscriptionValid(BareJID owner, BareJID contact) {
        RosterAbstract.SubscriptionType buddy_subscr = null;
        ConcurrentHashMap<BareJID, RosterElement> roster = null;
        boolean result = false;
        roster = (ConcurrentHashMap<BareJID, RosterElement>)this.rosterCache.get((Object)owner);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Checking user {0} subscription of {1}, present in cache: {2}", new Object[]{owner, contact, roster != null});
        }
        if (roster == null) {
            String rosterString = null;
            try {
                rosterString = this.userRepository.getData(owner, "roster");
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Problem reading roster from DB: ", ex);
            }
            if (rosterString != null) {
                roster = new ConcurrentHashMap<BareJID, RosterElement>(100, 0.25f, 1);
                RosterFlat.parseRosterUtil(rosterString, roster, null);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Loaded roster from DB: {0}", roster);
                }
            }
        }
        if (roster != null) {
            RosterElement rosterElement = (RosterElement)roster.get(contact);
            buddy_subscr = rosterElement.getSubscription();
            if (buddy_subscr == null) {
                buddy_subscr = RosterAbstract.SubscriptionType.none;
            }
            result = this.roster_util.isSubscribedFrom(buddy_subscr);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "isSubscriptionValid, owner: {0}, contact: {1}, result: {2}", new Object[]{owner, contact, result});
        }
        return result;
    }

    protected Element loadPresenceFromRepo(BareJID stanzaTo) {
        Element presence = null;
        try {
            String presString = this.userRepository.getData(stanzaTo, LAST_OFFLINE_PRESENCE_KEY);
            DomBuilderHandler domHandler = new DomBuilderHandler();
            Collection parsedElements = null;
            if (presString != null) {
                char[] data = presString.toCharArray();
                this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
                parsedElements = domHandler.getParsedElements();
            }
            if (parsedElements != null && parsedElements.size() > 0) {
                presence = (Element)parsedElements.poll();
                this.presenceCache.put((Object)stanzaTo, (Object)presence);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Loaded presence: {0} and stored it in cache", presence);
                }
            }
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Loading presence from repository failed!", ex);
        }
        return presence;
    }

    private void sendEvent(String action, BareJID ... user) {
        if (user != null && user.length > 0) {
            StartStopEvent event = new StartStopEvent();
            event.setAction(action);
            event.setJids(user);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending event: " + event);
            }
            this.eventBus.fire(event);
        }
    }

    public class StartStopEvent
    implements Serializable {
        private String action;
        private BareJID[] jids;

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public BareJID[] getJids() {
            return this.jids;
        }

        public void setJids(BareJID[] jids) {
            this.jids = jids;
        }
    }
}

