/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import tigase.db.AuthRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.form.Field;
import tigase.form.Form;
import tigase.form.FormSignatureVerifier;
import tigase.form.FormSignerException;
import tigase.form.SignatureCalculator;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.StatisticsList;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.CaptchaProvider;
import tigase.xmpp.impl.TokenBucketPool;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="jabber:iq:register", parent=SessionManager.class, active=true)
public class JabberIqRegister
extends XMPPProcessor
implements XMPPProcessorIfc,
Initializable,
UnregisterAware,
RegistrarBean {
    public static final String ID = "jabber:iq:register";
    public static final String REGISTRATION_PER_SECOND_PROP_KEY = "registrations-per-second";
    public static final String REGISTRATION_BLACKLIST_PROP_KEY = "registration-blacklist";
    public static final String REGISTRATION_WHITELIST_PROP_KEY = "registration-whitelist";
    public static final String WHITELIST_REGISTRATION_ONLY_PROP_KEY = "whitelist-registration-only";
    public static final String OAUTH_CONSUMERKEY_PROP_KEY = "oauth-consumer-key";
    public static final String OAUTH_CONSUMERSECRET_PROP_KEY = "oauth-consumer-secret";
    public static final String SIGNED_FORM_REQUIRED_PROP_KEY = "signed-form-required";
    private static final int REMOTE_ADDRESS_IDX = 2;
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH};
    private static final String[] XMLNSS = new String[]{"jabber:iq:register"};
    private static final String[] IQ_QUERY_USERNAME_PATH = new String[]{"iq", "query", "username"};
    private static final String[] IQ_QUERY_REMOVE_PATH = new String[]{"iq", "query", "remove"};
    private static final String[] IQ_QUERY_PASSWORD_PATH = new String[]{"iq", "query", "password"};
    private static final String[] IQ_QUERY_EMAIL_PATH = new String[]{"iq", "query", "email"};
    private static final Element[] FEATURES = new Element[]{new Element("register", new String[]{"xmlns"}, new String[]{"http://jabber.org/features/iq-register"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:register"})};
    private static final BareJID smJid = BareJID.bareJIDInstanceNS((String)"sess-man");
    private static Logger log = Logger.getLogger(JabberIqRegister.class.getName());
    @Inject
    private CaptchaProvider captchaProvider;
    @ConfigField(desc="CAPTCHA Required")
    private boolean captchaRequired = false;
    @ConfigField(desc="Email Required")
    private boolean emailRequired = true;
    @Inject
    private EventBus eventBus;
    @ConfigField(desc="Maximum CAPTCHA repetition in session")
    private int maxCaptchaRepetition = 3;
    @ConfigField(desc="OAuth consumer key", alias="oauth-consumer-key")
    private String oauthConsumerKey;
    @ConfigField(desc="OAuth consumer secret", alias="oauth-consumer-secret")
    private String oauthConsumerSecret;
    @ConfigField(desc="Registration blacklist", alias="registration-blacklist")
    private LinkedList<CIDRAddress> registrationBlacklist = new LinkedList();
    @ConfigField(desc="Registration whitelist", alias="registration-whitelist")
    private LinkedList<CIDRAddress> registrationWhitelist = new LinkedList();
    @ConfigField(desc="Registrations per second", alias="registrations-per-second")
    private long registrationsPerSecond = 0L;
    @ConfigField(desc="Require form signed with OAuth", alias="signed-form-required")
    private boolean signedFormRequired = false;
    private long statsInvalidRegistrations;
    private long statsRegisteredUsers;
    private TokenBucketPool tokenBucket = new TokenBucketPool();
    @Inject
    private UserRepository userRepository;
    @Inject(nullAllowed=true)
    private AccountValidator[] validators = null;
    private String welcomeMessage = null;
    @ConfigField(desc="Allow registration only for whitelisted addresses", alias="whitelist-registration-only")
    private boolean whitelistRegistrationOnly = false;

    private static boolean contains(List<CIDRAddress> addresses, String address) {
        if (address == null) {
            return false;
        }
        for (CIDRAddress cidrAddress : addresses) {
            if (!cidrAddress.inRange(address)) continue;
            return true;
        }
        return false;
    }

    private static LinkedList<CIDRAddress> parseList(String listStr) {
        String[] splitArray = listStr.split(",");
        LinkedList<CIDRAddress> splitList = new LinkedList<CIDRAddress>();
        for (String listEl : splitArray) {
            splitList.add(CIDRAddress.parse(listEl.trim()));
        }
        return splitList;
    }

    private static String parseRemoteAddressFromJid(JID from) {
        try {
            String connectionId = from.getResource();
            return connectionId.split("_")[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public long getRegistrationsPerSecond() {
        return this.tokenBucket.getDefaultRate();
    }

    public void setRegistrationsPerSecond(long registrationsPerSecond) {
        this.tokenBucket.setDefaultRate(registrationsPerSecond);
    }

    public LinkedList<String> getRegistrationBlacklist() {
        return this.registrationBlacklist.stream().map(cidr -> cidr.toString()).collect(Collectors.toCollection(LinkedList::new));
    }

    public void setRegistrationBlacklist(LinkedList<String> vals) {
        this.registrationBlacklist = vals == null ? new LinkedList() : vals.stream().map(val -> CIDRAddress.parse(val)).collect(Collectors.toCollection(LinkedList::new));
    }

    public LinkedList<String> getRegistrationWhitelist() {
        return this.registrationWhitelist.stream().map(cidr -> cidr.toString()).collect(Collectors.toCollection(LinkedList::new));
    }

    public void setRegistrationWhitelist(LinkedList<String> vals) {
        this.registrationWhitelist = vals == null ? new LinkedList() : vals.stream().map(val -> CIDRAddress.parse(val)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
        this.tokenBucket.beforeUnregister();
    }

    @Override
    public void register(Kernel kernel) {
        kernel.registerBean("tokenBucketPool").asClass(TokenBucketPool.class).exec();
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getComponentInfo().getName(), "Registered users", this.statsRegisteredUsers, Level.INFO);
        list.add(this.getComponentInfo().getName(), "Invalid registrations", this.statsInvalidRegistrations, Level.INFO);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void initialize() {
        this.tokenBucket.initialize();
        this.eventBus.registerAll(this);
        try {
            if (this.userRepository.userExists(smJid)) {
                this.welcomeMessage = this.userRepository.getData(smJid, ID, "welcome-message");
            } else {
                this.userRepository.addUser(smJid);
            }
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "failed to read current welcome message from user repository", ex);
        }
    }

    public boolean isSignedFormRequired() {
        return this.signedFormRequired;
    }

    public void setSignedFormRequired(boolean required) {
        this.signedFormRequired = required;
    }

    @HandleEvent
    public void onWelcomeMessageChange(WelcomeMessageChangedEvent event) {
        this.welcomeMessage = event.getMessage();
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toString());
        }
        if (session == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Session is null, ignoring");
            }
            return;
        }
        BareJID id = session.getDomainAsJID().getBareJID();
        if (packet.getStanzaTo() != null) {
            id = packet.getStanzaTo().getBareJID();
        }
        try {
            if (packet.getPacketFrom() != null && packet.getPacketFrom().equals((Object)session.getConnectionId()) && (!session.isAuthorized() || session.isUserId(id) || session.isLocalDomain(id.toString(), false))) {
                boolean remove;
                Element request = packet.getElement();
                boolean bl = remove = request.findChildStaticStr(IQ_QUERY_REMOVE_PATH) != null;
                if (!session.isAuthorized() || remove) {
                    if (!this.isRegistrationAllowedForConnection(packet.getFrom())) {
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Registration is not allowed for this connection.", true));
                        ++this.statsInvalidRegistrations;
                        return;
                    }
                    if (!session.getDomain().isRegisterEnabled()) {
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Registration is not allowed for this domain.", true));
                        ++this.statsInvalidRegistrations;
                        return;
                    }
                    if (!this.isTokenInBucket(packet.getFrom())) {
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Server is busy. Too many registrations. Try later.", true));
                        ++this.statsInvalidRegistrations;
                        return;
                    }
                }
                Authorization result = Authorization.NOT_AUTHORIZED;
                StanzaType type = packet.getType();
                switch (type) {
                    case set: {
                        Element removeElem = request.findChildStaticStr(IQ_QUERY_REMOVE_PATH);
                        if (removeElem != null) {
                            this.doRemoveAccount(packet, request, session, results);
                            break;
                        }
                        this.doRegisterNewAccount(packet, request, session, results);
                        break;
                    }
                    case get: {
                        this.doGetRegistrationForm(packet, request, session, results);
                        break;
                    }
                    case result: {
                        Packet pack_res = packet.copyElementOnly();
                        pack_res.setPacketTo(session.getConnectionId());
                        results.offer(pack_res);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", true));
                        break;
                    }
                }
            } else if (session.isUserId(id)) {
                Packet pack_res = packet.copyElementOnly();
                pack_res.setPacketTo(session.getConnectionId());
                results.offer(pack_res);
            } else {
                results.offer(packet.copyElementOnly());
            }
        }
        catch (XMPPProcessorException e) {
            ++this.statsInvalidRegistrations;
            Packet result = e.makeElement(packet, true);
            results.offer(result);
        }
        catch (TigaseStringprepException ex) {
            ++this.statsInvalidRegistrations;
            results.offer(Authorization.JID_MALFORMED.getResponseMessage(packet, "Incorrect user name, stringprep processing failed.", true));
        }
        catch (NotAuthorizedException e) {
            ++this.statsInvalidRegistrations;
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to change registration settings.\n" + e.getMessage(), true));
        }
        catch (TigaseDBException e) {
            log.warning("Database problem: " + e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    public void setOAuthCredentials(String oauthConsumerKey, String oauthConsumerSecret) {
        this.oauthConsumerKey = oauthConsumerKey;
        this.oauthConsumerSecret = oauthConsumerSecret;
    }

    public void setWelcomeMessage(String message) throws TigaseDBException {
        if (message != null) {
            this.userRepository.setData(smJid, ID, "welcome-message", message);
        } else {
            this.userRepository.removeData(smJid, ID, "welcome-message");
        }
        this.eventBus.fire(new WelcomeMessageChangedEvent(message));
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        if (log.isLoggable(Level.FINEST) && session != null) {
            log.finest("VHostItem: " + session.getDomain());
        }
        if (session != null && session.getDomain().isRegisterEnabled()) {
            return DISCO_FEATURES;
        }
        return null;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (log.isLoggable(Level.FINEST) && session != null) {
            log.finest("VHostItem: " + session.getDomain());
        }
        if (session != null && session.getDomain().isRegisterEnabled()) {
            return FEATURES;
        }
        return null;
    }

    protected void createAccount(XMPPResourceConnection session, String user_name, VHostItem domain, String password, String email, Map<String, String> reg_params) throws XMPPProcessorException, TigaseStringprepException, TigaseDBException {
        BareJID jid = BareJID.bareJIDInstanceNS((String)user_name, (String)domain.getVhost().getDomain());
        if (this.validators != null) {
            for (AccountValidator validator : this.validators) {
                validator.checkRequiredParameters(jid, reg_params);
            }
        }
        try {
            session.getAuthRepository().addUser(BareJID.bareJIDInstance((String)user_name, (String)domain.getVhost().getDomain()), password);
            boolean confirmationRequired = false;
            if (this.validators != null) {
                for (AccountValidator validator : this.validators) {
                    confirmationRequired |= validator.sendAccountValidation(jid, reg_params);
                }
                if (confirmationRequired) {
                    session.getAuthRepository().setAccountStatus(jid, AuthRepository.AccountStatus.pending);
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "User added: {0}, pass: {1}", new Object[]{BareJID.toString((String)user_name, (String)domain.getVhost().getDomain()), password});
            }
            ++this.statsRegisteredUsers;
            session.setRegistration(user_name, password, reg_params);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Registration data set for: {0}, pass: {1}, reg_params: {2}", new Object[]{BareJID.toString((String)user_name, (String)domain.getVhost().getDomain()), password, reg_params});
            }
            this.eventBus.fire(new UserRegisteredEvent(jid, email, confirmationRequired, reg_params));
        }
        catch (UserExistsException e) {
            throw new XMPPProcessorException(Authorization.CONFLICT);
        }
    }

    protected void doGetRegistrationForm(Packet packet, Element request, XMPPResourceConnection session, Queue<Packet> results) throws XMPPProcessorException, NoConnectionIdException {
        if (this.captchaRequired) {
            results.offer(packet.okResult(this.prepareCaptchaRegistrationForm(session), 0));
        } else if (this.signedFormRequired) {
            results.offer(packet.okResult(this.prepareSignedRegistrationForm(session), 0));
        } else if (this.emailRequired) {
            results.offer(packet.okResult("<instructions>Choose a user name and password for use with this service.Please provide also your e-mail address.</instructions><username/><password/><email/>", 1));
        } else {
            results.offer(packet.okResult("<instructions>Choose a user name and password for use with this service.</instructions><username/><password/>", 1));
        }
    }

    protected void doRemoveAccount(Packet packet, Element request, XMPPResourceConnection session, Queue<Packet> results) throws XMPPProcessorException, NoConnectionIdException, PacketErrorTypeException, NotAuthorizedException, TigaseStringprepException, TigaseDBException {
        Element elem = request.findChildStaticStr(Iq.IQ_QUERY_PATH);
        if (elem.getChildren().size() > 1) {
            throw new XMPPProcessorException(Authorization.BAD_REQUEST);
        }
        if (!session.isAuthorized()) {
            throw new XMPPProcessorException(Authorization.FORBIDDEN);
        }
        String user_name = packet.getStanzaFrom().getLocalpart();
        if (!session.getUserName().equals(user_name)) {
            throw new XMPPProcessorException(Authorization.FORBIDDEN);
        }
        session.getAuthRepository().removeUser(BareJID.bareJIDInstance((String)user_name, (String)session.getDomain().getVhost().getDomain()));
        try {
            this.userRepository.removeUser(BareJID.bareJIDInstance((String)user_name, (String)session.getDomain().getVhost().getDomain()));
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        session.logout();
        Packet ok_result = packet.okResult((String)null, 0);
        ok_result.setPriority(Priority.SYSTEM);
        results.offer(ok_result);
        Packet close_cmd = Command.CLOSE.getPacket(session.getSMComponentId(), session.getConnectionId(), StanzaType.set, session.nextStanzaId());
        close_cmd.setPacketTo(session.getConnectionId());
        close_cmd.setPriority(Priority.LOWEST);
        results.offer(close_cmd);
    }

    protected boolean isRegistrationAllowedForConnection(JID from) {
        String remoteAdress = JabberIqRegister.parseRemoteAddressFromJid(from);
        if (this.whitelistRegistrationOnly) {
            return JabberIqRegister.contains(this.registrationWhitelist, remoteAdress);
        }
        return !JabberIqRegister.contains(this.registrationBlacklist, remoteAdress);
    }

    protected boolean isTokenInBucket(JID from) {
        String remoteAdress = JabberIqRegister.parseRemoteAddressFromJid(from);
        if (remoteAdress == null || remoteAdress.isEmpty()) {
            remoteAdress = "<default>";
        }
        return this.tokenBucket.consume(remoteAdress);
    }

    private Message createWelcomeMessage(String username, XMPPResourceConnection session) throws TigaseStringprepException {
        if (this.welcomeMessage == null) {
            return null;
        }
        JID jid = JID.jidInstance((String)username, (String)session.getDomainAsJID().getDomain());
        Element messageEl = new Element("message");
        messageEl.setXMLNS("jabber:client");
        messageEl.addChild((XMLNodeIfc)new Element("body", this.welcomeMessage));
        return new Message(messageEl, session.getDomainAsJID(), jid);
    }

    private void doRegisterNewAccount(Packet packet, Element request, XMPPResourceConnection session, Queue<Packet> results) throws XMPPProcessorException, NoConnectionIdException, TigaseStringprepException, NotAuthorizedException, TigaseDBException {
        Message msg;
        String email;
        String password;
        String user_name;
        if (this.captchaRequired) {
            CaptchaProvider.CaptchaItem captcha = (CaptchaProvider.CaptchaItem)session.getSessionData("jabber:iq:register:captcha");
            if (captcha == null) {
                log.finest("CAPTCHA is required");
                throw new XMPPProcessorException(Authorization.BAD_REQUEST, "CAPTCHA is required. Please reload your registration form.");
            }
            Element queryEl = request.getChild("query", ID);
            Element formEl = queryEl == null ? null : queryEl.getChild("x", "jabber:x:data");
            Form form = new Form(formEl);
            String capResp = form.getAsString("captcha");
            if (!captcha.isResponseValid(session, capResp)) {
                captcha.incraseErrorCounter();
                log.finest("Invalid captcha");
                if (captcha.getErrorCounter() >= this.maxCaptchaRepetition) {
                    log.finest("Blocking session with not-solved captcha");
                    session.removeSessionData("jabber:iq:register:captcha");
                }
                throw new XMPPProcessorException(Authorization.NOT_ALLOWED, "Invalid captcha");
            }
            user_name = form.getAsString("username");
            password = form.getAsString("password");
            email = form.getAsString("email");
        } else if (this.signedFormRequired) {
            Element formEl;
            String expectedToken = UUID.nameUUIDFromBytes((session.getConnectionId() + "|" + session.getSessionId()).getBytes()).toString();
            FormSignatureVerifier verifier = new FormSignatureVerifier(this.oauthConsumerKey, this.oauthConsumerSecret);
            Element queryEl = request.getChild("query", ID);
            Element element = formEl = queryEl == null ? null : queryEl.getChild("x", "jabber:x:data");
            if (formEl == null) {
                throw new XMPPProcessorException(Authorization.BAD_REQUEST, "Use Signed Registration Form");
            }
            Form form = new Form(formEl);
            if (!expectedToken.equals(form.getAsString("oauth_token"))) {
                log.finest("Received oauth_token is different that sent one.");
                throw new XMPPProcessorException(Authorization.BAD_REQUEST, "Unknown oauth_token");
            }
            if (!this.oauthConsumerKey.equals(form.getAsString("oauth_consumer_key"))) {
                log.finest("Unknown oauth_consumer_key");
                throw new XMPPProcessorException(Authorization.BAD_REQUEST, "Unknown oauth_consumer_key");
            }
            try {
                long timestamp = verifier.verify(packet.getStanzaTo(), form);
                user_name = form.getAsString("username");
                password = form.getAsString("password");
                email = form.getAsString("email");
            }
            catch (FormSignerException e) {
                log.fine("Form Signature Validation Problem: " + e.getMessage());
                throw new XMPPProcessorException(Authorization.BAD_REQUEST, "Invalid form signature");
            }
        } else {
            user_name = request.getChildCDataStaticStr(IQ_QUERY_USERNAME_PATH);
            password = request.getChildCDataStaticStr(IQ_QUERY_PASSWORD_PATH);
            email = request.getChildCDataStaticStr(IQ_QUERY_EMAIL_PATH);
        }
        if (null != password) {
            password = XMLUtils.unescape((String)password);
        }
        LinkedHashMap<String, String> reg_params = null;
        if (email != null && !email.trim().isEmpty()) {
            reg_params = new LinkedHashMap<String, String>();
            reg_params.put("email", email);
        }
        if (user_name == null || user_name.equals("") || password == null || password.equals("")) {
            throw new XMPPProcessorException(Authorization.NOT_ACCEPTABLE);
        }
        if (session.isAuthorized()) {
            session.setRegistration(user_name, password, reg_params);
            results.offer(packet.okResult((String)null, 0));
            return;
        }
        VHostItem domain = session.getDomain();
        if (!domain.isRegisterEnabled()) {
            throw new NotAuthorizedException("Registration is now allowed for this domain");
        }
        if (domain.getMaxUsersNumber() > 0L) {
            long domainUsers = session.getAuthRepository().getUsersCount(domain.getVhost().getDomain());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Current number of users for domain: " + domain.getVhost().getDomain() + " is: " + domainUsers);
            }
            if (domainUsers >= domain.getMaxUsersNumber()) {
                throw new NotAuthorizedException("Maximum users number for the domain exceeded.");
            }
        }
        this.createAccount(session, user_name, domain, password, email, reg_params);
        session.removeSessionData("jabber:iq:register:captcha");
        String localPart = BareJID.parseJID((String)user_name)[0];
        if (localPart == null || localPart.isEmpty()) {
            localPart = user_name;
        }
        if ((msg = this.createWelcomeMessage(localPart, session)) != null) {
            results.offer(msg);
        }
        results.offer(packet.okResult((String)null, 0));
    }

    private Element prepareCaptchaRegistrationForm(XMPPResourceConnection session) throws NoConnectionIdException {
        Element query = new Element("query", new String[]{"xmlns"}, XMLNSS);
        query.addChild((XMLNodeIfc)new Element("instructions", "Use the enclosed form to register."));
        Form form = new Form("form", "Contest Registration", "Please provide the following information to sign up for our special contests!");
        form.addField(Field.fieldHidden((String)"FORM_TYPE", (String)ID));
        Field field = Field.fieldTextSingle((String)"username", (String)"", (String)"Username");
        field.setRequired(true);
        form.addField(field);
        field = Field.fieldTextPrivate((String)"password", (String)"", (String)"Password");
        field.setRequired(true);
        form.addField(field);
        field = Field.fieldTextSingle((String)"email", (String)"", (String)"Email");
        field.setRequired(true);
        form.addField(field);
        CaptchaProvider.CaptchaItem captcha = this.captchaProvider.generateCaptcha();
        session.putSessionData("jabber:iq:register:captcha", captcha);
        field = Field.fieldTextSingle((String)"captcha", (String)"", (String)captcha.getCaptchaRequest(session));
        field.setRequired(true);
        form.addField(field);
        query.addChild((XMLNodeIfc)form.getElement());
        return query;
    }

    private Element prepareSignedRegistrationForm(XMPPResourceConnection session) throws NoConnectionIdException {
        Element query = new Element("query", new String[]{"xmlns"}, XMLNSS);
        query.addChild((XMLNodeIfc)new Element("instructions", "Use the enclosed form to register."));
        Form form = new Form("urn:xmpp:xdata:signature:oauth1", "Contest Registration", "Please provide the following information to sign up for our special contests!");
        form.addField(Field.fieldTextSingle((String)"username", (String)"", (String)"Username"));
        form.addField(Field.fieldTextPrivate((String)"password", (String)"", (String)"Password"));
        form.addField(Field.fieldTextSingle((String)"email", (String)"", (String)"Email"));
        SignatureCalculator sc = new SignatureCalculator(this.oauthConsumerKey, this.oauthConsumerSecret);
        sc.setOauthToken(UUID.nameUUIDFromBytes((session.getConnectionId() + "|" + session.getSessionId()).getBytes()).toString());
        sc.addEmptyFields(form);
        query.addChild((XMLNodeIfc)form.getElement());
        return query;
    }

    public static class WelcomeMessageChangedEvent
    implements Serializable {
        private String message;

        public WelcomeMessageChangedEvent() {
        }

        public WelcomeMessageChangedEvent(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class UserRegisteredEvent {
        private boolean confirmationRequired;
        private String email;
        private Map<String, String> params;
        private BareJID user;

        public UserRegisteredEvent(BareJID user, String email, boolean confirmationRequired, Map<String, String> params) {
            this.user = user;
            this.email = email;
            this.params = params;
            this.confirmationRequired = confirmationRequired;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }

        public BareJID getUser() {
            return this.user;
        }

        public void setUser(BareJID user) {
            this.user = user;
        }

        public boolean isConfirmationRequired() {
            return this.confirmationRequired;
        }

        public void setConfirmationRequired(boolean confirmationRequired) {
            this.confirmationRequired = confirmationRequired;
        }
    }

    public static class CIDRAddress {
        static final int NBITS = 32;
        static final String IP_ADDRESS_MASK = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
        static final String CIDR_ADDRESS_MASK = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
        static final Pattern IP_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
        static final Pattern CIDR_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
        final int high;
        final int low;

        static int matchAddress(Matcher matcher) {
            int addr = 0;
            for (int i = 1; i <= 4; ++i) {
                int n = Integer.parseInt(matcher.group(i));
                addr |= (n & 0xFF) << 8 * (4 - i);
            }
            return addr;
        }

        static CIDRAddress parse(String mask) {
            if (!mask.contains("/")) {
                mask = mask + "/" + 32;
            }
            Matcher matcher = CIDR_PATTERN.matcher(mask);
            matcher.matches();
            int address = CIDRAddress.matchAddress(matcher);
            int cidrPart = Integer.parseInt(matcher.group(5));
            int netmask = 0;
            int broadcast = 0;
            int network = 0;
            for (int j = 0; j < cidrPart; ++j) {
                netmask |= 1 << 31 - j;
            }
            network = address & netmask;
            broadcast = network | ~netmask;
            return new CIDRAddress(broadcast, network);
        }

        static int toInteger(String address) {
            Matcher matcher = IP_PATTERN.matcher(address);
            matcher.matches();
            return CIDRAddress.matchAddress(matcher);
        }

        private CIDRAddress(int high, int low) {
            this.high = high;
            this.low = low;
        }

        public String toString() {
            int mask = 0;
            boolean z = false;
            for (int j = 3; j >= 0; --j) {
                int shift = j * 8;
                byte b = (byte)((~(this.low >> shift & 0xFF) ^ this.high >> shift & 0xFF) & 0xFF);
                int m = 128;
                for (int i = 0; i < 8; ++i) {
                    if ((b & m) == 0) {
                        z = true;
                    } else {
                        ++mask;
                    }
                    m >>>= 1;
                }
            }
            return String.format("%d.%d.%d.%d/%d", this.low >> 24 & 0xFF, this.low >> 16 & 0xFF, this.low >> 8 & 0xFF, this.low & 0xFF, mask);
        }

        boolean inRange(String address) {
            int diff = CIDRAddress.toInteger(address) - this.low;
            return diff >= 0 && diff <= this.high - this.low;
        }
    }

    public static interface AccountValidator {
        public void checkRequiredParameters(BareJID var1, Map<String, String> var2) throws XMPPProcessorException;

        public boolean sendAccountValidation(BareJID var1, Map<String, String> var2);

        public BareJID validateAccount(String var1);
    }
}

