/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.ArrayList;
import tigase.server.Packet;
import tigase.xml.Element;

public class ElementMatcher {
    private final String[] path;
    private final boolean value;
    private final String xmlns;

    public static ElementMatcher create(String str) {
        boolean value;
        ArrayList<String> path = new ArrayList<String>();
        String xmlns = null;
        int offset = 0;
        boolean bl = value = !str.startsWith("-");
        if (str.charAt(0) == '-' || str.charAt(0) == '+') {
            str = str.substring(1);
        }
        while (true) {
            String elemName = null;
            int slashIdx = str.indexOf(47, offset);
            int sIdx = str.indexOf(91, offset);
            if (slashIdx < 0) {
                slashIdx = str.length();
            }
            Object c = null;
            if (slashIdx < sIdx || sIdx < 0) {
                elemName = str.substring(offset, slashIdx);
                xmlns = null;
            } else {
                int eIdx = str.indexOf(93, sIdx);
                elemName = str.substring(offset, sIdx);
                xmlns = str.substring(sIdx + 1, eIdx);
                slashIdx = str.indexOf(47, eIdx);
                if (slashIdx < 0) {
                    slashIdx = str.length();
                }
            }
            if (elemName != null && !elemName.isEmpty()) {
                path.add(elemName.intern());
            }
            if (slashIdx == str.length()) break;
            offset = slashIdx + 1;
        }
        if (xmlns != null) {
            xmlns = xmlns.intern();
        }
        return new ElementMatcher(path.toArray(new String[0]), xmlns, value);
    }

    public ElementMatcher(String[] path, String xmlns, boolean value) {
        this.path = path;
        this.xmlns = xmlns;
        this.value = value;
    }

    public boolean matches(Packet packet) {
        Element child = packet.getElement().findChildStaticStr(this.path);
        return child != null && (this.xmlns == null || this.xmlns == child.getXMLNS());
    }

    public boolean getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.value) {
            sb.append('-');
        }
        for (String p : this.path) {
            sb.append('/');
            sb.append(p);
        }
        if (this.xmlns != null) {
            sb.append("[");
            sb.append(this.xmlns);
            sb.append("]");
        }
        return sb.toString();
    }
}

