/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts.filter;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.vhosts.filter.Rule;
import tigase.xmpp.jid.JID;

public final class CustomDomainFilter {
    private static final Logger log = Logger.getLogger(CustomDomainFilter.class.getName());

    public static boolean isAllowed(JID source, JID destination, String rules) {
        try {
            Set<Rule> parseRules = CustomDomainFilter.parseRules(rules);
            if (parseRules != null) {
                return CustomDomainFilter.isAllowed(source, destination, parseRules);
            }
            return true;
        }
        catch (ParseException e) {
            return true;
        }
    }

    public static boolean isAllowed(JID source, JID destination, String[] rules) {
        Set<Rule> parseRules = null;
        try {
            parseRules = CustomDomainFilter.parseRules(rules);
        }
        catch (ParseException e) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Error while parsing rules: " + Arrays.toString(rules), e);
            }
            return true;
        }
        if (parseRules != null) {
            return CustomDomainFilter.isAllowed(source, destination, parseRules);
        }
        return true;
    }

    public static boolean isAllowed(JID source, JID destination, Set<Rule> rules) {
        if (rules != null) {
            for (Rule rule : rules) {
                log.log(Level.FINEST, "Processing source: {0}, destination: {1}, against rule: {2}", new Object[]{source, destination, rule});
                if (!rule.isMatched(source, destination)) continue;
                log.log(Level.FINEST, "Matched source: {0}, destination: {1}, allowed: {2}", new Object[]{source, destination, rule.isAllowed()});
                return rule.isAllowed();
            }
        } else {
            return true;
        }
        return true;
    }

    public static Set<Rule> parseRules(String[] rules) throws ParseException {
        TreeSet<Rule> rulesSet = new TreeSet<Rule>();
        for (String rule : rules) {
            String[] split = rule.split("\\|");
            if (split != null && (split.length == 3 || split.length == 4)) {
                try {
                    Integer id = Integer.valueOf(split[0]);
                    boolean allow = false;
                    if (split[1].equalsIgnoreCase("allow")) {
                        allow = true;
                    } else if (split[1].equalsIgnoreCase("deny")) {
                        allow = false;
                    }
                    Rule.RuleType type = Rule.RuleType.valueOf(split[2].toLowerCase());
                    JID jid = null;
                    if (split.length == 4) {
                        jid = JID.jidInstance((String)split[3]);
                    }
                    if (type == Rule.RuleType.jid && jid == null) {
                        throw new ParseException("Error while pasing rule (no value for JID provided): " + rule, 0);
                    }
                    rulesSet.add(new Rule(id, allow, type, jid));
                    continue;
                }
                catch (Exception ex) {
                    log.log(Level.FINEST, "Error while pasing rule: " + rule, ex);
                    throw new ParseException("Error while pasing rule: " + rule, 0);
                }
            }
            log.log(Level.FINEST, "Error while pasing rule (wrong number of parameters): " + rule);
            throw new ParseException("Error while pasing rule: " + rule, 0);
        }
        return rulesSet;
    }

    public static Set<Rule> parseRules(String rules) throws ParseException {
        String[] rulesArr = rules.split(";");
        if (rulesArr != null) {
            return CustomDomainFilter.parseRules(rulesArr);
        }
        return null;
    }

    private CustomDomainFilter() {
    }
}

