/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.log;

import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import tigase.util.log.LogWithStackTraceEntry;

public class LogFormatter
extends Formatter {
    public static final Map<Integer, LogWithStackTraceEntry> errors = new ConcurrentSkipListMap<Integer, LogWithStackTraceEntry>();
    protected static int DATE_TIME_LEN = 24;
    private static int LEVEL_OFFSET = 12;
    private static int MED_LEN = 40;
    private static int TH_NAME_LEN = 17;
    protected Calendar cal = Calendar.getInstance();

    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder(200);
        this.cal.setTimeInMillis(record.getMillis());
        sb.append(String.format("%1$tF %1$tT.%1$tL", this.cal));
        String th_name = Thread.currentThread().getName();
        sb.append(" [").append(th_name).append("]");
        while (sb.length() < DATE_TIME_LEN + TH_NAME_LEN) {
            sb.append(' ');
        }
        if (record.getSourceClassName() != null) {
            String clsName = record.getSourceClassName();
            int idx = clsName.lastIndexOf(46);
            if (idx >= 0) {
                clsName = clsName.substring(idx + 1);
            }
            sb.append("  ").append(clsName);
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".").append(record.getSourceMethodName()).append("()");
        }
        while (sb.length() < DATE_TIME_LEN + TH_NAME_LEN + MED_LEN) {
            sb.append(' ');
        }
        sb.append("  ").append(record.getLevel()).append(": ");
        while (sb.length() < DATE_TIME_LEN + TH_NAME_LEN + MED_LEN + LEVEL_OFFSET) {
            sb.append(' ');
        }
        sb.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            sb.append('\n').append(record.getThrown().toString());
            StringBuilder st_sb = new StringBuilder(1024);
            this.getStackTrace(st_sb, record.getThrown());
            sb.append(st_sb.toString());
            this.addError(record.getThrown(), st_sb.toString(), sb.toString());
        }
        return sb.toString() + "\n";
    }

    protected void addError(Throwable thrown, String stack, String log_msg) {
        Integer code = stack.hashCode();
        LogWithStackTraceEntry entry = errors.get(code);
        if (entry == null) {
            String msg = thrown.getMessage();
            if (msg == null) {
                msg = thrown.toString();
            }
            entry = new LogWithStackTraceEntry(msg, log_msg);
            errors.put(code, entry);
        }
        entry.increment();
    }

    protected void getStackTrace(StringBuilder sb, Throwable th) {
        Throwable cause;
        StackTraceElement[] stackTrace;
        if (sb.length() > 0) {
            sb.append("\nCaused by: ").append(th.toString());
        }
        if ((stackTrace = th.getStackTrace()) != null && stackTrace.length > 0) {
            for (int i = 0; i < stackTrace.length; ++i) {
                sb.append("\n\tat ").append(stackTrace[i].toString());
            }
        }
        if ((cause = th.getCause()) != null) {
            this.getStackTrace(sb, cause);
        }
    }
}

