/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.util.logging.Level;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.stats.CounterValue;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;

@Bean(name="stream-error-counter", parent=ClientConnectionManager.class, active=false)
public class StreamErrorCounterIOProcessor
implements XMPPIOProcessor {
    public static final String ID = "stream-error-counter";
    private String compName;
    private ErrorStatisticsHolder holder = new ErrorStatisticsHolder();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        this.holder.getStatistics(this.compName, list);
    }

    @Override
    public Element[] supStreamFeatures(XMPPIOService service) {
        return null;
    }

    @Override
    public boolean processIncoming(XMPPIOService service, Packet packet) {
        return false;
    }

    @Override
    public boolean processOutgoing(XMPPIOService service, Packet packet) {
        return false;
    }

    @Override
    public void packetsSent(XMPPIOService service) throws IOException {
    }

    @Override
    public void processCommand(XMPPIOService service, Packet packet) {
    }

    @Override
    public boolean serviceStopped(XMPPIOService service, boolean streamClosed) {
        return false;
    }

    @Override
    public void streamError(XMPPIOService service, StreamError streamError) {
        if (streamError == null) {
            streamError = StreamError.UndefinedCondition;
        }
        this.holder.count(streamError);
    }

    public static class ErrorStatisticsHolder {
        private static final String[] ERROR_NAMES;
        private final CounterValue[] counters = new CounterValue[ERROR_NAMES.length];

        public static String[] getErrorNames() {
            return ERROR_NAMES;
        }

        public ErrorStatisticsHolder() {
            for (int i = 0; i < this.counters.length; ++i) {
                this.counters[i] = new CounterValue(ERROR_NAMES[i], Level.FINER);
            }
        }

        public void count(StreamError val) {
            this.counters[val.ordinal()].inc();
        }

        public void getStatistics(String compName, StatisticsList list) {
            for (CounterValue c : this.counters) {
                list.add(compName, "StreamErrorStats/" + c.getName() + "ErrorsNumber", c.getValue(), c.getLevel());
            }
        }

        static {
            int count = StreamError.values().length;
            ERROR_NAMES = new String[count];
            StreamError[] vals = StreamError.values();
            for (int i = 0; i < vals.length; ++i) {
                String name = vals[i].getCondition();
                StringBuilder sb = new StringBuilder();
                for (String part : name.split("-")) {
                    sb.append(Character.toUpperCase(part.charAt(0)));
                    sb.append(part.substring(1));
                }
                ErrorStatisticsHolder.ERROR_NAMES[i] = sb.toString();
            }
        }
    }
}

