/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.eventbus.events.ShutdownEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManagerIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="seeOtherHost", parent=ClientConnectionManager.class, active=true)
@ClusterModeRequired(active=false)
public class SeeOtherHost
implements SeeOtherHostIfc,
Initializable {
    public static final String REDIRECTION_ENABLED = "see-other-host-redirect-enabled";
    private static final Logger log = Logger.getLogger(SeeOtherHost.class.getName());
    @ConfigField(desc="Default host to redirect to")
    protected List<BareJID> defaultHost = null;
    @Inject
    protected EventBus eventBus;
    @Inject
    protected VHostManagerIfc vHostManager = null;
    @ConfigField(desc="Active phases", alias="phases")
    private ArrayList<SeeOtherHostIfc.Phase> active = new ArrayList<SeeOtherHostIfc.Phase>(Arrays.asList(SeeOtherHostIfc.Phase.OPEN));
    private Set<String> shutdownNodes = new CopyOnWriteArraySet<String>();

    @Override
    public BareJID findHostForJID(BareJID jid, BareJID host) {
        if (this.defaultHost != null && !this.defaultHost.isEmpty()) {
            return this.defaultHost.get(0);
        }
        return host;
    }

    @Override
    public void initialize() {
        ArrayList<VHostItem.DataType> types = new ArrayList<VHostItem.DataType>();
        types.add(new VHostItem.DataType(REDIRECTION_ENABLED, "see-other-host redirection enabled", Boolean.class, Boolean.TRUE));
        VHostItem.registerData(types);
    }

    public void setDefaultHost(List<BareJID> defaultHost) {
        if (defaultHost != null) {
            Collections.sort(defaultHost);
        }
        this.defaultHost = defaultHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNodes(List<JID> nodes) {
        SeeOtherHost seeOtherHost = this;
        synchronized (seeOtherHost) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String shutdownNode : this.shutdownNodes) {
                boolean found = false;
                for (JID node : nodes) {
                    found |= shutdownNode.equals(node.getDomain());
                }
                if (found) continue;
                toRemove.add(shutdownNode);
            }
            this.shutdownNodes.removeAll(toRemove);
        }
    }

    @Override
    public boolean isEnabled(VHostItem vHost, SeeOtherHostIfc.Phase ph) {
        return (Boolean)vHost.getData(REDIRECTION_ENABLED) != false && this.active.contains((Object)ph);
    }

    @Override
    public void start() {
        this.eventBus.registerAll(this);
    }

    @Override
    public void stop() {
        this.eventBus.unregisterAll(this);
    }

    protected boolean isNodeShutdown(BareJID jid) {
        return jid != null && this.shutdownNodes.contains(jid.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HandleEvent
    protected void nodeShutdown(ShutdownEvent event) {
        SeeOtherHost seeOtherHost = this;
        synchronized (seeOtherHost) {
            this.shutdownNodes.add(event.getNode());
        }
    }
}

