/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import tigase.server.Command;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;

public class DataForm {
    public static final String FIELD_EL = "field";
    public static final String VALUE_EL = "value";
    protected static final String[] FIELD_VALUE_PATH = new String[]{"field", "value"};
    private static final Logger log = Logger.getLogger(DataForm.class.getName());

    public static void addCheckBoxField(Element el, String f_name, boolean f_value) {
        DataForm.addFieldValue(el, f_name, Boolean.toString(f_value), "boolean");
    }

    public static Element createDataForm(Command.DataType data_type) {
        return new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", data_type.name()});
    }

    public static Element addDataForm(Element el, Command.DataType data_type) {
        Element x = DataForm.createDataForm(data_type);
        el.addChild((XMLNodeIfc)x);
        return x;
    }

    public static void addField(Element el, String f_name, String f_label, String type) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape((String)f_name), type, f_label});
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldMultiValue(Element el, String f_name, List<String> f_value) {
        DataForm.addFieldMultiValue(el, f_name, f_value, null);
    }

    public static void addFieldMultiValue(Element el, String f_name, List<String> f_value, String label) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.result);
        }
        if (f_value != null) {
            Element field = new Element(FIELD_EL, new String[]{"var", "type"}, new String[]{XMLUtils.escape((String)f_name), "text-multi"});
            if (label != null) {
                field.addAttribute("label", label);
            }
            for (String val : f_value) {
                if (val == null) continue;
                Element value = new Element(VALUE_EL, XMLUtils.escape((String)val));
                field.addChild((XMLNodeIfc)value);
            }
            x.addChild((XMLNodeIfc)field);
        }
    }

    public static void addFieldMultiValue(Element el, String f_name, Throwable ex) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        ArrayList<String> f_value = null;
        if (ex != null) {
            f_value = new ArrayList<String>(100);
            f_value.add(ex.getLocalizedMessage());
            for (StackTraceElement ste : ex.getStackTrace()) {
                f_value.add("  " + ste.toString());
            }
        }
        if (f_value != null) {
            Element field = new Element(FIELD_EL, new String[]{"var", "type"}, new String[]{XMLUtils.escape((String)f_name), "text-multi"});
            for (String val : f_value) {
                if (val == null) continue;
                Element value = new Element(VALUE_EL, XMLUtils.escape((String)val));
                field.addChild((XMLNodeIfc)value);
            }
            x.addChild((XMLNodeIfc)field);
        }
    }

    public static void addFieldValue(Element el, String f_name, String f_value) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape((String)f_value))}, new String[]{"var"}, new String[]{XMLUtils.escape((String)f_name)});
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldValue(Element el, String f_name, String f_value, String label, String[] labels, String[] options) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape((String)f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape((String)f_name), "list-single", XMLUtils.escape((String)label)});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild((XMLNodeIfc)new Element("option", new Element[]{new Element(VALUE_EL, XMLUtils.escape((String)options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape((String)labels[i])}));
        }
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldValue(Element el, String f_name, String[] f_values, String label, String[] labels, String[] options) {
        int i;
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape((String)f_name), "list-multi", XMLUtils.escape((String)label)});
        for (i = 0; i < labels.length; ++i) {
            field.addChild((XMLNodeIfc)new Element("option", new Element[]{new Element(VALUE_EL, XMLUtils.escape((String)options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape((String)labels[i])}));
        }
        for (i = 0; i < f_values.length; ++i) {
            field.addChild((XMLNodeIfc)new Element(VALUE_EL, XMLUtils.escape((String)f_values[i])));
        }
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldValue(Element el, String f_name, String f_value, String label, String[] labels, String[] options, String type) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape((String)f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape((String)f_name), type, XMLUtils.escape((String)label)});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild((XMLNodeIfc)new Element("option", new Element[]{new Element(VALUE_EL, XMLUtils.escape((String)options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape((String)labels[i])}));
        }
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldValue(Element el, String f_name, String f_value, String type) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape((String)f_value))}, new String[]{"var", "type"}, new String[]{XMLUtils.escape((String)f_name), type});
        x.addChild((XMLNodeIfc)field);
    }

    public static void addFieldValue(Element el, String f_name, String f_value, String type, String label) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape((String)f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape((String)f_name), type, XMLUtils.escape((String)label)});
        x.addChild((XMLNodeIfc)field);
    }

    public static void addHiddenField(Element el, String f_name, String f_value) {
        DataForm.addFieldValue(el, f_name, f_value, "hidden");
    }

    public static void addInstructions(Element el, String instructions) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        x.addChild((XMLNodeIfc)new Element("instructions", instructions));
    }

    public static void addTextField(Element el, String f_name, String f_value) {
        DataForm.addFieldValue(el, f_name, f_value, "fixed");
    }

    public static void addTitle(Element el, String title) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        x.addChild((XMLNodeIfc)new Element("title", title));
    }

    public static String getFieldKeyStartingWith(Element el, String f_name) {
        List children;
        Element x = el.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").startsWith(f_name)) continue;
                return child.getAttributeStaticStr("var");
            }
        }
        return null;
    }

    public static String getFieldValue(Element el, String f_name) {
        List children;
        Element x = el.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                String value;
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").equals(f_name) || (value = child.getChildCDataStaticStr(FIELD_VALUE_PATH)) == null) continue;
                return XMLUtils.unescape((String)value);
            }
        }
        return null;
    }

    public static String[] getFieldValues(Element el, String f_name) {
        List children;
        Element x = el.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").equals(f_name)) continue;
                LinkedList<String> values = new LinkedList<String>();
                List val_children = child.getChildren();
                if (val_children != null) {
                    for (Element val_child : val_children) {
                        String value;
                        if (!val_child.getName().equals(VALUE_EL) || (value = val_child.getCData()) == null) continue;
                        values.add(XMLUtils.unescape((String)value));
                    }
                }
                return values.toArray(new String[0]);
            }
        }
        return null;
    }

    public static boolean removeFieldValue(Element el, String f_name) {
        List children;
        Element x = el.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").equals(f_name)) continue;
                return x.removeChild(child);
            }
        }
        return false;
    }

    public static enum FieldType {
        Boolean,
        Fixed,
        Hidden,
        JidMulti,
        JidSingle,
        ListMulti,
        ListSingle,
        TextMulti,
        TextPrivate,
        TextSingle;


        public String value() {
            switch (this) {
                case Boolean: {
                    return "boolean";
                }
                case Fixed: {
                    return "fixed";
                }
                case Hidden: {
                    return "hidden";
                }
                case JidMulti: {
                    return "jid-multi";
                }
                case JidSingle: {
                    return "jid-single";
                }
                case ListMulti: {
                    return "list-multi";
                }
                case ListSingle: {
                    return "list-single";
                }
                case TextMulti: {
                    return "text-multi";
                }
                case TextPrivate: {
                    return "text-private";
                }
                case TextSingle: {
                    return "text-single";
                }
            }
            return null;
        }
    }

    public static class Field {

        public static class Builder {
            private final Element parent;
            private final Element el;
            private final FieldType type;

            public Builder(Element form, FieldType type, String var) {
                this.parent = form;
                this.type = Optional.ofNullable(type).orElse(FieldType.TextSingle);
                this.el = new Element(DataForm.FIELD_EL);
                this.el.setAttribute("var", var);
                if (type != null) {
                    this.el.setAttribute("type", type.value());
                }
            }

            public Builder setLabel(String label) {
                if (label == null) {
                    this.el.removeAttribute("label");
                } else {
                    this.el.setAttribute("label", label);
                }
                return this;
            }

            public Builder setDesc(String desc) {
                this.removeChildren("desc");
                if (desc != null) {
                    this.el.addChild((XMLNodeIfc)new Element("desc", desc));
                }
                return this;
            }

            public Builder setRequired(boolean required) {
                this.removeChildren("required");
                if (required) {
                    this.el.addChild((XMLNodeIfc)new Element("required"));
                }
                return this;
            }

            public Builder addOption(String value) {
                this.addOption(value, null);
                return this;
            }

            public Builder addOption(String value, String label) {
                switch (this.type) {
                    case ListMulti: 
                    case ListSingle: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Invalid field type!");
                    }
                }
                Element option = new Element("option");
                if (label != null) {
                    option.setAttribute("label", label);
                }
                option.addChild((XMLNodeIfc)new Element(DataForm.VALUE_EL, value));
                this.el.addChild((XMLNodeIfc)option);
                return this;
            }

            public Builder setOptions(String[] values) {
                return this.setOptions(values, null);
            }

            public Builder setOptions(String[] values, String[] labels) {
                for (int i = 0; i < values.length; ++i) {
                    this.addOption(values[i], labels == null ? null : labels[i]);
                }
                return this;
            }

            public Builder setValue(Boolean value) {
                return this.setValue(value == null ? null : (value != false ? "true" : "false"));
            }

            public Builder setValue(String value) {
                switch (this.type) {
                    case ListMulti: 
                    case JidMulti: 
                    case TextMulti: {
                        throw new UnsupportedOperationException("Invalid field type!");
                    }
                }
                this.removeOldValues();
                if (value != null) {
                    this.el.addChild((XMLNodeIfc)new Element(DataForm.VALUE_EL, value));
                }
                return this;
            }

            public Builder setValues(String[] values) {
                switch (this.type) {
                    case ListSingle: 
                    case Boolean: 
                    case Fixed: 
                    case Hidden: 
                    case JidSingle: 
                    case TextSingle: 
                    case TextPrivate: {
                        throw new UnsupportedOperationException("Invalid field type!");
                    }
                }
                this.removeOldValues();
                if (values != null) {
                    for (String value : values) {
                        this.el.addChild((XMLNodeIfc)new Element(DataForm.VALUE_EL, value));
                    }
                }
                return this;
            }

            public Element build() {
                if (this.parent != null) {
                    this.parent.addChild((XMLNodeIfc)this.el);
                }
                return this.el;
            }

            private void removeOldValues() {
                this.removeChildren(DataForm.FIELD_EL);
            }

            private void removeChildren(String name) {
                List oldValues = this.el.mapChildren(el -> el.getName() == name, Function.identity());
                if (oldValues != null) {
                    for (Element oldValue : oldValues) {
                        this.el.removeChild(oldValue);
                    }
                }
            }
        }
    }

    public static class Item {

        public static class Builder {
            private final Element x;
            private final Element item;

            public Builder(Element x) {
                this.x = x;
                this.item = new Element("item");
            }

            public Field.Builder addField(String var) {
                return new Field.Builder(this.item, null, var);
            }

            public Builder withFields(Consumer<Builder> consumer) {
                consumer.accept(this);
                return this;
            }

            public Element build() {
                if (this.x != null) {
                    this.x.addChild((XMLNodeIfc)this.item);
                }
                return this.item;
            }
        }
    }

    public static class Reported {

        public static class Builder {
            private final Element x;
            private final Element reported;

            public Builder(Element x) {
                this.x = x;
                this.reported = new Element("reported");
            }

            public Field.Builder addField(FieldType type, String var) {
                return new Field.Builder(this.reported, type, var);
            }

            public Builder withFields(Consumer<Builder> consumer) {
                consumer.accept(this);
                return this;
            }

            public Element build() {
                if (this.x != null) {
                    this.x.addChild((XMLNodeIfc)this.reported);
                }
                return this.reported;
            }
        }
    }

    public static class Builder {
        private final Element x;

        public Builder(Element parent, Command.DataType type) {
            this.x = Optional.ofNullable(parent.getChild("x", "jabber:x:data")).orElseGet(() -> Builder.createDataEl(parent));
            this.x.setAttribute("type", type.name());
        }

        public Builder addTitle(String title) {
            Element old;
            while ((old = this.x.getChild("title")) != null) {
                this.x.removeChild(old);
            }
            if (title != null) {
                this.x.addChild((XMLNodeIfc)new Element("title", title));
            }
            return this;
        }

        public Builder addInstructions(String[] instructions) {
            List oldValues = this.x.mapChildren(el -> el.getName() == "instructions", Function.identity());
            if (oldValues != null) {
                for (Element oldValue : oldValues) {
                    this.x.removeChild(oldValue);
                }
            }
            if (instructions != null) {
                for (String instruction : instructions) {
                    this.x.addChild((XMLNodeIfc)new Element("instructions", instruction));
                }
            }
            return this;
        }

        public Field.Builder addField(FieldType type, String var) {
            return new Field.Builder(this.x, type, var);
        }

        public Builder withFields(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        public Builder withReported(Consumer<Reported.Builder> consumer) {
            Reported.Builder builder = new Reported.Builder(this.x);
            consumer.accept(builder);
            builder.build();
            return this;
        }

        public Builder withItem(Consumer<Item.Builder> consumer) {
            Item.Builder builder = new Item.Builder(this.x);
            consumer.accept(builder);
            builder.build();
            return this;
        }

        public Element build() {
            return this.x;
        }

        private static Element createDataEl(Element parent) {
            Element dataEl = new Element("x", "jabber:x:data");
            parent.addChild((XMLNodeIfc)dataEl);
            return dataEl;
        }
    }
}

