/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tigase.kernel.core.Dependency;
import tigase.kernel.core.Kernel;

public class BeanConfig {
    private final String beanName;
    private final Class<?> clazz;
    private final Map<Field, Dependency> fieldDependencies = new HashMap<Field, Dependency>();
    private String beanInstanceName = null;
    private boolean exportable;
    private BeanConfig factory;
    private Kernel kernel;
    private boolean pinned = true;
    private Set<BeanConfig> registeredBeans = new HashSet<BeanConfig>();
    private Set<BeanConfig> registeredBy = new HashSet<BeanConfig>();
    private Source source = Source.hardcoded;
    private State state;

    BeanConfig(String id, Class<?> clazz) {
        this.beanName = id;
        this.clazz = clazz;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanConfig other = (BeanConfig)obj;
        return !(this.beanName == null ? other.beanName != null : !this.beanName.equals(other.beanName));
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public BeanConfig getFactory() {
        return this.factory;
    }

    void setFactory(BeanConfig bfc) {
        this.factory = bfc;
    }

    public Map<Field, Dependency> getFieldDependencies() {
        return this.fieldDependencies;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public State getState() {
        return this.state;
    }

    void setState(State state) {
        this.state = state;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beanName == null ? 0 : this.beanName.hashCode());
        return result;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    void setExportable(boolean value) {
        this.exportable = value;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public Source getSource() {
        return this.source;
    }

    void setSource(Source source) {
        this.source = source;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BeanConfig{");
        sb.append("beanName='").append(this.beanName).append('\'');
        sb.append(", clazz=").append(this.clazz);
        sb.append(", exportable=").append(this.exportable);
        sb.append(", pinned=").append(this.pinned);
        sb.append(", factory=").append(this.factory);
        sb.append(", kernel=").append(this.kernel.getName());
        sb.append(", source=").append((Object)this.source);
        sb.append(", state=").append((Object)this.state);
        sb.append('}');
        return sb.toString();
    }

    public Set<BeanConfig> getRegisteredBeans() {
        return this.registeredBeans;
    }

    public void addRegisteredBean(BeanConfig beanConfig) {
        this.registeredBeans.add(beanConfig);
    }

    public void removeRegisteredBean(BeanConfig beanConfig) {
        this.registeredBeans.remove(beanConfig);
    }

    public void addRegisteredBy(BeanConfig beanConfig) {
        this.registeredBy.add(beanConfig);
    }

    public boolean removeRegisteredBy(BeanConfig beanConfig) {
        this.registeredBy.remove(beanConfig);
        return this.registeredBy.isEmpty();
    }

    public Set<BeanConfig> getRegisteredBy() {
        return this.registeredBy;
    }

    protected String getBeanInstanceName() {
        return this.beanInstanceName == null ? this.getBeanName() : this.beanInstanceName;
    }

    protected void setBeanInstanceName(String beanInstanceName) {
        this.beanInstanceName = beanInstanceName;
    }

    public static enum State {
        initialized,
        instanceCreated,
        registered,
        inactive;

    }

    public static enum Source {
        hardcoded,
        annotation,
        configuration;

    }
}

