/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.component;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.eventbus.EventRoutedTransientFiller;
import tigase.eventbus.component.AbstractEventBusModule;
import tigase.eventbus.component.ElemPathCriteria;
import tigase.eventbus.component.EventPublisherModule;
import tigase.eventbus.component.stores.Affiliation;
import tigase.eventbus.component.stores.AffiliationStore;
import tigase.eventbus.component.stores.Subscription;
import tigase.eventbus.component.stores.SubscriptionStore;
import tigase.eventbus.impl.EventBusImplementation;
import tigase.eventbus.impl.EventBusSerializer;
import tigase.eventbus.impl.EventName;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

@Bean(name="receiver", active=true)
public class EventReceiverModule
extends AbstractEventBusModule {
    public static final String ID = "receiver";
    private static final Logger log = Logger.getLogger(EventReceiverModule.class.getCanonicalName());
    private static final Criteria CRIT = new ElemPathCriteria(new String[]{"message", "event"}, new String[]{null, "http://jabber.org/protocol/pubsub#event"});
    @Inject
    private AffiliationStore affiliationStore;
    @Inject
    private EventPublisherModule eventPublisherModule;
    @Inject(nullAllowed=false, bean="localEventBus")
    private EventBusImplementation localEventBus;
    private EventBusSerializer serializer = new EventBusSerializer();
    @Inject
    private SubscriptionStore subscriptionStore;

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        Affiliation affiliation = this.affiliationStore.getAffiliation(packet.getStanzaFrom());
        if (!affiliation.isPublishItem()) {
            throw new ComponentException(Authorization.FORBIDDEN);
        }
        String type = packet.getElement().getAttributeStaticStr("type");
        if (type != null && type.equals("error")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Ignoring error message! " + packet);
            }
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Received event stanza: " + packet.toStringFull());
        }
        Element eventElem = packet.getElement().getChild("event", "http://jabber.org/protocol/pubsub#event");
        Element itemsElem = eventElem.getChild("items");
        for (Element item : itemsElem.getChildren()) {
            if (!"item".equals(item.getName())) continue;
            for (Element event : item.getChildren()) {
                EventName eventName = new EventName(event.getName());
                event.setAttribute("remote", "true");
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Received event " + eventName + ": " + event);
                }
                this.fireEventLocally(eventName, event);
                Collection<Subscription> subscribers = this.subscriptionStore.getSubscribersJIDs(eventName.getPackage(), eventName.getName());
                Iterator<Subscription> it = subscribers.iterator();
                while (it.hasNext()) {
                    Subscription subscription = it.next();
                    if (!subscription.isInClusterSubscription()) continue;
                    it.remove();
                }
                this.eventPublisherModule.publishEvent(eventName.getPackage(), eventName.getName(), event, subscribers);
            }
        }
    }

    private void fireEventLocally(EventName name, Element event) {
        Object obj = this.serializer.deserialize(event);
        if (obj == null) {
            obj = event;
        } else {
            boolean ready = true;
            Collection<EventRoutedTransientFiller> fillers = this.localEventBus.getEventRoutedTransientFillers(obj.getClass());
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "for event = {0}, found following fillers: {1}", new Object[]{name, fillers});
            }
            if (fillers != null) {
                for (EventRoutedTransientFiller f : fillers) {
                    ready &= f.fillEvent(obj);
                }
            }
            if (!ready) {
                return;
            }
        }
        this.localEventBus.fire(obj, this, true);
    }
}

