/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.beans;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.beans.DataSourceBean;
import tigase.db.beans.MDPoolConfigBean;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;

public abstract class AuthUserRepositoryConfigBean<T, U extends AuthUserRepositoryConfigBean<T, U>>
extends MDPoolConfigBean<T, U>
implements ConfigurationChangedAware,
Initializable,
UnregisterAware {
    private static final Logger log = Logger.getLogger(AuthUserRepositoryConfigBean.class.getCanonicalName());
    private DataSource dataSource;
    @Inject
    private DataSourceBean dataSourceBean;
    @ConfigField(desc="Name of data source to use", alias="data-source")
    private String dataSourceName;
    @Inject
    private EventBus eventBus;
    private String repositoryUri;

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (this.dataSourceBean != null) {
            if (this.uri == null) {
                this.repositoryUri = this.dataSourceName != null ? this.dataSourceName : this.name;
                this.dataSource = this.dataSourceBean.getRepository(this.repositoryUri);
                if (this.dataSource != null) {
                    this.repositoryUri = this.dataSource.getResourceUri();
                }
            } else {
                this.repositoryUri = this.uri;
            }
        }
        super.beanConfigurationChanged(changedFields);
    }

    @Override
    public void initialize() {
        this.eventBus.registerAll(this);
        super.initialize();
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    @Override
    protected String getUri() {
        return this.repositoryUri;
    }

    @Override
    protected String getRepositoryClassName() throws DBInitException {
        if (this.cls != null) {
            return this.cls;
        }
        return RepositoryFactory.getRepoClassName(this.getRepositoryIfc(), this.repositoryUri);
    }

    @Override
    protected void initRepository(T repository) throws RepositoryException {
        boolean initialized = false;
        if (repository instanceof Repository) {
            try {
                Method m = repository.getClass().getDeclaredMethod("initRepository", String.class, Map.class);
                if (m.getAnnotation(Deprecated.class) == null) {
                    log.log(Level.WARNING, "Class {0} is using deprecated initialization using method initRepository()", repository.getClass().getCanonicalName());
                    ((Repository)repository).initRepository(this.getUri(), new HashMap<String, String>());
                    initialized = true;
                }
            }
            catch (NoSuchMethodException | SecurityException m) {
                // empty catch block
            }
        }
        if (!initialized && repository instanceof DataSourceAware) {
            DataSourceAware dsAwareRepository = (DataSourceAware)repository;
            this.dataSource.checkSchemaVersion(dsAwareRepository, true);
            dsAwareRepository.setDataSource(this.dataSource);
        }
    }

    @Override
    protected String getRepositoryPoolClassName() {
        return null;
    }

    @HandleEvent
    protected void onDataSourceChange(DataSourceBean.DataSourceChangedEvent event) {
        if (!event.isCorrectSender(this.dataSourceBean)) {
            return;
        }
        if (this.uri != null || !event.getDomain().equals(this.name) && !event.getDomain().equals(this.dataSourceName)) {
            return;
        }
        this.beanConfigurationChanged(Collections.singleton("uri"));
    }
}

