/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.util.Algorithms;
import tigase.util.Base64;
import tigase.xmpp.jid.BareJID;

public class AuthRepositoryImpl
implements AuthRepository {
    public static final String ACCOUNT_STATUS_KEY = "account_status";
    protected static final Logger log = Logger.getLogger("tigase.db.UserAuthRepositoryImpl");
    protected static final String DISABLED_KEY = "disabled";
    protected static final String PASSWORD_KEY = "password";
    private static final String[] non_sasl_mechs = new String[]{"password", "digest"};
    private static final String[] sasl_mechs = new String[]{"PLAIN", "DIGEST-MD5", "CRAM-MD5"};
    private UserRepository repo = null;

    public AuthRepositoryImpl(UserRepository repo) {
        this.repo = repo;
    }

    @Override
    public void loggedIn(BareJID jid) throws TigaseDBException {
    }

    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        this.repo.addUser(user);
        log.info("Repo user added: " + user);
        this.updateCredential(user, "default", password);
        log.info("Password updated: " + user + ":" + password);
    }

    @Override
    public boolean isMechanismSupported(String domain, String mechanism) {
        if ("PLAIN".equals(mechanism)) {
            return true;
        }
        return true;
    }

    @Override
    public String getResourceUri() {
        return this.repo.getResourceUri();
    }

    @Override
    public long getUsersCount() {
        return this.repo.getUsersCount();
    }

    @Override
    public long getUsersCount(String domain) {
        return this.repo.getUsersCount(domain);
    }

    @Override
    @Deprecated
    public void initRepository(String string, Map<String, String> params) throws DBInitException {
    }

    @Override
    public void logout(BareJID user) {
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String proto;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "otherAuth: {0}", props);
        }
        if ((proto = (String)props.get("protocol")).equals("sasl")) {
            return this.saslAuth(props);
        }
        if (proto.equals("nonsasl")) {
            String password = (String)props.get(PASSWORD_KEY);
            BareJID user_id = (BareJID)props.get("user-id");
            if (password != null) {
                return this.plainAuth(user_id, password);
            }
            String digest = (String)props.get("digest");
            if (digest != null) {
                String digest_id = (String)props.get("digest-id");
                return this.digestAuth(user_id, digest, digest_id, "SHA");
            }
        }
        throw new AuthorizationException("Protocol is not supported.");
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", non_sasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", sasl_mechs);
        }
    }

    @Override
    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        this.repo.removeUser(user);
    }

    @Override
    public void updatePassword(BareJID user, String password) throws TigaseDBException {
        this.repo.setData(user, PASSWORD_KEY, password);
    }

    @Override
    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.repo.getData(user, PASSWORD_KEY);
    }

    @Override
    public AuthRepository.AccountStatus getAccountStatus(BareJID user) throws TigaseDBException {
        String value = this.repo.getData(user, ACCOUNT_STATUS_KEY);
        return value == null ? null : AuthRepository.AccountStatus.valueOf(value);
    }

    @Override
    public boolean isUserDisabled(BareJID user) throws UserNotFoundException, TigaseDBException {
        AuthRepository.AccountStatus st = this.getAccountStatus(user);
        if (st == null) {
            String value = this.repo.getData(user, DISABLED_KEY);
            return Boolean.parseBoolean(value);
        }
        return st == AuthRepository.AccountStatus.disabled;
    }

    @Override
    public void setAccountStatus(BareJID user, AuthRepository.AccountStatus value) throws TigaseDBException {
        if (value == null) {
            this.repo.removeData(user, ACCOUNT_STATUS_KEY);
        } else {
            this.repo.setData(user, ACCOUNT_STATUS_KEY, value.name());
        }
    }

    @Override
    public void setUserDisabled(BareJID user, Boolean value) throws UserNotFoundException, TigaseDBException {
        AuthRepository.AccountStatus status = this.getAccountStatus(user);
        if (status == AuthRepository.AccountStatus.active || status == AuthRepository.AccountStatus.disabled) {
            this.setAccountStatus(user, value != false ? AuthRepository.AccountStatus.disabled : AuthRepository.AccountStatus.active);
        }
    }

    private boolean digestAuth(BareJID user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String db_password = this.getPassword(user);
        try {
            String digest_db_pass = Algorithms.hexDigest((String)id, (String)db_password, (String)alg);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Comparing passwords, given: " + digest + ", db: " + digest_db_pass);
            }
            return digest.equals(digest_db_pass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthorizationException("No such algorithm.", e);
        }
    }

    private boolean plainAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "plainAuth: {0}:{1}", new Object[]{user, password});
        }
        String db_password = this.getPassword(user);
        return password != null && db_password != null && db_password.equals(password);
    }

    private boolean saslAuth(Map<String, Object> props) throws AuthorizationException {
        try {
            String data_str;
            byte[] in_data;
            SaslServer ss = (SaslServer)props.get("SaslServer");
            if (ss == null) {
                TreeMap<String, String> sasl_props = new TreeMap<String, String>();
                sasl_props.put("javax.security.sasl.qop", "auth");
                ss = Sasl.createSaslServer((String)props.get("mechanism"), "xmpp", (String)props.get("server-name"), sasl_props, new SaslCallbackHandler(props));
                props.put("SaslServer", ss);
            }
            byte[] byArray = in_data = (data_str = (String)props.get("data")) != null ? Base64.decode((String)data_str) : new byte[]{};
            if (log.isLoggable(Level.FINEST)) {
                log.finest("response: " + new String(in_data));
            }
            byte[] challenge = ss.evaluateResponse(in_data);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("challenge: " + (challenge != null ? new String(challenge) : "null"));
            }
            String challenge_str = challenge != null && challenge.length > 0 ? Base64.encode((byte[])challenge) : null;
            props.put("result", challenge_str);
            return ss.isComplete();
        }
        catch (SaslException e) {
            throw new AuthorizationException("Sasl exception.", e);
        }
    }

    private class SaslCallbackHandler
    implements CallbackHandler {
        private Map<String, Object> options = null;

        private SaslCallbackHandler(Map<String, Object> options) {
            this.options = options;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            BareJID jid = null;
            for (int i = 0; i < callbacks.length; ++i) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Callback: " + callbacks[i].getClass().getSimpleName());
                }
                if (callbacks[i] instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callbacks[i];
                    String realm = (String)this.options.get("realm");
                    if (realm != null) {
                        rc.setText(realm);
                    }
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("RealmCallback: " + realm);
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    String user_name = nc.getName();
                    if (user_name == null) {
                        user_name = nc.getDefaultName();
                    }
                    jid = BareJID.bareJIDInstanceNS((String)user_name, (String)((String)this.options.get("realm")));
                    this.options.put("user-id", jid);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("NameCallback: " + user_name);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    try {
                        String passwd = AuthRepositoryImpl.this.getPassword(jid);
                        pc.setPassword(passwd.toCharArray());
                        if (!log.isLoggable(Level.FINEST)) continue;
                        log.finest("PasswordCallback: " + passwd);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException("Password retrieving problem.", e);
                    }
                }
                if (callbacks[i] instanceof AuthorizeCallback) {
                    AuthorizeCallback authCallback = (AuthorizeCallback)callbacks[i];
                    String authenId = authCallback.getAuthenticationID();
                    String authorId = authCallback.getAuthorizationID();
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("AuthorizeCallback: authenId: " + authenId);
                        log.finest("AuthorizeCallback: authorId: " + authorId);
                    }
                    authCallback.setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

