/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auth.credentials.Credentials;
import tigase.auth.credentials.entries.PlainCredentialsEntry;
import tigase.auth.mechanisms.AbstractSaslSCRAM;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Base64;
import tigase.xmpp.jid.BareJID;

public class ScramCredentialsEntry
implements Credentials.Entry {
    private static final Logger log = Logger.getLogger(ScramCredentialsEntry.class.getCanonicalName());
    private final String algorithm;
    private final int iterations = 4096;
    private final byte[] salt;
    private final byte[] saltedPassword;

    public ScramCredentialsEntry(String algorithm, PlainCredentialsEntry entry) throws NoSuchAlgorithmException, InvalidKeyException {
        SecureRandom random = new SecureRandom();
        this.algorithm = algorithm;
        this.salt = new byte[10];
        random.nextBytes(this.salt);
        this.saltedPassword = AbstractSaslSCRAM.hi(algorithm, AbstractSaslSCRAM.normalize(entry.getPassword()), this.salt, 4096);
    }

    public ScramCredentialsEntry(String algorithm, byte[] salt, int iterations, byte[] saltedPassword) {
        this.algorithm = algorithm;
        this.salt = salt;
        this.saltedPassword = saltedPassword;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getSaltedPassword() {
        return this.saltedPassword;
    }

    public int getIterations() {
        return 4096;
    }

    @Override
    public String getMechanism() {
        return "SCRAM-" + this.algorithm;
    }

    @Override
    public boolean verifyPlainPassword(String password) {
        try {
            byte[] expSaltedPassword = AbstractSaslSCRAM.hi(this.algorithm, AbstractSaslSCRAM.normalize(password), this.salt, 4096);
            return Arrays.equals(this.saltedPassword, expSaltedPassword);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            log.log(Level.FINE, "Password comparison failed", ex);
            return false;
        }
    }

    public static class Encoder
    implements Credentials.Encoder {
        private final SecureRandom random = new SecureRandom();
        @ConfigField(desc="Hash algorithm")
        private String algorithm;
        @ConfigField(desc="Number of iterations")
        private int iterations = 4096;
        @ConfigField(desc="Mechanism name")
        private String name;

        public Encoder() {
        }

        protected Encoder(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String encode(BareJID user, String password) {
            byte[] salt = new byte[10];
            this.random.nextBytes(salt);
            byte[] saltedPassword = new byte[]{};
            try {
                saltedPassword = AbstractSaslSCRAM.hi(this.algorithm, AbstractSaslSCRAM.normalize(password), salt, this.iterations);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not encode password", e);
            }
            return "s=" + Base64.encode((byte[])salt) + ",i=" + this.iterations + ",p=" + Base64.encode((byte[])saltedPassword);
        }
    }

    public static class Decoder
    implements Credentials.Decoder {
        @ConfigField(desc="Hash algorithm")
        private String algorithm;
        @ConfigField(desc="Mechanism name")
        private String name;

        public Decoder() {
        }

        protected Decoder(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Credentials.Entry decode(BareJID user, String value) {
            byte[] salt = null;
            byte[] saltedPassword = null;
            int iterations = 0;
            int pos = 0;
            while (pos < value.length()) {
                char c = value.charAt(pos);
                int x = value.indexOf(",", pos + 2);
                String part = value.substring(pos + 2, x == -1 ? value.length() : x);
                switch (c) {
                    case 's': {
                        salt = Base64.decode((String)part);
                        break;
                    }
                    case 'i': {
                        iterations = Integer.parseInt(part);
                        break;
                    }
                    case 'p': {
                        saltedPassword = Base64.decode((String)part);
                    }
                }
                if (x == -1) break;
                pos = x + 1;
            }
            return this.newInstance(salt, iterations, saltedPassword);
        }

        protected Credentials.Entry newInstance(byte[] salt, int iterations, byte[] saltedPassword) {
            return new ScramCredentialsEntry(this.algorithm, salt, iterations, saltedPassword);
        }
    }
}

