/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.fcm;

import groovy.json.JsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.pubsub.Affiliation;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.INotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.push.fcm.FcmConnection;
import tigase.push.fcm.FcmProvider;
import tigase.push.modules.AffiliationChangedModule;

@Bean(name="fcm-xmpp-api", parent=PushNotificationsComponent.class, active=false)
public class FcmXmppApiProvider
implements UnregisterAware,
ConfigurationChangedAware,
IPushProvider,
FcmProvider {
    private static final Logger a = Logger.getLogger(FcmXmppApiProvider.class.getCanonicalName());
    @Inject
    private AffiliationChangedModule affiliationChangedModule;
    private List<FcmConnection> b = new ArrayList<FcmConnection>();
    @ConfigField(desc="Provider description")
    private String description = "Push provider for FCM - XMPP";
    @ConfigField(desc="Provider name")
    private String name = "fcm-xmpp-api";
    private BlockingDeque<FcmConnection> c = new LinkedBlockingDeque<FcmConnection>();
    @ConfigField(desc="Connections pool size", alias="pool-size")
    private int poolSize = 2;
    @Inject
    private IPushRepository repository;
    @ConfigField(desc="Sender ID", alias="sender-id")
    private String senderId;
    @ConfigField(desc="Server key", alias="server-key")
    private String serverKey;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void pushNotification(String deviceId, INotification notification) {
        Map<String, Object> map = this.preparePayload(notification);
        map.put("to", deviceId);
        String string = new JsonBuilder(map).toString();
        for (int i = 0; !this.a(string, i) && i < 3; ++i) {
        }
    }

    public void beforeUnregister() {
        for (FcmConnection fcmConnection : this.b) {
            fcmConnection.setProvider(null);
            fcmConnection.stop();
        }
        this.b.clear();
    }

    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (changedFields.contains("serverKey") || changedFields.contains("senderId") || changedFields.contains("poolSize")) {
            for (FcmConnection fcmConnection : this.b) {
                fcmConnection.setProvider(null);
                fcmConnection.stop();
            }
            this.b.clear();
            for (int i = 0; i < this.poolSize; ++i) {
                FcmConnection fcmConnection;
                fcmConnection = new FcmConnection(this.serverKey, this.senderId, false);
                fcmConnection.setProvider(this);
                fcmConnection.start();
                this.b.add(fcmConnection);
            }
        }
    }

    @Override
    public void connected(FcmConnection conn) {
        this.c.offer(conn);
    }

    @Override
    public void disconnected(FcmConnection conn) {
        this.c.remove(conn);
    }

    @Override
    public void unregisterDevice(String deviceId) {
        try {
            Stream<IPushSettings> stream = this.repository.getNodeSettings(this.getName(), this.getDescription());
            stream.forEach(iPushSettings -> {
                try {
                    IPushSettings iPushSettings2 = this.repository.unregisterDevice(iPushSettings.getServiceJid(), iPushSettings.getOwenerJid(), this.getName(), deviceId);
                    if (iPushSettings2 != null && iPushSettings2.getDevices().isEmpty()) {
                        this.affiliationChangedModule.notifyAffiliationChanged(iPushSettings2.getServiceJid(), iPushSettings2.getOwenerJid(), iPushSettings2.getNode(), Affiliation.none);
                    }
                }
                catch (ComponentException | RepositoryException throwable) {
                    a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, throwable);
                }
            });
        }
        catch (RepositoryException repositoryException) {
            a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, repositoryException);
        }
    }

    protected Map<String, Object> preparePayload(INotification notification) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("message_id", "m-" + UUID.randomUUID().toString());
        hashMap.put("priority", "high");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("account", notification.getAccount().toString());
        notification.ifMessageCount(l -> hashMap2.put("unread-messages", (String)l));
        notification.ifLastMessageSender(jID -> hashMap2.put("sender", jID.toString()));
        notification.ifLastMessageBody(string -> {
            if (string.length() > 512) {
                string = string.substring(0, 500) + "...";
            }
            hashMap2.put("body", (String)string);
        });
        hashMap.put("data", hashMap2);
        return hashMap;
    }

    private boolean a(String string, int n) {
        FcmConnection fcmConnection = null;
        try {
            fcmConnection = this.c.poll(5L, TimeUnit.SECONDS);
            if (fcmConnection != null) {
                fcmConnection.sendNotification(string);
                this.c.offer(fcmConnection);
            }
        }
        catch (JaxmppException jaxmppException) {
            a.log(Level.WARNING, "Failed to send push notification, retry " + n, jaxmppException);
        }
        catch (Throwable throwable) {
            if (fcmConnection != null) {
                this.c.offer(fcmConnection);
            }
            a.log(Level.WARNING, "Failed to send push notification, retry " + n, throwable);
        }
        return false;
    }
}

