/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsDelegateAdapter;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.PayloadBuilder;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.ApnsDeliveryErrorException;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.ScheduledTask;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.pubsub.Affiliation;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.INotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.push.modules.AffiliationChangedModule;

@Bean(name="apns-binary-api", parent=PushNotificationsComponent.class, active=false)
public class APNsBinaryApiProvider
implements UnregisterAware,
ConfigurationChangedAware,
IPushProvider {
    private static final Logger a = Logger.getLogger(APNsBinaryApiProvider.class.getCanonicalName());
    @Inject
    private AffiliationChangedModule affiliationChangedModule;
    private final a b = new a("main");
    private final a c = new a("sandbox");
    @ConfigField(desc="Password for certificate file", alias="cert-password")
    private String certificatePassword;
    @ConfigField(desc="Path to certificate file (.p12)", alias="cert-file")
    private String certificatePath;
    @ConfigField(desc="Provider description")
    private String description = "Push provider for APNs - Binary API";
    private Set<String> d = new ConcurrentSkipListSet<String>();
    @ConfigField(desc="Fallback to sandbox")
    private boolean fallbackToSandbox = false;
    @ConfigField(desc="Provider name")
    private String name = "apns-binary-api";
    @ConfigField(desc="Connections pool size", alias="pool-size")
    private int poolSize = Math.max(Runtime.getRuntime().availableProcessors() / 2, 1);
    @Inject
    private IPushRepository repository;
    @ConfigField(desc="Sandbox")
    private boolean sandbox = false;
    private ApnsService e;
    private ApnsService f;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void pushNotification(String deviceId, INotification notification) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "sending push notification to " + deviceId + " for account " + notification.getAccount());
        }
        PayloadBuilder payloadBuilder = this.preparePayload(APNS.newPayload(), notification);
        String string = payloadBuilder.build();
        ApnsNotification apnsNotification = this.e.push(deviceId, string);
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "pushed for push notification delivery = " + apnsNotification);
        }
    }

    public void beforeUnregister() {
        this.a(null);
        this.b(null);
    }

    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (changedFields.contains("certificatePath") || changedFields.contains("certificatePassword") || changedFields.contains("poolSize") || changedFields.contains("fallbackToSandbox")) {
            if (this.fallbackToSandbox) {
                this.b(APNS.newService().withCert(this.certificatePath, this.certificatePassword).withDelegate((ApnsDelegate)this.c).withAppleDestination(false).asPool(2).build());
                this.c.a((T apnsNotification, U throwable) -> {
                    String string = Utilities.encodeHex((byte[])apnsNotification.getDeviceToken());
                    this.d.remove(string);
                });
            } else {
                this.b(null);
            }
            this.a(APNS.newService().withCert(this.certificatePath, this.certificatePassword).withDelegate((ApnsDelegate)this.b).withAppleDestination(!this.sandbox).asPool(this.poolSize).build());
        }
    }

    protected void cleanupInactiveDevices() {
        Map map = this.e.getInactiveDevices();
        if (map != null) {
            map.keySet().forEach(this::unregisterDevice);
        }
        if (this.f != null && (map = this.f.getInactiveDevices()) != null) {
            map.keySet().forEach(this::unregisterDevice);
        }
    }

    protected PayloadBuilder preparePayload(PayloadBuilder builder, INotification notification) {
        builder.actionKey("Show").instantDeliveryOrSilentNotification().customField("account", (Object)notification.getAccount().toString());
        notification.ifMessageCount(l -> builder.customField("unread-messages", l));
        notification.ifLastMessageSender(jID -> builder.customField("sender", (Object)jID.toString()));
        notification.ifLastMessageBody(string -> {
            if (string.length() > 512) {
                string = string.substring(0, 500) + "...";
            }
            builder.customField("body", string);
        });
        return builder;
    }

    protected void unregisterDevice(String deviceId) {
        try {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "unregistering device " + deviceId + " as it was reported as inactive by APNs");
            }
            Stream<IPushSettings> stream = this.repository.getNodeSettings(this.getName(), this.getDescription());
            stream.forEach(iPushSettings -> {
                try {
                    IPushSettings iPushSettings2 = this.repository.unregisterDevice(iPushSettings.getServiceJid(), iPushSettings.getOwenerJid(), this.getName(), deviceId);
                    if (iPushSettings2 != null && iPushSettings2.getDevices().isEmpty()) {
                        this.affiliationChangedModule.notifyAffiliationChanged(iPushSettings2.getServiceJid(), iPushSettings2.getOwenerJid(), iPushSettings2.getNode(), Affiliation.none);
                    }
                }
                catch (ComponentException | RepositoryException throwable) {
                    a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, throwable);
                }
            });
        }
        catch (RepositoryException repositoryException) {
            a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, repositoryException);
        }
    }

    private void a(ApnsService apnsService) {
        ApnsService apnsService2 = this.e;
        this.e = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    private void b(ApnsService apnsService) {
        ApnsService apnsService2 = this.f;
        this.f = apnsService;
        if (apnsService != null) {
            this.b.a((T apnsNotification, U throwable) -> {
                if (throwable instanceof ApnsDeliveryErrorException) {
                    ApnsDeliveryErrorException apnsDeliveryErrorException = (ApnsDeliveryErrorException)throwable;
                    switch (apnsDeliveryErrorException.getDeliveryError()) {
                        case INVALID_TOKEN: {
                            try {
                                String string = Utilities.encodeHex((byte[])apnsNotification.getDeviceToken());
                                if (APNsBinaryApiProvider.a.isLoggable(Level.FINEST)) {
                                    APNsBinaryApiProvider.a.log(Level.FINEST, "trying to send push notification " + apnsNotification + " using sandbox service");
                                }
                                this.d.add(string);
                                apnsService.push(apnsNotification);
                            }
                            catch (Exception exception) {
                                APNsBinaryApiProvider.a.log(Level.FINEST, "failed to deliver push notification using sandbox service = " + apnsNotification, exception);
                            }
                            break;
                        }
                    }
                }
            });
        } else {
            this.b.a(null);
            this.d.clear();
        }
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    private class a
    extends ApnsDelegateAdapter {
        private final String b;
        private volatile Optional<BiConsumer<ApnsNotification, Throwable>> c;

        a(String string) {
            this.b = string;
        }

        private void a(BiConsumer<ApnsNotification, Throwable> biConsumer) {
            this.c = Optional.ofNullable(biConsumer);
        }

        public void messageSendFailed(ApnsNotification message, Throwable e) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "failed to deliver push notification = " + message + " using " + this.b + " service", e);
            }
            this.c.ifPresent(biConsumer -> biConsumer.accept(message, e));
            super.messageSendFailed(message, e);
        }

        public void messageSent(ApnsNotification message, boolean resent) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "push notification successfully sent to " + this.b + " APNs = " + message);
            }
            super.messageSent(message, resent);
        }
    }

    @Bean(name="inactive-device-cleanup-task", parent=APNsBinaryApiProvider.class, active=true)
    public static class InactiveDeviceCleanup
    extends ScheduledTask {
        @Inject
        private APNsBinaryApiProvider provider;

        public InactiveDeviceCleanup() {
            super(Duration.ofMinutes(10L), Duration.ofMinutes(15L));
        }

        public void run() {
            this.provider.cleanupInactiveDevices();
        }
    }
}

