/*
 * Decompiled with CFR 0.152.
 */
package tigase.push;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.db.NonAuthUserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.push.PushNotifications;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.server.xmppsession.SessionManager;
import tigase.server.xmppsession.UserPresenceChangedEvent;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:push:0:ext", parent=SessionManager.class, active=false, exportable=true)
@Id(value="urn:xmpp:push:0:ext")
@DiscoFeatures(value={"urn:xmpp:push:0", "tigase:push:away:0"})
@Handles(value={@Handle(path={"message"}, xmlns="jabber:client"), @Handle(path={"iq", "enable"}, xmlns="urn:xmpp:push:0"), @Handle(path={"iq", "disable"}, xmlns="urn:xmpp:push:0")})
public class PushNotificationsExt
extends PushNotifications
implements Initializable,
UnregisterAware {
    private static final Logger a = Logger.getLogger(PushNotificationsExt.class.getCanonicalName());
    private static final String b = "urn:xmpp:push:0#presence-prev";
    @Inject(nullAllowed=true)
    private ClusteringStrategyIfc clusteringStrategy;
    @Inject
    private EventBus eventBus;
    @Inject
    private SessionManager sessionManager;

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository nonAuthUserRepository, Queue<Packet> results, Map<String, Object> map) throws XMPPException {
        if (packet.getElemName() == "message") {
            this.a(packet, session, results);
        } else {
            super.process(packet, session, nonAuthUserRepository, results, map);
        }
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
    }

    @HandleEvent(filter=HandleEvent.Type.local)
    public void presenceChanged(UserPresenceChangedEvent event) {
        Object object;
        if (event.getPresence().getType() == StanzaType.unavailable) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = event.getSession().getResourceForJID(event.getPresence().getStanzaFrom());
        if (xMPPResourceConnection == null) {
            return;
        }
        Packet packet = (Packet)xMPPResourceConnection.getSessionData(b);
        xMPPResourceConnection.putSessionData(b, (Object)event.getPresence());
        if (packet != null) {
            object = event.getPresence().getElemCDataStaticStr(Presence.PRESENCE_SHOW_PATH);
            if (object != null && !"chat".equals(object)) {
                return;
            }
            String string = event.getPresence().getElemCDataStaticStr(Presence.PRESENCE_SHOW_PATH);
            if (string == null || "chat".equals(string)) {
                return;
            }
        }
        object = this.getPushServicesForAwayNotifications(xMPPResourceConnection);
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Sending push notifications for JID: {0}, oldPresence: {1}, services: {2}", new Object[]{xMPPResourceConnection.getjid(), packet, object});
        }
        if (object.isEmpty()) {
            return;
        }
        try {
            this.notifyOfflineMessagesRetrieved(xMPPResourceConnection.getBareJID(), (Collection<Element>)object, arg_0 -> ((SessionManager)this.sessionManager).addOutPacket(arg_0));
        }
        catch (NotAuthorizedException notAuthorizedException) {
            a.log(Level.FINEST, "Connection {0} not yet authorized, ignoring..", xMPPResourceConnection);
        }
    }

    protected Collection<Element> getPushServicesForAwayNotifications(XMPPResourceConnection session) {
        Map<String, Element> map = this.getPushServices(session);
        if (map.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return map.values().stream().filter(element -> element.getAttribute("away") != null).collect(Collectors.toList());
    }

    @Override
    protected Element createSettingsElement(JID jid, String node, Element enableElem, Element optionsForm) {
        Element element = super.createSettingsElement(jid, node, enableElem, optionsForm);
        String string = enableElem.getAttributeStaticStr("away");
        if ("true".equals(string)) {
            element.addAttribute("away", "true");
        }
        return element;
    }

    private void a(Packet packet, XMPPResourceConnection xMPPResourceConnection2, Queue<Packet> queue) throws NotAuthorizedException {
        Set set;
        if (xMPPResourceConnection2 == null || !xMPPResourceConnection2.isAuthorized()) {
            return;
        }
        if (packet.getStanzaTo() == null || !xMPPResourceConnection2.isUserId(packet.getStanzaTo().getBareJID())) {
            return;
        }
        Element element2 = packet.getElement().findChild(Message.MESSAGE_BODY_PATH);
        if (element2 == null) {
            return;
        }
        Collection<Element> collection = this.getPushServicesForAwayNotifications(xMPPResourceConnection2);
        if (collection.isEmpty()) {
            return;
        }
        boolean bl = xMPPResourceConnection2.getActiveSessions().stream().filter(xMPPResourceConnection -> xMPPResourceConnection.getPriority() >= 0).map(xMPPResourceConnection -> xMPPResourceConnection.getPresence()).filter(element -> element != null).filter(element -> element.getCDataStaticStr(Presence.PRESENCE_SHOW_PATH) == null).findAny().isPresent();
        if (bl) {
            return;
        }
        if (this.clusteringStrategy != null) {
            set = this.clusteringStrategy.getConnectionRecords(packet.getStanzaTo().getBareJID());
            if (set != null) {
                if (set.stream().filter(connectionRecordIfc -> {
                    try {
                        Method method = connectionRecordIfc.getClass().getMethod("getLastPresence", new Class[0]);
                        Element element = (Element)method.invoke(connectionRecordIfc, new Object[0]);
                        if (element == null) {
                            return false;
                        }
                        return element.getCDataStaticStr(Presence.PRESENCE_SHOW_PATH) == null;
                    }
                    catch (Throwable throwable) {
                        return false;
                    }
                }).findAny().isPresent()) {
                    return;
                }
                Optional<JID> optional = Stream.concat(set.stream().map(connectionRecordIfc -> connectionRecordIfc.getNode()), Stream.of(this.sessionManager.getComponentId())).distinct().sorted().findFirst();
                if (optional.isPresent() && !optional.filter(jID -> !this.sessionManager.getComponentId().equals(jID)).isPresent()) {
                    return;
                }
            }
        } else if (xMPPResourceConnection2.getActiveSessions().stream().map(xMPPResourceConnection -> xMPPResourceConnection.getPresence()).filter(Objects::nonNull).filter(element -> element.getCDataStaticStr(Presence.PRESENCE_SHOW_PATH) == null).findAny().isPresent()) {
            return;
        }
        set = this.prepareNotificationPayload(packet, 0L);
        this.sendPushNotification(packet.getStanzaTo().getBareJID(), collection, (Element)set, queue::offer);
    }
}

