/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="retractItemModule", parent=PubSubComponent.class, active=true)
public class RetractItemModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_RETRACT = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"retract"));
    @Inject
    private EventBus eventBus;
    @Inject
    private PublishItemModule publishModule;

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retract-items"};
    }

    public Criteria getModuleCriteria() {
        return CRIT_RETRACT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Packet packet) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element pubSub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element retract = pubSub.getChild("retract");
        String nodeName = retract.getAttributeStaticStr("node");
        try {
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(packet.getElement(), Authorization.ITEM_NOT_FOUND);
            }
            if (nodeConfig.getNodeType() == NodeType.collection) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "retract-items"));
            }
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            UsersAffiliation affiliation = nodeAffiliations.getSubscriberAffiliation(packet.getStanzaFrom().getBareJID());
            if (!affiliation.getAffiliation().isDeleteItem()) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            LeafNodeConfig leafNodeConfig = (LeafNodeConfig)nodeConfig;
            if (!leafNodeConfig.isPersistItem()) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "persistent-items"));
            }
            ArrayList<String> itemsToDelete = new ArrayList<String>();
            if (retract.getChildren() != null) {
                for (Element item : retract.getChildren()) {
                    String n = item.getAttributeStaticStr("id");
                    if (n != null) {
                        itemsToDelete.add(n);
                        continue;
                    }
                    throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.ITEM_REQUIRED);
                }
            } else {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.ITEM_REQUIRED);
            }
            Packet result = packet.okResult((Element)null, 0);
            IItems nodeItems = this.getRepository().getNodeItems(toJid, nodeName);
            ArrayList<Element> itemsToSend = new ArrayList<Element>(itemsToDelete.size());
            try {
                for (String id : itemsToDelete) {
                    Date date = nodeItems.getItemCreationDate(id);
                    if (date == null) continue;
                    nodeItems.deleteItem(id);
                    Element notification = new Element("retract", new String[]{"id"}, new String[]{id});
                    this.eventBus.fire((Object)new ItemRetractedEvent(packet.getStanzaTo().getBareJID(), nodeName, notification));
                    itemsToSend.add(notification);
                }
            }
            finally {
                this.publishModule.sendNotifications(packet.getStanzaTo().getBareJID(), nodeName, itemsToSend);
            }
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing retract item packet", e);
            throw new RuntimeException(e);
        }
    }

    public static class ItemRetractedEvent {
        public final String node;
        public final Element notification;
        public final BareJID serviceJid;

        public ItemRetractedEvent(BareJID serviceJid, String node, Element notification) {
            this.serviceJid = serviceJid;
            this.node = node;
            this.notification = notification;
        }
    }
}

