/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.CapsModule;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.impl.PresenceCapabilitiesManager;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="presenceCollectorModule", parent=PubSubComponent.class, active=true)
public class PresenceCollectorModule
extends AbstractPubSubModule {
    private static final ConcurrentMap<String, String[]> CAPS_MAP = new ConcurrentHashMap<String, String[]>();
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    private static final String[] EMPTY_CAPS = new String[0];
    private final ConcurrentMap<BareJID, ConcurrentMap<BareJID, Map<String, String[]>>> presenceByService = new ConcurrentHashMap<BareJID, ConcurrentMap<BareJID, Map<String, String[]>>>();
    @Inject
    private CapsModule capsModule;
    @Inject
    private EventBus eventBus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addJid(BareJID serviceJid, JID jid, String[] caps) {
        ConcurrentHashMap tmp;
        if (jid == null) {
            return false;
        }
        if (caps == null || caps.length == 0) {
            caps = EMPTY_CAPS;
        } else {
            StringBuilder sb = new StringBuilder();
            for (String item : caps) {
                sb.append(item);
            }
            String key = sb.toString();
            String[] cachedCaps = CAPS_MAP.putIfAbsent(key, caps);
            if (cachedCaps != null) {
                caps = cachedCaps;
            }
        }
        boolean added = false;
        BareJID bareJid = jid.getBareJID();
        String resource = jid.getResource();
        ConcurrentHashMap presenceByUser = (ConcurrentHashMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null && (presenceByUser = (ConcurrentMap)this.presenceByService.putIfAbsent(serviceJid, tmp = new ConcurrentHashMap())) == null) {
            presenceByUser = tmp;
        }
        if (resource != null) {
            Object[] oldCaps;
            HashMap<String, String[]> tmp2;
            HashMap<String, String[]> resources = (HashMap<String, String[]>)presenceByUser.get(bareJid);
            if (resources == null && (resources = (Map)presenceByUser.putIfAbsent(bareJid, tmp2 = new HashMap<String, String[]>())) == null) {
                resources = tmp2;
            }
            String[] availableCaps = caps;
            HashMap<String, String[]> hashMap = resources;
            synchronized (hashMap) {
                oldCaps = resources.put(resource, caps);
                added = oldCaps == null;
            }
            log.finest("for service " + serviceJid + " - Contact " + jid + " is collected.");
            if (this.config.isPepPeristent() && this.config.isSendLastPublishedItemOnPresence() && (serviceJid.getLocalpart() != null || this.config.isSubscribeByPresenceFilteredNotifications()) && oldCaps != caps && caps != null) {
                String[] features;
                HashSet<String> newFeatures = new HashSet<String>();
                for (String string : caps) {
                    if (oldCaps != null && Arrays.binarySearch(oldCaps, string) >= 0 || (features = PresenceCapabilitiesManager.getNodeFeatures((String)string)) == null) continue;
                    for (String feature : features) {
                        newFeatures.add(feature);
                    }
                }
                if (oldCaps != null) {
                    for (String string : oldCaps) {
                        if (Arrays.binarySearch(caps, string) >= 0 || (features = PresenceCapabilitiesManager.getNodeFeatures((String)string)) == null) continue;
                        for (String feature : features) {
                            newFeatures.remove(feature);
                        }
                    }
                }
                if (!newFeatures.isEmpty()) {
                    this.fireCapsChangeEvent(serviceJid, jid, caps, (String[])oldCaps, newFeatures);
                }
            }
        }
        return added;
    }

    public List<JID> getAllAvailableJids(BareJID serviceJid) {
        ArrayList<JID> result = new ArrayList<JID>();
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser != null) {
            for (Map.Entry entry : presenceByUser.entrySet()) {
                for (String reource : ((Map)entry.getValue()).keySet()) {
                    JID jid = JID.jidInstanceNS((BareJID)((BareJID)entry.getKey()), (String)reource);
                    if (!this.isAvailableLocally(jid)) continue;
                    result.add(jid);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JID> getAllAvailableJidsWithFeature(BareJID serviceJid, String feature) {
        ArrayList<JID> result = new ArrayList<JID>();
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null) {
            return result;
        }
        Set nodesWithFeature = PresenceCapabilitiesManager.getNodesWithFeature((String)feature);
        for (Map.Entry pe : presenceByUser.entrySet()) {
            Map jid_resources = (Map)pe.getValue();
            if (jid_resources == null) continue;
            Map map = jid_resources;
            synchronized (map) {
                for (Map.Entry e : jid_resources.entrySet()) {
                    JID jid;
                    String[] caps = (String[])e.getValue();
                    boolean match = false;
                    for (String node : caps) {
                        match |= nodesWithFeature.contains(node);
                    }
                    if (!match || !this.isAvailableLocally(jid = JID.jidInstanceNS((BareJID)((BareJID)pe.getKey()), (String)((String)e.getKey())))) continue;
                    result.add(jid);
                }
            }
        }
        return result;
    }

    public List<JID> getAllAvailableResources(BareJID serviceJid, BareJID bareJid) {
        ArrayList<JID> result = new ArrayList<JID>();
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null) {
            return result;
        }
        Map jid_resources = (Map)presenceByUser.get(bareJid);
        if (jid_resources != null) {
            for (String reource : jid_resources.keySet()) {
                JID jid = JID.jidInstanceNS((BareJID)bareJid, (String)reource);
                if (!this.isAvailableLocally(jid)) continue;
                result.add(jid);
            }
        }
        return result;
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#presence-notifications"};
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isJidAvailable(BareJID serviceJid, BareJID bareJid) {
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null) {
            return false;
        }
        Map resources = (Map)presenceByUser.get(bareJid);
        return resources != null && resources.size() > 0;
    }

    public void process(Packet packet) throws PubSubException {
        StanzaType type = packet.getType();
        JID jid = packet.getStanzaFrom();
        JID toJid = packet.getStanzaTo();
        if (jid == null || toJid == null) {
            return;
        }
        if (type == null || type == StanzaType.available) {
            String[] caps = this.config.isPepPeristent() ? this.capsModule.processPresence(packet) : null;
            boolean added = this.addJid(toJid.getBareJID(), jid, caps);
            this.firePresenceChangeEvent(packet);
            if (added && packet.getStanzaTo().getLocalpart() == null) {
                Presence p = new Presence(new Element("presence", new String[]{"to", "from", "xmlns"}, new String[]{jid.toString(), toJid.toString(), "jabber:client"}), toJid, jid);
                this.packetWriter.write((Packet)p);
            }
        } else if (StanzaType.unavailable == type) {
            this.removeJid(toJid.getBareJID(), jid);
            this.firePresenceChangeEvent(packet);
            if (packet.getStanzaTo().getLocalpart() == null) {
                Presence p = new Presence(new Element("presence", new String[]{"to", "from", "type", "xmlns"}, new String[]{jid.toString(), toJid.toString(), StanzaType.unavailable.toString(), "jabber:client"}), toJid, jid);
                this.packetWriter.write((Packet)p);
            }
        } else if (StanzaType.subscribe == type) {
            log.finest("Contact " + jid + " wants to subscribe PubSub");
            Packet presence = this.preparePresence(packet, StanzaType.subscribed);
            if (presence != null) {
                this.packetWriter.write(presence);
            }
            if ((presence = this.preparePresence(packet, StanzaType.subscribe)) != null) {
                this.packetWriter.write(presence);
            }
        } else if (StanzaType.unsubscribe == type || StanzaType.unsubscribed == type) {
            log.finest("Contact " + jid + " wants to unsubscribe PubSub");
            Packet presence = this.preparePresence(packet, StanzaType.unsubscribed);
            if (presence != null) {
                this.packetWriter.write(presence);
            }
            if ((presence = this.preparePresence(packet, StanzaType.unsubscribe)) != null) {
                this.packetWriter.write(presence);
            }
        }
    }

    protected boolean isAvailableLocally(JID jid) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeJid(BareJID serviceJid, JID jid) {
        if (jid == null) {
            return false;
        }
        BareJID bareJid = jid.getBareJID();
        String resource = jid.getResource();
        boolean removed = false;
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null) {
            return false;
        }
        if (resource == null) {
            presenceByUser.remove(bareJid);
            this.fireBuddyVisibilityEvent(bareJid, false);
        } else {
            Map resources = (Map)presenceByUser.get(bareJid);
            if (resources != null) {
                Map map = resources;
                synchronized (map) {
                    removed = resources.remove(resource) != null;
                    log.finest("for service " + serviceJid + " - Contact " + jid + " is removed from collection.");
                    if (resources.isEmpty()) {
                        presenceByUser.remove(bareJid);
                        this.fireBuddyVisibilityEvent(bareJid, false);
                    }
                }
            }
        }
        return removed;
    }

    private void fireBuddyVisibilityEvent(BareJID bareJid, boolean b) {
        this.eventBus.fire((Object)new BuddyVisibilityEvent(bareJid, b));
    }

    private void fireCapsChangeEvent(BareJID serviceJid, JID jid, String[] caps, String[] oldCaps, Set<String> newFeatures) {
        this.eventBus.fire((Object)new CapsChangeEvent(serviceJid, jid, caps, oldCaps, newFeatures));
    }

    private void firePresenceChangeEvent(Packet packet) {
        this.eventBus.fire((Object)new PresenceChangeEvent(packet));
    }

    private Packet preparePresence(Packet presence, StanzaType type) {
        JID to = presence.getTo();
        JID from = presence.getStanzaFrom();
        if (from != null && to != null && !from.getBareJID().equals((Object)to.getBareJID())) {
            JID jid = from.copyWithoutResource();
            Element p = new Element("presence", new String[]{"to", "from", "xmlns"}, new String[]{jid.toString(), to.toString(), "jabber:client"});
            if (type != null) {
                p.setAttribute("type", type.toString());
            }
            return new Presence(p, to, from);
        }
        return null;
    }

    public static class PresenceChangeEvent {
        public final Packet packet;

        public PresenceChangeEvent(Packet packet) {
            this.packet = packet;
        }
    }

    public static class CapsChangeEvent {
        public final JID buddyJid;
        public final String[] newCaps;
        public final Set<String> newFeatures;
        public final String[] oldCaps;
        public final BareJID serviceJid;

        public CapsChangeEvent(BareJID serviceJid, JID buddyJid, String[] newCaps, String[] oldCaps, Set<String> newFeatures) {
            this.serviceJid = serviceJid;
            this.buddyJid = buddyJid;
            this.newCaps = newCaps;
            this.oldCaps = oldCaps;
            this.newFeatures = newFeatures;
        }
    }

    public static class BuddyVisibilityEvent {
        public final boolean becomeOnline;
        public final BareJID buddyJID;

        public BuddyVisibilityEvent(BareJID buddyJID, boolean becomeOnline) {
            this.buddyJID = buddyJID;
            this.becomeOnline = becomeOnline;
        }
    }
}

