/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="disco", parent=PubSubComponent.class, active=true)
public class DiscoveryModule
extends tigase.component.modules.impl.DiscoveryModule {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    @Inject
    private IPubSubRepository repository;

    public DiscoveryModule() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDiscoInfo(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        if (node == null) {
            super.processDiscoInfo(packet, jid, node, senderJID);
        } else {
            boolean allowed;
            AbstractNodeConfig nodeConfigClone;
            JID senderJid = packet.getStanzaFrom();
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Packet resultIq = packet.okResult(resultQuery, 0);
            INodeMeta nodeMeta = this.repository.getNodeMeta(packet.getStanzaTo().getBareJID(), node);
            if (nodeMeta == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            try {
                nodeConfigClone = nodeMeta.getNodeConfig().clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RepositoryException("Exception retrieving node configuration", (Throwable)ex);
            }
            boolean bl = allowed = senderJid == null || nodeConfigClone == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfigClone.getDomains());
            if (!allowed) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", nodeConfigClone.getNodeType().name()}));
            resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}));
            Form form = nodeConfigClone.getForm();
            form.addField(Field.fieldHidden((String)"FORM_TYPE", (String)"http://jabber.org/protocol/pubsub#meta-data"));
            ArrayList<String> owners = new ArrayList<String>();
            ArrayList<String> publishers = new ArrayList<String>();
            IAffiliations affiliations = this.repository.getNodeAffiliations(packet.getStanzaTo().getBareJID(), node);
            block9: for (UsersAffiliation affiliation : affiliations.getAffiliations()) {
                if (affiliation.getAffiliation() == null) continue;
                switch (affiliation.getAffiliation()) {
                    case owner: {
                        owners.add(affiliation.getJid().toString());
                        continue block9;
                    }
                    case publisher: {
                        publishers.add(affiliation.getJid().toString());
                        continue block9;
                    }
                }
            }
            form.addField(Field.fieldJidMulti((String)"pubsub#owner", (String[])owners.toArray(new String[owners.size()]), (String)"Node owners"));
            form.addField(Field.fieldJidMulti((String)"pubsub#publisher", (String[])publishers.toArray(new String[publishers.size()]), (String)"Publishers to this node"));
            BareJID creator = nodeMeta.getCreator();
            String creationDateStr = "";
            if (nodeMeta.getCreationTime() != null) {
                SimpleDateFormat simpleDateFormat = this.formatter;
                synchronized (simpleDateFormat) {
                    creationDateStr = this.formatter.format(nodeMeta.getCreationTime());
                }
            }
            form.addField(Field.fieldJidSingle((String)"pubsub#creator", (String)(creator != null ? creator.toString() : ""), (String)"Node creator"));
            form.addField(Field.fieldTextSingle((String)"pubsub#creation_date", (String)creationDateStr, (String)"Creation date"));
            resultQuery.addChild((XMLNodeIfc)form.getElement());
            this.write(resultIq);
        }
    }

    protected void processDiscoItems(Packet packet, JID jid, String nodeName, JID senderJID) throws ComponentException, RepositoryException {
        AbstractNodeConfig nodeConfig;
        this.log.finest("Asking about Items of node " + nodeName);
        JID senderJid = packet.getStanzaFrom();
        JID toJid = packet.getStanzaTo();
        Element element = packet.getElement();
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
        Packet resultIq = packet.okResult(resultQuery, 0);
        AbstractNodeConfig abstractNodeConfig = nodeConfig = nodeName == null ? null : this.repository.getNodeConfig(toJid.getBareJID(), nodeName);
        if (nodeName != null && nodeConfig == null) {
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        if (nodeName == null || nodeConfig != null && nodeConfig.getNodeType() == NodeType.collection) {
            String[] nodes;
            String parentName;
            if (nodeName == null) {
                parentName = "";
                try {
                    nodes = this.repository.getRootCollection(toJid.getBareJID());
                }
                catch (CachedPubSubRepository.RootCollectionSet.IllegalStateException e) {
                    throw new PubSubException(Authorization.RESOURCE_CONSTRAINT);
                }
            } else {
                parentName = nodeName;
                nodes = this.repository.getChildNodes(toJid.getBareJID(), nodeName);
            }
            if (nodes != null) {
                for (String node : nodes) {
                    AbstractNodeConfig childNodeConfig = this.repository.getNodeConfig(toJid.getBareJID(), node);
                    if (childNodeConfig == null) continue;
                    boolean allowed = senderJid == null || childNodeConfig == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), childNodeConfig.getDomains());
                    String collection = childNodeConfig.getCollection();
                    if (allowed) {
                        String name = childNodeConfig.getTitle();
                        name = name == null || name.length() == 0 ? node : name;
                        Element item = new Element("item", new String[]{"jid", "node", "name"}, new String[]{element.getAttributeStaticStr("to"), node, name});
                        if (!parentName.equals(collection)) continue;
                        resultQuery.addChild((XMLNodeIfc)item);
                        continue;
                    }
                    this.log.fine("User " + senderJid + " not allowed to see node '" + node + "'");
                }
            }
        } else {
            boolean allowed;
            boolean bl = allowed = senderJid == null || nodeConfig == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfig.getDomains());
            if (!allowed) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            resultQuery.addAttribute("node", nodeName);
            IItems items = this.repository.getNodeItems(toJid.getBareJID(), nodeName);
            String[] itemsId = items.getItemsIds();
            if (itemsId != null) {
                for (String itemId : itemsId) {
                    resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{element.getAttributeStaticStr("to"), itemId}));
                }
            }
        }
        this.write(resultIq);
    }
}

