/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.cluster;

import java.util.List;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.core.Kernel;
import tigase.server.ComponentInfo;
import tigase.server.Packet;
import tigase.workgroupqueues.WorkgroupQueuesComponent;
import tigase.workgroupqueues.cluster.StrategyIfc;
import tigase.xmpp.jid.JID;

@Bean(name="wg", parent=Kernel.class, active=false)
@ClusterModeRequired(active=true)
public class WorkgroupQueuesClusteredComponent
extends WorkgroupQueuesComponent
implements ClusteredComponentIfc {
    private static final Logger a = Logger.getLogger(WorkgroupQueuesClusteredComponent.class.getCanonicalName());
    private ClusterControllerIfc b;
    private ComponentInfo c = null;
    @Inject
    private List<CommandListener> commandListeners;
    @Inject
    private StrategyIfc strategy;

    public WorkgroupQueuesClusteredComponent() {
        super("acs");
    }

    public ComponentInfo getComponentInfo() {
        this.c = super.getComponentInfo();
        this.c.getComponentData().put("WGClusteringStrategy", this.strategy != null ? this.strategy.getClass() : null);
        return this.c;
    }

    protected void onNodeConnected(JID jid) {
        super.onNodeConnected(jid);
        this.strategy.nodeConnected(jid);
    }

    public void onNodeDisconnected(JID jid) {
        super.onNodeDisconnected(jid);
        this.strategy.nodeDisconnected(jid);
    }

    public void processPacket(Packet packet) {
        boolean bl = this.strategy.processPacket(packet);
        if (!bl) {
            super.processPacket(packet);
        }
    }

    public void setClusterController(ClusterControllerIfc cl_controller) {
        super.setClusterController(cl_controller);
        if (this.b != null && this.commandListeners != null) {
            for (CommandListener commandListener : this.commandListeners) {
                this.b.removeCommandListener(commandListener);
            }
        }
        this.b = cl_controller;
        if (this.b != null && this.commandListeners != null) {
            for (CommandListener commandListener : this.commandListeners) {
                this.b.setCommandListener(commandListener);
            }
        }
        if (this.strategy != null) {
            this.strategy.setClusterController(cl_controller);
        }
        this.kernel.registerBean("clusterController").asInstance((Object)cl_controller).exec();
    }

    public void setCommandListeners(List<CommandListener> commandListeners) {
        if (this.b != null && this.commandListeners != null) {
            for (CommandListener commandListener : commandListeners) {
                this.b.removeCommandListener(commandListener);
            }
        }
        this.commandListeners = commandListeners;
        if (this.b != null && commandListeners != null) {
            for (CommandListener commandListener : commandListeners) {
                this.b.setCommandListener(commandListener);
            }
        }
    }

    public void setStrategy(StrategyIfc strategy) {
        if (this.strategy != null) {
            strategy.setClusterController(null);
        }
        this.strategy = strategy;
        if (this.strategy != null) {
            this.strategy.setClusterController(this.b);
        }
    }
}

