/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.converter;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.DataSourcePool;
import tigase.db.jdbc.DataRepositoryImpl;
import tigase.util.Version;
import tigase.xmpp.jid.BareJID;

public class DataRepoPool
implements DataRepository,
DataSourcePool<DataRepository> {
    private static final Logger log = Logger.getLogger(DataRepoPool.class.getName());
    private DataRepository.dbTypes database = null;
    private LinkedBlockingQueue<DataRepository> repoPool = new LinkedBlockingQueue();
    private String resource_uri = null;

    public void addRepo(DataRepository repo) {
        this.repoPool.offer(repo);
    }

    public DataRepository takeRepoHandle(BareJID user_id) {
        try {
            return this.repoPool.take();
        }
        catch (InterruptedException ex) {
            log.log(Level.WARNING, "Couldn't obtain DataRepository from the pool", ex);
            return null;
        }
    }

    public void releaseRepoHandle(DataRepository repo) {
        this.repoPool.offer(repo);
    }

    public boolean automaticSchemaManagement() {
        if (this.repoPool.isEmpty()) {
            return true;
        }
        return this.repoPool.peek().automaticSchemaManagement();
    }

    public void checkConnectivity(Duration watchdogTime) {
        this.repoPool.forEach(repo -> repo.checkConnectivity(watchdogTime));
    }

    public boolean checkSchemaVersion(DataSourceAware<? extends DataSource> datasource, boolean shutdownServer) {
        DataRepository repo = this.takeRepoHandle(null);
        if (repo != null) {
            return repo.checkSchemaVersion(datasource, shutdownServer);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return false;
    }

    public Optional<Version> getSchemaVersion(String component) {
        DataRepository repo = this.takeRepoHandle(null);
        if (repo != null) {
            return repo.getSchemaVersion(component);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return Optional.empty();
    }

    public boolean checkTable(String tableName) throws SQLException {
        DataRepository repo = this.takeRepoHandle(null);
        if (repo != null) {
            return repo.checkTable(tableName);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return false;
    }

    public boolean checkTable(String tableName, String createTableQuery) throws SQLException {
        DataRepository repo = this.takeRepoHandle(null);
        if (repo != null) {
            return repo.checkTable(tableName, createTableQuery);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return false;
    }

    public Statement createStatement(BareJID user_id) throws SQLException {
        DataRepository repo = this.takeRepoHandle(user_id);
        if (repo != null) {
            return repo.createStatement(user_id);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return null;
    }

    public PreparedStatement getPreparedStatement(BareJID user_id, String stIdKey) throws SQLException {
        DataRepository repo = this.takeRepoHandle(user_id);
        if (repo != null) {
            return repo.getPreparedStatement(user_id, stIdKey);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return null;
    }

    public PreparedStatement getPreparedStatement(int hashCode, String stIdKey) throws SQLException {
        DataRepository repo = this.takeRepoHandle(null);
        if (repo != null) {
            return repo.getPreparedStatement(hashCode, stIdKey);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return null;
    }

    public String getResourceUri() {
        if (this.resource_uri == null && !this.repoPool.isEmpty()) {
            return this.takeRepoHandle(null).getResourceUri();
        }
        return this.resource_uri;
    }

    public DataRepository.dbTypes getDatabaseType() {
        return this.database;
    }

    public void initPreparedStatement(String stIdKey, String query) throws SQLException {
        for (DataRepository dataRepository : this.repoPool) {
            dataRepository.initPreparedStatement(stIdKey, query);
        }
    }

    public void initPreparedStatement(String stIdKey, String query, int autoGeneratedKeys) throws SQLException {
        for (DataRepository dataRepository : this.repoPool) {
            dataRepository.initPreparedStatement(stIdKey, query, autoGeneratedKeys);
        }
    }

    public void initialize(String resource_uri) throws DBInitException {
        this.resource_uri = resource_uri;
        if (this.database == null) {
            this.database = DataRepositoryImpl.parseDatabaseType((String)resource_uri);
        }
    }

    public void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void startTransaction() throws SQLException {
    }

    public void commit() throws SQLException {
    }

    public void rollback() throws SQLException {
    }

    public void endTransaction() throws SQLException {
    }

    public int getPoolSize() {
        return this.repoPool.size();
    }
}

