/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.converter;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import tigase.component.DSLBeanConfigurator;
import tigase.component.DSLBeanConfiguratorWithBackwardCompatibility;
import tigase.conf.ConfiguratorAbstract;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.beans.selector.ServerBeanSelector;
import tigase.kernel.core.Kernel;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.XMPPServer;
import tigase.util.log.LogFormatter;

public class ConverterUtil {
    private static final Logger log = Logger.getLogger(ConverterUtil.class.getCanonicalName());

    static void initLogger() {
        String logsDirectory = "logs";
        if (!Files.exists(Paths.get("logs", new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(Paths.get("logs", new String[0]), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String initial_config = "tigase.level=FINE\ntigase.db.jdbc.level=INFO\ntigase.db.converter.level=FINEST\ntigase.xml.level=FINE\ntigase.auth.level=FINE\nhandlers=java.util.logging.ConsoleHandler java.util.logging.FileHandler\njava.util.logging.ConsoleHandler.level=INFO\njava.util.logging.ConsoleHandler.formatter=tigase.util.log.LogFormatter\njava.util.logging.FileHandler.level=ALL\njava.util.logging.FileHandler.formatter=tigase.util.log.LogFormatter\njava.util.logging.FileHandler.pattern=logs/tigase-database-converter.log\ntigase.useParentHandlers=true\n";
        ConfiguratorAbstract.loadLogManagerConfig((String)initial_config);
        Logger logger = Logger.getLogger("convertible");
        logger.setLevel(Level.ALL);
        logger.setUseParentHandlers(false);
        PlainLogFormatter logFormatter = new PlainLogFormatter();
        try {
            FileHandler fileHandler = null;
            fileHandler = new FileHandler("logs/tigase-database-converter_status.log");
            fileHandler.setLevel(Level.ALL);
            fileHandler.setFormatter((Formatter)((Object)logFormatter));
            logger.addHandler(fileHandler);
        }
        catch (IOException e) {
            System.out.println("problem with adding log file handler");
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.INFO);
        consoleHandler.setFormatter((Formatter)((Object)logFormatter));
        logger.addHandler(consoleHandler);
    }

    static Kernel prepareKernel(Map config) {
        Kernel kernel = new Kernel("root");
        try {
            if (XMPPServer.isOSGi()) {
                kernel.registerBean("classUtilBean").asInstance(Class.forName("tigase.osgi.util.ClassUtilBean").newInstance()).exportable().exec();
            } else {
                kernel.registerBean("classUtilBean").asInstance(Class.forName("tigase.util.reflection.ClassUtilBean").newInstance()).exportable().exec();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        kernel.registerBean(DefaultTypesConverter.class).exportable().exec();
        kernel.registerBean(DSLBeanConfiguratorWithBackwardCompatibility.class).exportable().exec();
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        DSLBeanConfigurator configurator = (DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class);
        configurator.setProperties(config);
        ModulesManagerImpl.getInstance().setBeanConfigurator((AbstractBeanConfigurator)configurator);
        kernel.registerBean("beanSelector").asInstance((Object)new ServerBeanSelector()).exportable().exec();
        configurator.registerBeans(null, null, config);
        return kernel;
    }

    private static void setupConvertibleLogger() {
    }

    private static class PlainLogFormatter
    extends LogFormatter {
        private PlainLogFormatter() {
        }

        public synchronized String format(LogRecord record) {
            StringBuilder sb = new StringBuilder(200);
            this.cal.setTimeInMillis(record.getMillis());
            sb.append('[');
            sb.append(String.format("%1$tF %1$tT.%1$tL", this.cal));
            sb.append(']');
            sb.append(' ');
            sb.append(this.formatMessage(record));
            if (record.getThrown() != null) {
                sb.append('\n').append(record.getThrown().toString());
                StringBuilder st_sb = new StringBuilder(1024);
                this.getStackTrace(st_sb, record.getThrown());
                sb.append(st_sb.toString());
                this.addError(record.getThrown(), st_sb.toString(), sb.toString());
            }
            return sb.toString() + "\n";
        }
    }
}

