/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import tigase.kernel.beans.Bean;
import tigase.muc.Affiliation;
import tigase.muc.PresenceStore;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.cluster.MUCComponentClustered;
import tigase.muc.cluster.Occupant;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class RoomClustered<ID>
extends RoomWithId<ID> {
    private final ConcurrentMap<JID, String> a = new ConcurrentHashMap<JID, String>();
    private final ConcurrentMap<String, Occupant> b = new ConcurrentHashMap<String, Occupant>();

    protected RoomClustered(ID id, RoomConfig rc, Date creationDate, BareJID creatorJid) {
        super(id, rc, creationDate, creatorJid);
    }

    public Collection<Occupant> getRemoteOccupants() {
        return this.b.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteOccupant(String nickname, JID occupantJID, Role role, Affiliation affiliation, Element presence) {
        Occupant occupant;
        Occupant occupant2;
        if (this.a.containsKey(occupantJID) && !nickname.equals(this.a.get(occupantJID))) {
            this.removeRemoteOccupant(occupantJID);
        }
        if ((occupant2 = (Occupant)this.b.get(nickname)) == null) {
            occupant2 = new Occupant(nickname, occupantJID, role, affiliation, presence);
            occupant = this.b.putIfAbsent(nickname, occupant2);
            if (occupant != null) {
                occupant2 = occupant;
            } else {
                this.a.put(occupantJID, nickname);
                return;
            }
        }
        occupant2.addOccupant(occupantJID, presence);
        occupant = occupant2;
        synchronized (occupant) {
            if (!this.b.containsKey(nickname)) {
                this.b.put(nickname, occupant2);
            }
        }
        occupant2.setRole(role);
        occupant2.setAffiliation(affiliation);
        this.a.put(occupantJID, nickname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteOccupant(JID occupantJID) {
        String string = (String)this.a.remove(occupantJID);
        if (string == null) {
            return;
        }
        Occupant occupant = (Occupant)this.b.get(string);
        if (occupant == null) {
            return;
        }
        occupant.removeOccupant(occupantJID);
        if (occupant.isEmpty()) {
            Occupant occupant2 = occupant;
            synchronized (occupant2) {
                if (occupant.isEmpty()) {
                    this.b.remove(string, occupant);
                }
            }
        }
    }

    public int getOccupantsCount() {
        return super.getOccupantsCount() + this.b.size();
    }

    public Collection<JID> getOccupantsJidsByNickname(String nickname) {
        Occupant occupant;
        Collection collection = super.getOccupantsJidsByNickname(nickname);
        if (collection.isEmpty() && (occupant = (Occupant)this.b.get(nickname)) != null) {
            return Collections.unmodifiableCollection(occupant.getOccupants());
        }
        return collection;
    }

    public boolean removeOccupant(JID jid) {
        String string = this.getOccupantsNickname(jid);
        Occupant occupant = string == null ? null : (Occupant)this.b.get(string);
        return super.removeOccupant(jid) && (occupant == null || occupant.isEmpty());
    }

    public Affiliation getAffiliation(String nickname) {
        Occupant occupant;
        Affiliation affiliation = super.getAffiliation(nickname);
        if (affiliation == Affiliation.none && (occupant = (Occupant)this.b.get(nickname)) != null) {
            affiliation = occupant.getAffiliation();
        }
        return affiliation;
    }

    public Role getRole(String nickname) {
        Occupant occupant;
        Role role = super.getRole(nickname);
        if (role == Role.none && nickname != null && (occupant = (Occupant)this.b.get(nickname)) != null) {
            role = occupant.getRole();
        }
        return role;
    }

    public Element getLastPresenceCopy(BareJID occupantJid, String nickname) {
        int n;
        PresenceStore.Presence presence = this.presences.getBestPresenceInt(occupantJid);
        Occupant occupant = (Occupant)this.b.get(nickname);
        Occupant.Presence presence2 = occupant != null ? occupant.getBestPresenceInt() : null;
        int n2 = presence == null ? -1 : presence.getPriority();
        int n3 = n = presence2 == null ? -1 : presence2.getPriority();
        Element element = presence == null && presence2 == null ? null : (n2 < n ? presence2.getElement() : presence.getElement());
        return element == null ? null : element.clone();
    }

    @Bean(name="roomFactory", parent=MUCComponentClustered.class, active=true, exportable=true)
    public static class RoomFactoryImpl
    implements Room.RoomFactory {
        public <T> RoomWithId<T> newInstance(T id, RoomConfig rc, Date creationDate, BareJID creatorJid) {
            return new RoomClustered<T>(id, rc, creationDate, creatorJid);
        }
    }
}

