/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam.filters;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.spam.SpamProcessor;
import tigase.spam.filters.AbstractSpamFilter;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

@Bean(name="muc-message-ensure-to-full-jid", parent=SpamProcessor.class, active=true)
public class MucMessageFilterEnsureToFullJid
extends AbstractSpamFilter {
    protected static final String ID = "muc-message-ensure-to-full-jid";
    private static final Logger log = Logger.getLogger(MucMessageFilterEnsureToFullJid.class.getCanonicalName());

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected boolean filterPacket(Packet packet, XMPPResourceConnection session) {
        block5: {
            if (packet.getElemName() != "message" || packet.getType() != StanzaType.groupchat) {
                return true;
            }
            try {
                if (session != null && session.isAuthorized()) {
                    if (session.isUserId(packet.getStanzaTo().getBareJID())) {
                        return packet.getStanzaTo().getResource() != null;
                    }
                    break block5;
                }
                return true;
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.FINEST, "Could not compare packet " + packet + " destination with session bare jid as session is not authorized yet", ex);
                return true;
            }
        }
        return true;
    }
}

