/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import tigase.http.AbstractHttpServer;
import tigase.http.DeploymentInfo;
import tigase.http.java.RequestHandler;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.net.SocketType;

@Bean(name="httpServer", parent=Kernel.class, active=true, exportable=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SetupMode})
public class JavaStandaloneHttpServer
extends AbstractHttpServer {
    private static final Logger log = Logger.getLogger(JavaStandaloneHttpServer.class.getCanonicalName());
    private final Set<HttpServer> servers = new HashSet<HttpServer>();
    private List<DeploymentInfo> deployments = new ArrayList<DeploymentInfo>();
    @Inject
    private ExecutorWithTimeout executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(DeploymentInfo deployment) {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            this.deployments.add(deployment);
            this.servers.forEach(server -> this.deploy((HttpServer)server, deployment));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(DeploymentInfo deployment) {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            this.servers.forEach(server -> this.undeploy((HttpServer)server, deployment));
            this.deployments.remove(deployment);
        }
    }

    @Override
    public List<DeploymentInfo> listDeployed() {
        return Collections.unmodifiableList(this.deployments);
    }

    protected HttpServer createServer(PortConfigBean config) throws IOException {
        if (config.getSocket() == SocketType.plain) {
            return HttpServer.create(new InetSocketAddress(config.getPort()), 100);
        }
        HttpsServer server = HttpsServer.create(new InetSocketAddress(config.getPort()), 100);
        SSLContext sslContext = this.sslContextContainer.getSSLContext("TLS", config.getDomain(), false);
        server.setHttpsConfigurator(new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters httpsParameters) {
                super.configure(httpsParameters);
                SSLParameters sslParameters = this.getSSLContext().getDefaultSSLParameters();
                sslParameters.setSNIMatchers(Collections.singleton(new SNIMatcher(0){

                    @Override
                    public boolean matches(SNIServerName sniServerName) {
                        return true;
                    }
                }));
                httpsParameters.setSSLParameters(sslParameters);
            }
        });
        return server;
    }

    protected void deploy(HttpServer server) {
        Collections.unmodifiableList(this.deployments).forEach(info -> this.deploy(server, (DeploymentInfo)info));
    }

    protected void deploy(HttpServer server, DeploymentInfo info) {
        server.createContext(info.getContextPath(), new RequestHandler(info, this.executor.timer));
    }

    protected void undeploy(HttpServer server) {
        Collections.unmodifiableList(this.deployments).forEach(info -> this.undeploy(server, (DeploymentInfo)info));
    }

    protected void undeploy(HttpServer server, DeploymentInfo info) {
        try {
            server.removeContext(info.getContextPath());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.log(Level.FINEST, "deployment context " + info.getContextPath() + " already removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServer(HttpServer server) {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            this.servers.add(server);
            int port = server.getAddress().getPort();
            if (server instanceof HttpsServer) {
                this.httpsPorts.add(port);
            } else {
                this.httpPorts.add(port);
            }
            this.deploy(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServer(HttpServer server) {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            this.undeploy(server);
            int port = server.getAddress().getPort();
            if (server instanceof HttpsServer) {
                this.httpsPorts.remove((Object)port);
            } else {
                this.httpPorts.remove((Object)port);
            }
            server.getAddress().getPort();
            this.servers.remove(server);
        }
    }

    @Bean(name="executor", parent=JavaStandaloneHttpServer.class, active=true, exportable=true)
    public static class ExecutorWithTimeout
    implements Executor,
    Initializable,
    UnregisterAware,
    ConfigurationChangedAware {
        private static final String THREADS_KEY = "threads";
        private static final String REQUEST_TIMEOUT_KEY = "request-timeout";
        private AtomicInteger counter = new AtomicInteger(0);
        private ExecutorService executor = null;
        @ConfigField(desc="Number of threads", alias="threads")
        private int threads = 4;
        @ConfigField(desc="Request timeout", alias="request-timeout")
        private int timeout = 60000;
        @ConfigField(desc="Accept timeout", alias="accept-timeout")
        private int acceptTimeout = 2000;
        private Timer timer;

        @Override
        public void execute(Runnable command) {
            this.executor.execute(() -> {
                RequestHandler.setRequestId();
                this.timer.connectionAccepted();
                command.run();
            });
        }

        public void beforeUnregister() {
            this.executor.shutdown();
            this.timer.shutdown();
        }

        public void initialize() {
            if (this.executor != null) {
                this.beforeUnregister();
            }
            this.executor = Executors.newFixedThreadPool(this.threads, r -> {
                Thread t = new Thread(r);
                t.setName("http-server-pool-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            });
            this.timer = new Timer(this::getAcceptTimeout, this::getTimeout);
        }

        public void beanConfigurationChanged(Collection<String> changedFields) {
            this.initialize();
        }

        public int getAcceptTimeout() {
            return this.acceptTimeout;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public static class Timer {
            private ThreadLocal<ScheduledFuture> threadTimeouts = new ThreadLocal();
            private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            private final Supplier<Integer> acceptTimeoutSupplier;
            public final Supplier<Integer> requestTimeoutSupplier;

            private Timer(Supplier<Integer> acceptTimeoutSupplier, Supplier<Integer> requestTimeoutSupplier) {
                this.acceptTimeoutSupplier = acceptTimeoutSupplier;
                this.requestTimeoutSupplier = requestTimeoutSupplier;
            }

            private void shutdown() {
                this.executor.shutdown();
            }

            public void connectionAccepted() {
                Thread currentThread = Thread.currentThread();
                int reqId = RequestHandler.getRequestId();
                this.threadTimeouts.set(this.executor.schedule(() -> {
                    log.log(Level.WARNING, "request accept time exceeded! for id = " + reqId);
                    currentThread.interrupt();
                }, (long)this.acceptTimeoutSupplier.get().intValue(), TimeUnit.MILLISECONDS));
            }

            public void requestProcessingStarted() {
                ScheduledFuture timeout = this.threadTimeouts.get();
                if (timeout != null) {
                    timeout.cancel(false);
                }
                Thread currentThread = Thread.currentThread();
                int reqId = RequestHandler.getRequestId();
                this.threadTimeouts.set(this.executor.schedule(() -> {
                    log.log(Level.WARNING, "request processing time exceeded! for id = " + reqId);
                    currentThread.interrupt();
                }, (long)this.requestTimeoutSupplier.get().intValue(), TimeUnit.MILLISECONDS));
            }

            public void requestProcessingFinished() {
                ScheduledFuture timeout = this.threadTimeouts.get();
                if (timeout != null) {
                    timeout.cancel(false);
                }
            }

            public ScheduledExecutorService getScheduledExecutorService() {
                return this.executor;
            }
        }
    }

    public static class PortConfigBean
    extends AbstractHttpServer.PortConfigBean {
        protected HttpServer httpServer;
        @Inject(bean="executor")
        private ExecutorWithTimeout executor;
        @Inject
        private JavaStandaloneHttpServer serverManager;

        public void beanConfigurationChanged(Collection<String> changedFields) {
            if (this.serverManager == null) {
                return;
            }
            this.beforeUnregister();
            this.initialize();
        }

        public void beforeUnregister() {
            if (this.httpServer != null) {
                this.serverManager.unregisterServer(this.httpServer);
                this.httpServer.stop(1);
                this.httpServer = null;
            }
        }

        public void initialize() {
            if (this.httpServer == null) {
                try {
                    this.httpServer = this.serverManager.createServer(this);
                    this.httpServer.setExecutor(this.executor);
                    this.httpServer.start();
                    this.serverManager.registerServer(this.httpServer);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Could not initialize HTTP server for port " + this.getPort());
                }
            }
        }
    }

    @Bean(name="connections", parent=JavaStandaloneHttpServer.class, active=true, exportable=true)
    public static class PortsConfigBean
    extends AbstractHttpServer.PortsConfigBean {
        public Class<?> getDefaultBeanClass() {
            return PortConfigBean.class;
        }
    }
}

