/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Collection;
import tigase.component.modules.Module;
import tigase.muc.Affiliation;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public interface PresenceModule
extends Module {
    public static final String ID = "presences";

    public void doQuit(Room var1, JID var2) throws TigaseStringprepException;

    public void sendPresencesToNewOccupant(Room var1, JID var2) throws TigaseStringprepException;

    public static class PresenceWrapper {
        final Element[] items;
        final Packet packet;
        final Element x;

        public static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, BareJID occupantBareJID, Collection<JID> occupantJIDs, String occupantNickname, Affiliation occupantAffiliation, Role occupantRole) throws TigaseStringprepException {
            RoomConfig.Anonymity anonymity = room.getConfig().getRoomAnonymity();
            Affiliation destinationAffiliation = room.getAffiliation(destinationJID.getBareJID());
            try {
                presence.setAttribute("from", JID.jidInstance((BareJID)room.getRoomJID(), (String)occupantNickname).toString());
            }
            catch (TigaseStringprepException e) {
                presence.setAttribute("from", room.getRoomJID() + "/" + occupantNickname);
            }
            presence.setAttribute("to", destinationJID.toString());
            Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
            ArrayList<Element> items = new ArrayList<Element>();
            if (anonymity == RoomConfig.Anonymity.nonanonymous || anonymity == RoomConfig.Anonymity.semianonymous && destinationAffiliation.isViewOccupantsJid()) {
                for (JID jid : occupantJIDs) {
                    Element item = new Element("item", new String[]{"affiliation", "role", "nick", "jid"}, new String[]{occupantAffiliation.name(), occupantRole.name(), occupantNickname, jid.toString()});
                    x.addChild((XMLNodeIfc)item);
                    items.add(item);
                }
            } else {
                Element item = new Element("item", new String[]{"affiliation", "role", "nick"}, new String[]{occupantAffiliation.name(), occupantRole.name(), occupantNickname});
                x.addChild((XMLNodeIfc)item);
                items.add(item);
            }
            presence.addChild((XMLNodeIfc)x);
            Packet packet = Packet.packetInstance((Element)presence);
            packet.setXMLNS("jabber:client");
            PresenceWrapper wrapper = new PresenceWrapper(packet, x, items.toArray(new Element[0]));
            if (occupantBareJID != null && occupantBareJID.equals((Object)destinationJID.getBareJID())) {
                wrapper.packet.setPriority(Priority.HIGH);
                wrapper.addStatusCode(110);
                if (anonymity == RoomConfig.Anonymity.nonanonymous) {
                    wrapper.addStatusCode(100);
                }
                if (room.getConfig().isLoggingEnabled()) {
                    wrapper.addStatusCode(170);
                }
            }
            return wrapper;
        }

        static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, BareJID occupantJID, String occupantNickname, Affiliation occupantAffiliation, Role occupantRole) throws TigaseStringprepException {
            Collection<JID> occupantJIDs = room.getOccupantsJidsByNickname(occupantNickname);
            return PresenceWrapper.preparePresenceW(room, destinationJID, presence, occupantJID, occupantJIDs, occupantNickname, occupantAffiliation, occupantRole);
        }

        static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, JID occupantJID) throws TigaseStringprepException {
            String occupantNickname = room.getOccupantsNickname(occupantJID);
            return PresenceWrapper.preparePresenceW(room, destinationJID, presence, occupantNickname);
        }

        static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, String occupantNickname) throws TigaseStringprepException {
            BareJID occupantJID = room.getOccupantsJidByNickname(occupantNickname);
            Affiliation occupantAffiliation = room.getAffiliation(occupantJID);
            Role occupantRole = room.getRole(occupantNickname);
            return PresenceWrapper.preparePresenceW(room, destinationJID, presence, occupantJID, occupantNickname, occupantAffiliation, occupantRole);
        }

        PresenceWrapper(Packet packet, Element x, Element[] items) {
            this.packet = packet;
            this.x = x;
            this.items = items;
        }

        void addStatusCode(int code) {
            this.x.addChild((XMLNodeIfc)new Element("status", new String[]{"code"}, new String[]{"" + code}));
        }

        public Packet getPacket() {
            return this.packet;
        }

        public Element getX() {
            return this.x;
        }
    }
}

