/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.scheduler;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import tigase.workgroupqueues.scheduler.Agent;
import tigase.workgroupqueues.scheduler.Offer;
import tigase.workgroupqueues.scheduler.QueueStats;
import tigase.workgroupqueues.scheduler.User;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class Queue {
    private static int a = 5;
    private final ConcurrentHashMap<JID, Agent> b = new ConcurrentHashMap();
    private final BareJID c;
    private final String d;
    private final ConcurrentHashMap<String, Offer> e = new ConcurrentHashMap();
    private final QueueStats f = new QueueStats();
    private final ConcurrentHashMap<JID, User> g = new ConcurrentHashMap();
    private Status h = Status.open;

    public Queue(BareJID jid, String mucDomain) {
        this.c = jid;
        this.d = mucDomain;
    }

    public void addAgent(Agent agent) {
        this.b.put(agent.getJid(), agent);
    }

    public void addOffer(Offer offer) {
        String string = offer.getKey();
        this.e.put(string, offer);
    }

    public void addUser(User user) {
        this.g.put(user.getJid(), user);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Queue queue = (Queue)o;
        return this.c.equals((Object)queue.c);
    }

    public Agent getAgent(JID jid) {
        return this.b.get(jid);
    }

    public Collection<Agent> getAgents() {
        return Collections.unmodifiableCollection(this.b.values());
    }

    public int getAvailableAgents() {
        return this.b.size();
    }

    public int getAverageWaitingTime() {
        double d = this.f.getAverageWaitTime();
        return (int)(d / 1000.0);
    }

    public int getCurrentChats() {
        int n = 0;
        for (Agent agent : this.b.values()) {
            n += agent.getBusySlots();
        }
        return n;
    }

    public BareJID getJid() {
        return this.c;
    }

    public int getMaxChats() {
        int n = 0;
        for (Agent agent : this.b.values()) {
            n += agent.getMaxChats() == null ? a : agent.getMaxChats();
        }
        return n;
    }

    public String getMucDomain() {
        return this.d;
    }

    public Collection<Offer> getOffers() {
        return this.e.values();
    }

    public Date getOldestTime() {
        Date date = null;
        for (User user : this.g.values()) {
            if (date != null && !date.after(user.getJoinTime())) continue;
            date = user.getJoinTime();
        }
        return date;
    }

    public QueueStats getStats() {
        return this.f;
    }

    public Status getStatus() {
        return this.h;
    }

    public void setStatus(Status status) {
        this.h = status;
    }

    public User getUser(JID jid) {
        return this.g.get(jid);
    }

    public Collection<User> getUsers() {
        return Collections.unmodifiableCollection(this.g.values());
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    public void removeAgent(Agent agent) {
        this.b.remove(agent.getJid());
    }

    public Offer removeOffer(Queue queue, JID userJID, Agent agent) {
        return this.e.remove(Offer.getKey(queue.getJid(), userJID, agent.getJid()));
    }

    public void removeUser(User user) {
        this.g.remove(user.getJid());
    }

    private Offer a(Queue queue, User user, Agent agent) {
        return this.e.get(Offer.getKey(queue, user, agent));
    }

    private Offer b(Queue queue, User user, Agent agent) {
        return this.e.remove(Offer.getKey(queue, user, agent));
    }

    public static enum Status {
        open,
        active,
        closed;

    }
}

