/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.socket;

import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.XmppModulesManager;
import tigase.jaxmpp.core.client.connector.AbstractSocketXmppSessionLogic;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceModule;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceStore;
import tigase.jaxmpp.j2se.connectors.socket.SocketConnector;

public class SocketXmppSessionLogic
extends AbstractSocketXmppSessionLogic<SocketConnector> {
    public SocketXmppSessionLogic(SocketConnector connector, XmppModulesManager modulesManager, Context context) {
        super((Connector)connector, modulesManager, context);
    }

    public void onStreamManagementFailed(SessionObject sessionObject, XMPPException.ErrorCondition condition) {
        try {
            PresenceStore store = PresenceModule.getPresenceStore((SessionObject)sessionObject);
            if (store != null) {
                store.clear();
            }
        }
        catch (JaxmppException e) {
            e.printStackTrace();
        }
        super.onStreamManagementFailed(sessionObject, condition);
    }

    protected void processStreamFeatures(Element featuresElement) throws JaxmppException {
        Boolean tlsDisabled = (Boolean)this.context.getSessionObject().getProperty("TLS_DISABLED");
        boolean tlsAvailable = SocketConnector.isTLSAvailable(this.context.getSessionObject());
        Boolean compressionDisabled = (Boolean)this.context.getSessionObject().getProperty("COMPRESSION_DISABLED");
        boolean zlibAvailable = SocketConnector.isZLibAvailable(this.context.getSessionObject());
        boolean isConnectionSecure = ((SocketConnector)this.connector).isSecure();
        boolean isConnectionCompressed = ((SocketConnector)this.connector).isCompressed();
        if (!(isConnectionSecure || !tlsAvailable || tlsDisabled != null && tlsDisabled.booleanValue())) {
            ((SocketConnector)this.connector).startTLS();
        } else if (!(isConnectionCompressed || !zlibAvailable || compressionDisabled != null && compressionDisabled.booleanValue())) {
            ((SocketConnector)this.connector).startZLib();
        } else {
            super.processStreamFeatures(featuresElement);
        }
    }
}

