/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.http;

import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.http.upload.db.FileUploadRepository;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="http-api", name="Tigase HTTP API - File Upload", external=false)
public class MongoFileUploadRepository
implements FileUploadRepository<MongoDataSource> {
    private static final String SLOTS = "tig_hfu_slots";
    private MongoDatabase db;
    private MongoCollection<Document> slots;

    public FileUploadRepository.Slot allocateSlot(JID sender, String slotId, String filename, long filesize, String contentType) throws TigaseDBException {
        BareJID bareJid = sender.getBareJID();
        Date date = new Date();
        try {
            Document doc = new Document("_id", (Object)slotId).append("uploader", (Object)sender.toString()).append("domain", (Object)sender.getDomain()).append("resource", (Object)sender.getResource()).append("filename", (Object)filename).append("filesize", (Object)filesize).append("content_type", (Object)contentType).append("status", (Object)0).append("ts", (Object)date);
            this.slots.insertOne((Object)doc);
        }
        catch (MongoWriteException ex) {
            throw new TigaseDBException("Failed to allocate slot for file transfer", (Throwable)ex);
        }
        return new FileUploadRepository.Slot(bareJid, slotId, filename, filesize, contentType, date);
    }

    public FileUploadRepository.Slot getSlot(BareJID sender, String slotId) throws TigaseDBException {
        Document doc = (Document)this.slots.find(Filters.eq((String)"_id", (Object)slotId)).first();
        if (doc == null) {
            return null;
        }
        BareJID bareJID = BareJID.bareJIDInstanceNS((String)doc.getString((Object)"uploader"));
        String filename = doc.getString((Object)"filename");
        long filesize = doc.getLong((Object)"filesize");
        String contentType = doc.getString((Object)"content_type");
        Date ts = doc.getDate((Object)"ts");
        return new FileUploadRepository.Slot(bareJID, slotId, filename, filesize, contentType, ts);
    }

    public List<FileUploadRepository.Slot> listExpiredSlots(BareJID domain, LocalDateTime before, int limit) throws TigaseDBException {
        long timestamp_long = before.toEpochSecond(ZoneOffset.UTC) * 1000L;
        ArrayList<FileUploadRepository.Slot> results = new ArrayList<FileUploadRepository.Slot>();
        for (Document doc : this.slots.find(Filters.lt((String)"ts", (Object)new Date(timestamp_long))).limit(limit).sort(Sorts.ascending((String[])new String[]{"ts"}))) {
            String slotId = doc.getString((Object)"_id");
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)doc.getString((Object)"uploader"));
            String filename = doc.getString((Object)"filename");
            long filesize = doc.getLong((Object)"filesize");
            String contentType = doc.getString((Object)"content_type");
            Date ts = doc.getDate((Object)"ts");
            results.add(new FileUploadRepository.Slot(bareJID, slotId, filename, filesize, contentType, ts));
        }
        return results;
    }

    public void removeExpiredSlots(BareJID domain, LocalDateTime before, int limit) throws TigaseDBException {
        long timestamp_long = before.toEpochSecond(ZoneOffset.UTC) * 1000L;
        ArrayList<String> ids = new ArrayList<String>();
        for (Document doc : this.slots.find(Filters.lt((String)"ts", (Object)new Date(timestamp_long))).limit(limit).projection(Projections.include((String[])new String[]{"_id"}))) {
            ids.add(doc.getString((Object)"_id"));
        }
        this.slots.deleteMany(Filters.in((String)"_id", ids));
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, SLOTS)) {
            this.db.createCollection(SLOTS);
        }
        this.slots = this.db.getCollection(SLOTS);
        this.slots.createIndex((Bson)new Document("ts", (Object)1));
    }

    public void updateSlot(BareJID userJid, String slotId) throws TigaseDBException {
        this.slots.updateOne(Filters.eq((String)"_id", (Object)slotId), Updates.set((String)"status", (Object)1));
    }
}

