/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.dns;

import java.util.Arrays;

public class DNSEntry {
    private String dnsResultHost = null;
    private String hostname = null;
    private String[] ips = null;
    private int port = 5269;
    private int priority = 0;
    private long ttl = 3600000L;
    private int weight = 0;

    public DNSEntry(String hostname, String ip) {
        this.hostname = hostname;
        this.ips = new String[1];
        this.ips[0] = ip;
    }

    public DNSEntry(String hostname, String[] ips) {
        this.hostname = hostname;
        this.ips = ips;
    }

    public DNSEntry(String hostname, String ip, int port) {
        this(hostname, ip);
        this.port = port;
    }

    public DNSEntry(String hostname, String dnsResultHost, String ip, int port, long ttl, int priority, int weight) {
        this(hostname, ip, port);
        this.dnsResultHost = dnsResultHost;
        this.ttl = ttl;
        this.priority = priority;
        this.weight = weight;
    }

    public DNSEntry(String hostname, String dnsResultHost, String[] ips, int port, long ttl, int priority, int weight) {
        this(hostname, ips);
        this.dnsResultHost = dnsResultHost;
        this.port = port;
        this.ttl = ttl;
        this.priority = priority;
        this.weight = weight;
    }

    public String getDnsResultHost() {
        return this.dnsResultHost;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIp() {
        return this.ips[0];
    }

    public String[] getIps() {
        return this.ips;
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTtl() {
        return this.ttl;
    }

    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return "hostname: " + this.dnsResultHost + ", port: " + this.port + ", ip(s): " + Arrays.toString(this.ips) + ", priority: " + this.priority + ", weight: " + this.weight + ", ttl: " + this.ttl / 1000L;
    }
}

