select b2.jid, m2.ts, m2.direction,m2.msg,
		case m2.item_type
			when 'chat' then case m2.type
				when 'groupchat' then 'groupchat'
				else 'chat'
			end
			when 'call' then 'call'
		end as item_type,
		case
			when m2.item_type <> 'call' then null
			when m2.jingle_action='session-accept' or (m2.jingle_action='session-terminate' and m2.jingle_reason = 'success') then 'success'
			when m2.jingle_offline = 1
				or (m2.jingle_action = 'session-terminate' and (
					m2.jingle_reason = 'busy' or m2.jingle_reason = 'timeout'
					or m2.jingle_reason = 'failed-application'
					or (m2.jingle_reason = 'cancel' and m2.direction = 1 and ac.msg_id is null)
				))
				or m2.jingle_action = 'session-initiate' then 'missed'
			else 'canceled'
		end as "condition",
		m2.stanza_hash,
		(unix_timestamp(m2.ts) - unix_timestamp(ac.ts)) as duration
from (
select max(x2.msg_id) as msg_id from (
select x1.owner_id, x1.buddy_id, max(x1.ts) as ts
from
	(select
		m1.msg_id, m1.owner_id, m1.buddy_id, m1.ts,
		case m1.item_type
			when 'chat' then case m1.type
				when 'groupchat' then 'groupchat'
				else 'chat'
			end
			when 'call' then 'call'
		end as item_type,
		case
			when m1.item_type <> 'call' then null
			when m1.jingle_action='session-accept' or (m1.jingle_action='session-terminate' and m1.jingle_reason = 'success') then 'success'
			when m1.jingle_offline = 1
				or (m1.jingle_action = 'session-terminate' and (
					m1.jingle_reason = 'busy' or m1.jingle_reason = 'timeout'
					or m1.jingle_reason = 'failed-application'
					or (m1.jingle_reason = 'cancel' and m1.direction = 1 and
					not exists(select 1 from tig_ma_msgs m0 where m0.owner_id = m1.owner_id and m0.buddy_id = m1.buddy_id and m0.jingle_sid = m1.jingle_sid and m0.jingle_action = 'session-accept' and m0.ts < m1.ts))
				))
				or m1.jingle_action = 'session-initiate' then 'missed'
			else 'canceled'
		end as "condition"
	from tig_ma_msgs m1
	where m1.owner_id = (select jid_id from tig_ma_jids where jid = ?)
	    and (? is null or ts >= ?)
	    and (? is null or ts <= ?)
	    and m1.offline <> 2
	) as x1
where
	(1=? and x1.item_type = 'chat')
	or (1=? and x1.item_type = 'groupchat')
	or (1=? and x1.item_type = 'call' and (
		(1=? and x1.condition = 'success')
		or (1=? and x1.condition = 'missed')
		or (1=? and x1.condition = 'canceled')
	))
group by x1.owner_id, x1.buddy_id
) as x
inner join tig_ma_msgs x2 on x2.owner_id = x.owner_id and x2.buddy_id = x.buddy_id and x2.ts = x.ts
group by x.owner_id, x.buddy_id
) as y
inner join tig_ma_msgs m2 on m2.msg_id = y.msg_id
inner join tig_ma_jids b2 on b2.jid_id = m2.buddy_id
left outer join tig_ma_msgs ac on ac.owner_id = m2.owner_id and ac.buddy_id = m2.buddy_id and ac.jingle_sid = m2.jingle_sid and ac.jingle_action = 'session-accept'
order by m2.ts desc
limit ? offset ?