/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified;

import java.text.ParseException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.archive.MessageArchiveComponent;
import tigase.archive.TimestampHelper;
import tigase.archive.unified.UnifiedArchiveRepositoryWithTigaseQuery;
import tigase.conf.ConfigurationException;
import tigase.db.TigaseDBException;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.RSM;
import tigase.xmpp.XMPPException;

public class UnifiedArchiveComponent
extends MessageArchiveComponent {
    private static final Logger a = Logger.getLogger(UnifiedArchiveComponent.class.getCanonicalName());
    private static final String[] b = new String[]{"iq", "events"};
    private static final String c = "urn:xmpp:tigase:recent";
    private boolean d = false;

    public UnifiedArchiveComponent() {
        this.setName("unified-archive");
    }

    protected boolean addOutPacket(Packet p) {
        List list;
        if (this.d && p.getElemName() == "iq" && (list = p.getElement().getChildrenStaticStr(b)) != null) {
            for (Element element : list) {
                Element element2 = element.getChild("jingle", "urn:xmpp:jingle:1");
                if (element2 == null) continue;
                element2.setXMLNS("tigase:archive:jingle");
            }
        }
        return super.addOutPacket(p);
    }

    protected void processActionElement(Packet packet, Element child) throws PacketErrorTypeException, XMPPException {
        if (child.getXMLNS() == c && child.getName() == "query") {
            this.processQuery(packet, child);
        } else {
            super.processActionElement(packet, child);
        }
    }

    protected void processQuery(Packet packet, Element child) throws PacketErrorTypeException, XMPPException {
        if (!(this.msg_repo instanceof UnifiedArchiveRepositoryWithTigaseQuery)) {
            this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, true));
            return;
        }
        try {
            List list;
            BareJID bareJID = packet.getStanzaFrom().getBareJID();
            Date date = TimestampHelper.parseTimestamp((String)child.getAttributeStaticStr("start"));
            Date date2 = TimestampHelper.parseTimestamp((String)child.getAttributeStaticStr("end"));
            Set<UnifiedArchiveRepositoryWithTigaseQuery.Type> set = null;
            Set<UnifiedArchiveRepositoryWithTigaseQuery.CallCondition> set2 = null;
            Element element2 = child.getChild("event-types");
            if (element2 != null && (list = element2.getChildren()) != null) {
                set = list.stream().map(element -> {
                    try {
                        return UnifiedArchiveRepositoryWithTigaseQuery.Type.valueOf(element.getName());
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }).filter(type -> type != null).collect(Collectors.toSet());
                set2 = list.stream().filter(element -> element.getName() == "call").flatMap(element -> {
                    List list = element.getChildren();
                    return list == null ? Stream.empty() : list.stream();
                }).map(element -> {
                    try {
                        return UnifiedArchiveRepositoryWithTigaseQuery.CallCondition.valueOf(element.getName());
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }).collect(Collectors.toSet());
            }
            if (set == null) {
                set = EnumSet.allOf(UnifiedArchiveRepositoryWithTigaseQuery.Type.class);
            }
            if (set2 == null || set2.isEmpty()) {
                set2 = EnumSet.allOf(UnifiedArchiveRepositoryWithTigaseQuery.CallCondition.class);
            }
            list = new RSM();
            list.fromElement(child);
            List list2 = ((UnifiedArchiveRepositoryWithTigaseQuery)this.msg_repo).queryRecents(bareJID, date, date2, set, set2, (RSM)list).map(this::convertQueryItemResultToElement).collect(Collectors.toList());
            Element element3 = new Element("events", new String[]{"xmlns"}, new String[]{c});
            element3.addChildren(list2);
            element3.addChild((XMLNodeIfc)list.toElement());
            this.addOutPacket(packet.okResult(element3, 0));
        }
        catch (TigaseDBException tigaseDBException) {
            a.log(Level.FINEST, "Failed to retrieve recent query items", tigaseDBException);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, false));
        }
        catch (ParseException parseException) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
    }

    protected Element convertQueryItemResultToElement(UnifiedArchiveRepositoryWithTigaseQuery.Item item) {
        Element element = new Element("event");
        element.setAttribute("with", item.getWith());
        element.setAttribute("direction", item.getDirection().toElementName());
        element.setAttribute("type", item.getItemType());
        element.setAttribute("time", TimestampHelper.format((Date)item.getTimestamp()));
        switch (item.getItemType()) {
            case "chat": 
            case "groupchat": {
                String string;
                String string2 = item.getMessage().getCDataStaticStr(Message.MESSAGE_BODY_PATH);
                if (string2 != null) {
                    string = new Element("body", string2);
                    element.addChild((XMLNodeIfc)string);
                }
                if ((string = item.getMessage().getCDataStaticStr(Message.MESSAGE_SUBJECT_PATH)) == null) break;
                element.setAttribute("subject", XMLUtils.escape((String)XMLUtils.unescape((String)string)));
                break;
            }
            case "call": {
                String string = item.getCondition();
                element.setAttribute("condition", string);
                if (!"success".equals(string) || item.getDuration() == null) break;
                element.setAttribute("duration", String.valueOf(item.getDuration()));
            }
        }
        return element;
    }

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        if (props.containsKey("omit-jingle-xmlns")) {
            this.d = (Boolean)props.get("omit-jingle-xmlns");
        }
    }
}

