/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.MucContext;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.repository.MucDAO;
import tigase.muc.repository.inmemory.InMemoryMucRepository;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class InMemoryMucRepositoryClustered
extends InMemoryMucRepository {
    private RoomListener a;
    private Room.RoomOccupantListener b;

    public InMemoryMucRepositoryClustered(MucContext mucConfig, MucDAO dao) throws RepositoryException {
        super(mucConfig, dao);
    }

    protected void addToAllRooms(BareJID roomJid, InMemoryMucRepository.InternalRoom internalRoom) {
        super.addToAllRooms(roomJid, internalRoom);
    }

    public Room createNewRoom(BareJID roomJID, JID senderJid) throws RepositoryException {
        Room room = super.createNewRoom(roomJID, senderJid);
        this.a(room);
        if (this.a != null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "notifing listener that room {0} was created", roomJID);
            }
            this.a.onRoomCreated(room);
        }
        return room;
    }

    public Room createNewRoomWithoutListener(BareJID roomJID, JID senderJid) throws RepositoryException {
        Room room = super.createNewRoom(roomJID, senderJid);
        this.a(room);
        return room;
    }

    public void destroyRoom(Room room, Element destroyElement) throws RepositoryException {
        super.destroyRoom(room, destroyElement);
        if (this.a != null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "notifing listener that room {0} was destroyed", room.getRoomJID());
            }
            this.a.onRoomDestroyed(room, destroyElement);
        }
    }

    public void destroyRoomWithoutListener(Room room, Element destroyElement) throws RepositoryException {
        super.destroyRoom(room, destroyElement);
    }

    public Room getRoom(BareJID roomJID) throws RepositoryException {
        boolean bl = !this.getActiveRooms().containsKey(roomJID);
        Room room = super.getRoom(roomJID);
        if (bl && room != null) {
            this.a(room);
        }
        return room;
    }

    public void leaveRoom(Room room) {
        super.leaveRoom(room);
        if (this.a != null) {
            this.a.onLeaveRoom(room);
        }
    }

    protected void removeFromAllRooms(BareJID roomJid, Predicate<InMemoryMucRepository.InternalRoom> predicate) {
        InMemoryMucRepository.InternalRoom internalRoom = (InMemoryMucRepository.InternalRoom)this.allRooms.get(roomJid);
        if (internalRoom != null && predicate.test(internalRoom)) {
            this.allRooms.remove(roomJid, internalRoom);
        }
    }

    protected void removeFromAllRooms(BareJID roomJid) {
        super.removeFromAllRooms(roomJid);
    }

    public void leaveRoomWithoutListener(Room room) {
        super.leaveRoom(room);
    }

    public void setRoomListener(RoomListener roomListener) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "setting room listener to {0}", roomListener);
        }
        this.a = roomListener;
    }

    public void setRoomOccupantListener(Room.RoomOccupantListener roomOccupantListener) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "setting room occupants listener to " + this.a);
        }
        this.b = roomOccupantListener;
    }

    protected void roomConfigChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
        super.roomConfigChanged(roomConfig, modifiedVars);
        this.a.onRoomChanged(roomConfig, modifiedVars);
    }

    protected void roomConfigChanged(BareJID roomJid, Map<String, String> values) {
        Object object;
        InMemoryMucRepository.InternalRoom internalRoom = (InMemoryMucRepository.InternalRoom)this.allRooms.get(roomJid);
        if (internalRoom != null) {
            if (values.containsKey("muc#roomconfig_publicroom")) {
                object = values.get("muc#roomconfig_publicroom");
                internalRoom.isPublic = "1".equals(object) || "true".equals(object);
            }
            if (values.containsKey("muc#roomconfig_roomname")) {
                internalRoom.name = values.get("muc#roomconfig_roomname");
            }
            if (values.containsKey("muc#roomconfig_persistentroom")) {
                object = values.get("muc#roomconfig_persistentroom");
                boolean bl = internalRoom.isPersistent = "1".equals(object) || "true".equals(object);
            }
        }
        if ((object = (Room)this.rooms.get(roomJid)) != null) {
            for (Map.Entry<String, String> entry : values.entrySet()) {
                String[] stringArray = null;
                if (entry.getValue() != null) {
                    stringArray = entry.getValue().split("\\|");
                }
                object.getConfig().setValues(entry.getKey(), stringArray);
            }
        }
    }

    private void a(Room room) {
        if (this.b != null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "adding room occupant listener for room {0}", room.getRoomJID());
            }
            room.addOccupantListener(this.b);
        }
        if (this.a != null && this.a instanceof Room.RoomListener) {
            room.addListener((Room.RoomListener)this.a);
        }
    }

    public static interface RoomListener {
        public void onRoomChanged(RoomConfig var1, Set<String> var2);

        public void onRoomCreated(Room var1);

        public void onRoomDestroyed(Room var1, Element var2);

        public void onLeaveRoom(Room var1);
    }
}

