/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.muc.Room;
import tigase.muc.cluster.InMemoryMucRepositoryClustered;
import tigase.muc.cluster.MUCComponentClustered;
import tigase.muc.cluster.StrategyIfc;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public abstract class AbstractStrategy
implements Room.RoomOccupantListener,
StrategyIfc {
    private static final Logger a = Logger.getLogger(AbstractStrategy.class.getCanonicalName());
    private static final String b = "muc-packet-forward-cmd";
    private static final String c = "muc-occupant-added-cmd";
    private static final String d = "muc-occupant-removed-cmd";
    protected static final String REQUEST_SYNC_CMD = "muc-sync-request";
    protected ClusterControllerIfc cl_controller;
    protected JID localNodeJid;
    protected MUCComponentClustered muc;
    protected InMemoryMucRepositoryClustered mucRepository = null;
    private final a e = new a();
    private final b f = new b();
    private final c g = new c();

    @Override
    public List<JID> getNodesConnected() {
        return this.muc.getNodesConnected();
    }

    @Override
    public List<JID> getNodesConnectedWithLocal() {
        return this.muc.getNodesConnectedWithLocal();
    }

    @Override
    public void nodeConnected(JID nodeJid) {
        if (!this.localNodeJid.equals((Object)nodeJid)) {
            this.requestSync(nodeJid);
        }
    }

    public void onOccupantAdded(Room room, JID occupantJid) {
        String string = room.getOccupantsNickname(occupantJid);
        if (this.addOccupant(this.localNodeJid.getBareJID(), room.getRoomJID(), occupantJid, string)) {
            List<JID> list = this.getNodesConnected();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("room", room.getRoomJID().toString());
            hashMap.put("userId", occupantJid.toString());
            hashMap.put("occupant-nickname", string);
            if (a.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder(100);
                for (JID jID : list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(jID.toString());
                }
                a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that occupant {2} joined room {3}", new Object[]{room.getRoomJID(), stringBuilder, occupantJid, room.getRoomJID()});
            }
            this.cl_controller.sendToNodes(c, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
        }
    }

    public void onOccupantRemoved(Room room, JID occupantJid) {
        if (this.removeOccupant(this.localNodeJid.getBareJID(), room.getRoomJID(), occupantJid)) {
            List<JID> list = this.getNodesConnected();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("room", room.getRoomJID().toString());
            hashMap.put("userId", occupantJid.toString());
            if (a.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder(100);
                for (JID jID : list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(jID.toString());
                }
                a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that occupant {2} left room {3}", new Object[]{room.getRoomJID(), stringBuilder, occupantJid, room.getRoomJID()});
            }
            this.cl_controller.sendToNodes(d, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
        }
    }

    protected void sendRemoteOccupantRemovalOnDisconnect(Room room, JID occupant, String occupantNick, boolean sendRemovalToOccupant) {
        for (String string : room.getOccupantsNicknames()) {
            Collection collection = room.getOccupantsJidsByNickname(string);
            for (JID jID : collection) {
                this.a(JID.jidInstanceNS((BareJID)room.getRoomJID(), (String)occupantNick), jID);
            }
        }
        if (sendRemovalToOccupant) {
            this.sendRemovalFromRoomOnNodeDisconnect(room.getRoomJID(), occupant);
        }
    }

    protected void sendRemovalFromRoomOnNodeDisconnect(BareJID roomJid, JID occupant) {
        this.a(roomJid.toString(), occupant, false);
    }

    private void a(JID jID, JID jID2) {
        this.a(jID.toString(), jID2, true);
    }

    private void a(String string, JID jID, boolean bl) {
        try {
            Element element = new Element("presence", new String[]{"xmlns", "from", "to", "type"}, new String[]{"jabber:client", string.toString(), jID.toString(), "unavailable"});
            Element element2 = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
            element.addChild((XMLNodeIfc)element2);
            Element element3 = new Element("item", new String[]{"role"}, new String[]{"none"});
            element2.addChild((XMLNodeIfc)element3);
            if (bl) {
                element3.addChild((XMLNodeIfc)new Element("reason", "MUC component is disconnected."));
                element2.addChild((XMLNodeIfc)new Element("status", new String[]{"code"}, new String[]{"332"}));
            }
            this.muc.addOutPacket(Packet.packetInstance((Element)element));
        }
        catch (TigaseStringprepException tigaseStringprepException) {
            a.log(Level.FINE, "Problem on throwing out occupant {0} on node disconnection", new Object[]{jID});
        }
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.cl_controller != null) {
            this.cl_controller.removeCommandListener((CommandListener)this.e);
            this.cl_controller.removeCommandListener((CommandListener)this.f);
            this.cl_controller.removeCommandListener((CommandListener)this.g);
        }
        this.cl_controller = cl_controller;
        if (cl_controller != null) {
            this.cl_controller.setCommandListener((CommandListener)this.e);
            this.cl_controller.setCommandListener((CommandListener)this.f);
            this.cl_controller.setCommandListener((CommandListener)this.g);
        }
    }

    @Override
    public void setMucComponentClustered(MUCComponentClustered mucComponent) {
        this.setLocalNodeJid(JID.jidInstanceNS((String)mucComponent.getName(), (String)mucComponent.getDefHostName().getDomain(), null));
        this.muc = mucComponent;
    }

    @Override
    public void setMucRepository(InMemoryMucRepositoryClustered mucRepository) {
        this.mucRepository = mucRepository;
    }

    protected void forwardPacketToNode(JID nodeJid, Packet packet) {
        this.cl_controller.sendToNodes(b, packet.getElement(), this.localNodeJid, null, new JID[]{nodeJid});
    }

    protected void setLocalNodeJid(JID jid) {
        this.localNodeJid = jid;
    }

    protected abstract boolean addOccupant(BareJID var1, BareJID var2, JID var3, String var4);

    protected abstract boolean removeOccupant(BareJID var1, BareJID var2, JID var3);

    protected void requestSync(JID nodeJid) {
        this.cl_controller.sendToNodes(REQUEST_SYNC_CMD, this.localNodeJid, new JID[]{nodeJid});
    }

    private class c
    extends CommandListenerAbstract {
        public c() {
            super(AbstractStrategy.b, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (packets != null && !packets.isEmpty()) {
                for (Element element : packets) {
                    try {
                        Packet packet = Packet.packetInstance((Element)element);
                        if (a.isLoggable(Level.FINEST)) {
                            a.log(Level.FINEST, "received packet {0} forwarded from node {1}", new Object[]{packet, fromNode});
                        }
                        if (AbstractStrategy.this.muc.addPacketNB(packet)) {
                            if (!a.isLoggable(Level.FINEST)) continue;
                            a.log(Level.FINEST, "forwarded packet added to processing queue of component = {0}", packet.toString());
                            continue;
                        }
                        a.log(Level.FINE, "forwarded packet dropped due to component queue overflow = {0}", packet.toString());
                    }
                    catch (TigaseStringprepException tigaseStringprepException) {
                        a.log(Level.FINEST, "Addressing problem, stringprep failed for packet: {0}", element);
                    }
                }
            }
        }
    }

    private class b
    extends CommandListenerAbstract {
        public b() {
            super(AbstractStrategy.d, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            JID jID = JID.jidInstanceNS((String)data.get("userId"));
            AbstractStrategy.this.removeOccupant(fromNode.getBareJID(), bareJID, jID);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that occupant {1} left room {2} at node {3}", new Object[]{bareJID, jID, bareJID, fromNode});
            }
        }
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super(AbstractStrategy.c, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            JID jID = JID.jidInstanceNS((String)data.get("userId"));
            String string = data.get("occupant-nickname");
            AbstractStrategy.this.addOccupant(fromNode.getBareJID(), bareJID, jID, string);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that occupant {1} joined room {2} at node {3}", new Object[]{bareJID, jID, bareJID, fromNode});
            }
        }
    }
}

